+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-01-11T17:33:00-05:00"
lastmod = "2018-01-12T13:57:00-05:00"
preamble = "As part of Utah Opera's 40th anniversary season, Jake Heggie's *Moby-Dick* will see its first new staging since its original production, premiered at The Dallas Opera in 2010. Kristine McIntyre directs the new production, running **January 20-28**; *Moby-Dick* marks her latest collaboration with Heggie, after directing his *Dead Man Walking* (Des Moines Metro Opera, Madison Opera) and *The End of the Affair* (Lyric Opera of Kansas City).\n\nWe spoke with McIntyre about the unique responsibility of directing a contemporary opera, and her take on the role of the opera director."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515718883616/2018-01-11---Moby-Dick-sq.jpg.jpg"
primary_image_credit = "Roger Honeywell as Captain Ahab in Kristine McIntyre's production of Moby-Dick, Utah Opera, 2018. Photo courtesy of Utah Opera."
publishDate = "2018-01-11T20:13:00-05:00"
related_companies = ["scene/companies/utah-opera.md"]
related_people = ["scene/people/roger-honeywell.md"]
short_description = "&quot;I think Moby-Dick is ultimately about the redeeming power of friendship - and how an open heart can literally save your life. It&#039;s no accident that in both the book and the opera, Greenhorn (Ishmael) is saved from drowning by floating on the coffin on his new dear friend Queequeg, who is a &#039;foreigner&#039; and a &#039;savage.&#039;&quot;"
slug = "moby-dick-a-story-about-obsession"
title = "Moby-Dick: &quot;A story about obsession.&quot;"

+++
### What are some unique pressures/challenges that come with creating a new production of a well-received contemporary opera? How do these differ from presenting a new production of a more traditional staple like *La bohème* or *Le nozze di Figaro*?

I think the biggest issue is that when people see a world premiere of a new American opera, they think that the production is the piece. But there's always more story to tell, different choices to be made. For *Moby-Dick* in particular, because the original production was based almost entirely on projections, some people have trouble seeing beyond that to the opera itself. They don't know if the piece can exist beyond those particular visuals. But of course, this is a wonderful piece, and there is so much in it, and I can't wait to show people another vision of the opera. I have a completely different take on it, so it's really about getting people to come and experience the piece anew. 

When you are doing operas that are part of the traditional rep, you face a related set of challenges, but at least with something like *Nozze di Figaro*, if the production is bad, people still know the opera is a masterpiece. With a newer work like *Moby-Dick*, most of the audience will be experiencing the show for the first time with our production, so I have a responsibility both to my own vision and to show the piece off really well - I have to get it right! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515718719530/2018-01-11---DSC03035.jpg.jpg)
<figcaption>Set design by Erhard Rom in progress for *Moby-Dick*. Image courtesy of Utah Opera.</figcaption>
</figure>

## What do you think *Moby-Dick* is about? How does the message of the opera differ from that of the book?

I think *Moby-Dick* is ultimately about the redeeming power of friendship - and how an open heart can literally save your life. It's no accident that in both the book and the opera, Greenhorn (Ishmael) is saved from drowning by floating on the coffin on his new dear friend Queequeg, who is a "foreigner" and a "savage." Whaling brought Melville into contact with people from many different races and ethnic backgrounds and he quickly learned to appreciate all that their cultures had to teach him.  The book and the opera are both infused with that broad, democratic spirit. 

It's also a story about obsession, of course, and about the destruction of the human soul by its own dark demons. So I guess you could say *Moby-Dick* is about both the best that humanity can be, and the worst. 

It's dark and light, all in the same piece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515718777149/2018-01-11---Kristine-McIntyre.jpg.jpg)
<figcaption>Kristine McIntyre, stage director.</figcaption>
</figure>

## How would you describe the "old-school theater technology" you'll use for this production?

And by old school, of course, we mean anything that wasn't invented in the past 10 years! No, we're just using a broad array of traditional theater craft, and we are actually incorporating a little of the newer stuff, too. We're just not relying on that. This is actually a very modern, somewhat abstract and visually-stunning production, and one which creates an actual physical world for the singers and dancers to interact with. It's also a more flexible production so that a broader array of companies will now be able to do this wonderful opera.  

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/JkNG1_Hz6C0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

## What do you think is the role of the opera director?

Everything! Sometimes people ask me what a director does, and I tell them that I am responsible for everything they see on the stage. But I've come to realize it's actually so much more than that, because in creating the concept for a large-scale new production like this, I've actually already influenced every choice the singers will make and how the piece will sound as a result. 

On a show like this, it's no different than being a film director. Many, many artists will contribute to the final product, but at the end of the day, it all filters through my vision and I'm the one responsible for making sure that all of those choices are part of the same world, that we are all telling the same story. 

I often say that at the beginning of the process (and for me, which started in the spring of 2015) I'm the most important person in the room because the whole show is in my head. By opening night, I have to be the least important person in the room because the show needs to belong entirely to the singers and the conductor - and I need to be able to fly home the next day. So the entire production process is me slowly bringing people into the world in my head and then giving it all to them.

>Utah Opera's [*Moby-Dick*](https://my.usuo.org/single/PSDetail.aspx?_sp=bd45ad885e0b32e1.1515719348288&psn=18078&_ga=2.220197466.233418363.1515717030-1587196307.1515717030) runs January 20-28. For details and ticket information, follow our box office links below.