+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = "2019-04-07T17:12:30+00:00"
disclaimer = ""
image_gallery = []
postamble = "_The Barber of Seville_ runs at Manitoba Opera through April 12. For details and ticket information, [click here](https://mbopera.ca/season/the-barber-of-seville/). "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554760004/media/2019/04/sqTNK1285.jpg"
primary_image_credit = "Elliot Madore as Figaro in The Barber of Seville, Manitoba Opera, 2019. Photo: R. Tinker."
related_articles = ["articles/laughing-out-loud-the-barber-of-seville-at-eno.md", "articles/a-perfect-fit-the-overcoat.md"]
related_companies = ["scene/companies/manitoba-opera.md"]
related_people = ["scene/people/andrea-lett.md", "scene/people/elliot-madore.md", "scene/people/andrew-owens.md", "scene/people/giles-tomkins.md", "scene/people/andrea-hill.md"]
short_description = "The highly engaged audience was obviously enthralled with all elements of this production, laughing uproariously at onstage antics and giving hearty applause where appropriate (including at one especially effective lighting gag)."
slug = "a-timeless-treat-manitoba-operas-barber-of-seville"
title = "A timeless treat: Manitoba Opera's Barber of Seville"
youtube_url = ""

+++
Occasionally opera transcends the limitations of its genre and becomes simply a highly entertaining night at the theatre, albeit with some of the best music ever written, performed by full symphony orchestra and world-class singers. Manitoba Opera's _Barber of Seville_ is one of those occasions. Opera is, first and foremost, theatre, and it is the theatrical element of opera that I found especially intriguing tonight. I forgot that I was seeing an opera as I became enamoured with the characters, intrigued by their motivations, and utterly engrossed in this farcical Rossini tale that includes multiple disguises, star-crossed lovers, a clever barber and many hilarious sight gags.

> It's not often you can come away from an opera being impressed at how good the direction and acting is, but it's certainly the case here.

It's easy to forget that these performers, besides being excellent actors, also happen to possess incredible voices, the product of a lot of high-end training, drive and, to a certain extent, winning some sort of DNA lottery. This happy confluence enables them to sing the remarkably ornate music that Rossini has created for this piece, and be heard unamplified over an orchestra. It's pretty amazing when you stop and think about it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760081/media/2019/04/RWT1037.jpg){{% /md %}}

<figcaption>Andrea Hill (Rosina), Andrew Owens (Almaviva), Steven Condy (Dr. Bartolo), and Elliot Madore (Figaro) in The Barber of Seville, Manitoba Opera, 2019. Photo: R. Tinker.</figcaption>

</figure>

The highly engaged audience was obviously enthralled with all elements of this production, laughing uproariously at onstage antics and giving hearty applause where appropriate (including at one especially effective lighting gag). It's not often you can come away from an opera being impressed at how good the direction and acting is, but it's certainly the case here. Rossini's music, with a libretto by Sterbini after the original story by the French playwright Beaumarchais (whose next play in his trilogy was set by Mozart and DaPonte as _Marriage of Figaro_) certainly gives the performers and creative team plenty of great material.

There were even some funny self-deprecating moments from the composer/librettist team, like when a character sings an aria from a new opera apparently called _The Futile Precaution_ (which was in reality the working title for this opera) and another bemoans opera as boring and slow-moving. It's almost as if Rossini wanted to make sure any audience watching this opera never felt that way. As an opera composer myself, the number one rule is "never bore the audience", and Rossini and Sterbini were obviously strong proponents of that concept.

> Our main character, the crafty barber Figaro (Elliot Madore) entered with a confident swagger flashing his megawatt smile,

The plot is too complicated and labyrinthine to go into detail here, but ultimately it all makes perfect sense when you see it come to life onstage. The winsome and fantastical set, from the brilliant creative team of Morris Panych and Ken MacDonald, and the striking lighting effects (here implemented by Bill Williams, initial design by Kimberly Purtell) were akin to another character in the show. I don't often notice things like lighting and costumes (which were designed by Dana Osborne), but even small design details like costumes catching the curvilinear designs on the set, and indeed the circular swirl of the set pieces, amplified by well-choreographed umbrellas brandished by the cast, all made for very appealing eye candy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760138/media/2019/04/MbOpera_BarberOfSeville_APRIL4_0492.jpg){{% /md %}}

<figcaption>Elliot Madore (Figaro) and Steven Condy (Dr. Bartolo) in The Barber of Seville, Manitoba Opera, 2019. Photo: C. Corneau.</figcaption>

</figure>

Huge kudos to director Alain Gauthier for his highly imaginative concept and fast-paced staging of this work. It was all so fun! (another word not used often enough to describe opera). The performers' dedication to their multifaceted characters showed how much they bought into Gauthier's concept. The cast was quasi tongue-in-cheek, effectively saying the the audience, "yes we know how silly this is, but just come along for the ride and you won't regret it". Gauthier never ran out of good ideas, be they large and conceptual, or small smart visual puns.

(It’s hard for me to listen to the famous overture to this work without hearing Bugs Bunny and Elmer Fudd's voices, added sounds effects like cannons, and wacky added instruments like xylophone and musical saw. _The Rabbit of Seville_ was my first introduction to classical music as a child, and as an opera composer, I realize that this was the start of my musical formation.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760176/media/2019/04/MbOpera_BarberOfSeville_APRIL4_0147.jpg){{% /md %}}

<figcaption>A scene from The Barber of Seville, Manitoba Opera, 2019. Photo: C. Corneau.</figcaption>

</figure>

Our main character, the crafty barber Figaro ([Elliot Madore](/scene/people/elliot-madore/)) entered with a confident swagger flashing his megawatt smile, and within moments we had a full characterization of who this multi-talented barber really is. His opening aria (again made even more famous by a Bugs Bunny cartoons) was as entertaining to watch as it was wonderful to hear.  Madore was a captivating presence onstage, he seemed always in motion, responding to the action naturally and filling out his character with many fine details of posture and physical expression.

> As Don Basilio, [Giles Tomkins](/scene/people/giles-tomkins/) used his height and long legs to great comedic advantage

As Count Almaviva/A drunken soldier/Lindoro/Don Alonso, [Andrew Owens](/scene/people/andrew-owens/) gave all these characters their own unique look, vocal affect and personality. His piano playing sight gag was especially hilarious and had the audience in stitches. I really loved how he used all the ranges and dynamics of his voice, singing in a soft pianissimo that somehow still travelled in the large hall, to a full lyric tenor sound with clear and precise coloratura. As Dr. Bartolo, Steven Condy showed a huge range as an actor, with  commensurate range in his sung lyrics. He imparted the perfect combination of humour, slight pathos, and buffo into his character, and was always entertaining to watch and lovely to listen to.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760249/media/2019/04/MbOpera_BarberOfSeville_APRIL4_0228.jpg){{% /md %}}

<figcaption>Steven Condy (Dr. Bartolo) and Giles Tomkins (Basilio) in The Barber of Seville, Manitoba Opera, 2019. Photo: C. Corneau.</figcaption>

</figure>

As Rosina, [Andrea Hill](/scene/people/andrea-hill/) was a vocal and dramatic standout, her character's feisty and clever personality always in evidence, her singing always beautiful. A highlight for me was when she was "singing" as part of her "lesson" with "Don Alonso", and her character’s singing tone was flat and lifeless, but once "Don Alonso", her music tutor (in reality her lover Almaviva), got involved, her character reverted back to a full rich sound. Winnipeg product [Andrea Lett](/scene/people/andrea-lett/) made the most of the role of Berta the maid, with some great acting, fine singing, and some wry philosophical observations in her aria. Her interactions with the other characters always had perfect comic timing and her expressions were priceless. As Don Basilio, [Giles Tomkins](/scene/people/giles-tomkins/) used his height and long legs to great comedic advantage, at times silly-walking around the stage while singing beautifully, portraying his character's dissemblance with fervour and glee.

> Manitoba Opera's _The Barber of Seville_ is a very special, timeless treat.

Maestro Tyrone Paterson did a admirable job leading the Winnipeg Symphony Orchestra. Voices in Rossini are usually lighter in texture - to enable the singing the rapid florid passages - and the balance between the orchestra and voices was perfect. The Manitoba Opera Men's Chorus, led by Tadeusz Biernacki, did especially well handling some tricky music, and were very effective and detailed in their staging and expression.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760287/media/2019/04/RWT0875.jpg){{% /md %}}

<figcaption>A scene from The Barber of Seville, Manitoba Opera, 2019. Photo: R. Tinker.</figcaption>

</figure>

Manitoba Opera's _The Barber of Seville_ is a very special, timeless treat. Once the curtain went up on the magical set I was immediately transported to the creative team's world. All the acting seemed so real, so improvised almost, that the characters' interactions onstage seemed natural, with just the right amount of camp to make it fun for the audience, and probably for the performers themselves.

Singers amaze me for many reasons, and to see these talented performers so well-directed by M. Gauthier in such a satisfying performance as was witnessed tonight, really makes my heart sing.