+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = "2024-04-16T00:00:00+01:00"
lastmod = "2024-04-17T00:00:00+01:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1713282681/sqMO_Carmen_MO_2024.jpg"
primary_image_credit = "(l-r) Lara Secord-Haid (Frasquita), Jacques Arsenault (Le Remendado), Barbara King (Mercédès), Johnathon Kirby (Le Dancaïre), and Ginger Costa-Jackson (Carmen) in Carmen, Manitoba Opera, 2024. Photo: R. Tinker."
postamble = ""
publishDate = "2024-04-16T00:00:00+01:00"
related_articles = ["articles/the-ensemble-from-heaven-sends-don-giovanni-to-hell.md", "articles/fantasy-is-for-the-birds.md", "articles/in-review-carmen-at-nashville-opera.md"]
related_companies = ["scene/companies/manitoba-opera.md"]
related_people = ["scene/people/lara-secord-haid.md", "scene/people/david-pomeroy.md", "scene/people/daniel-okulitch.md", "scene/people/giles-tomkins.md", "scene/people/lara-ciekiewicz.md", "scene/people/ginger-costa-jackson.md"]
short_description = "For Carmen the opera to really succeed, you need an exceptional Carmen like Ms. Costa-Jackson."
slug = "stellar-singing-lots-of-swagger-in-manitoba-operas-carmen"
title = "Stellar singing and lots of swagger in Manitoba Opera's Carmen"
+++
On Saturday, April 13th, 2023 at the Centennial Concert Hall in Winnipeg, [Manitoba Opera](/scene/companies/manitoba-opera/) presented their pandemic-delayed production of Georges Bizet's _Carmen_. In 2020, the production was in the middle of rehearsals when the world was shut down. Needless to say, the time between then and now has been a very rough one for the arts sector in general, but Saturday's performance was sold out and ticket sales are strong for the two remaining performances, pointing to probable sell-outs.

Carmen is the world's most popular opera, and for good reason. Eminently hummable tunes (they're still going through my head as I write this), excellent orchestrations, a story set against a larger social backdrop that reflects the politics of the time, a libretto packed with drama, action, tension, love, betrayal and (spoiler alert!) murder -- _Carmen_ has everything for both the seasoned opera-lover and the newbie.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713282685/MO_Ginger_Costa-Jackson_Carmen_David_Pomeroy_Don_Jose_MO_Carmen_2024.jpg){{% /md %}}

<figcaption>David Pomeroy as Don José and Ginger Costa-Jackson as Carmen in Carmen, Manitoba Opera, 2024. Photo: R. Tinker.</figcaption>
</figure>

It was so touching to see a tribute to acclaimed Canadian opera director and librettist Michael Cavanagh in the program. Michael was a dear friend and operatic collaborator of this reviewer early in our careers -- he as librettist and I as composer for four operas. He is sorely missed by me and by the opera community in Winnipeg, across Canada and abroad, as well as his family. His legacy of opera works, his kindness and warmth, and the stories around his artistry directing over 150 opera productions will live on. As I was listening to the superb kids chorus tonight (huge props to Children's Chorus Master Carolyn Boyes), where Michael got his start in opera, I couldn't help thinking how lucky those kids are to be involved in such a great production, and I hope some of them go on to also have careers in the arts.

The whole cast and chorus were in fine voice on opening night. The Manitoba Opera Chorus, ably directed by Tadeusz Biernacki for the last 41(!) years, sounded great. This is a very fun opera for the chorus, as they are prominently involved in the drama. Their diction was crisp, their tuning impeccable, and they were always in very tight ensemble with the orchestra and principal singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713282681/MO_David_Pomeroy_Don_Jose_Lara_Ciekiewicz_Micaela_MO_Carmen_2024.jpg){{% /md %}}

<figcaption>David Pomeroy as Don José and Lara Ciekiewicz as Micaëla in Carmen, Manitoba Opera, 2024. Photo: R. Tinker.</figcaption>
</figure>

[Daniel Okulitch](/scene/people/daniel-okulitch/)'s Escamillo was a Toreador full of swagger and bravado, his characterization supported by extremely beautiful singing and postural flourishes. Okulitch does these types of roles exceedingly well -- I was brought back to his stunning, oily Don Giovanni with Manitoba Opera in 2018. As Carmen's friend Mercédès, [Barbara King](https://mezzoking.com/) showcased her hugely powerful and affecting voice, and she is a great dancer as well -- I'm sure her days as a championship gymnast inform her physical presence.

[Lara Ciekiewicz](/scene/people/lara-ciekiewicz/)' portrayal of Micaëla, a teenage country girl in love with Don José, was exquisitely sung, with much lyricism and effective changes in dynamics, the latter especially hard to do in a house this size unless you have a tremendous instrument like hers. Ms. Ciekiewicz' physical portrayal of the teenager was very convincing -- from the slight awkwardness in her posture, her youthful gait, her shyness, which then developed to her final stare-down with Carmen -- it was all part of a lovely portrayal of this ultimately tragic character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713282680/MO_Daniel_Okulitch_Escamillo_and_Ginger_Costa-Jackson_Carmen_MO_Carmen_2024.jpg){{% /md %}}

<figcaption>Daniel Okulitch as Escamillo and Ginger Costa-Jackson as Carmen in Carmen, Manitoba Opera, 2024. Photo: R. Tinker.</figcaption>
</figure>

As Don José, [David Pomeroy](/scene/people/david-pomeroy/) was outstanding in this signature role for him. His physicality (including a couple of fights) and gradual turning towards obsession and murder was finely wrought. My only regret was that his French was missing _une certaine délicatesse_, but this is a mere quibble -- his voice is resonant and rich, his phrasing superb. [Giles Tomkins](/scene/people/giles-tomkins/)' Zuniga, the lieutenant who is Don José's boss (and sometimes his rival), was appropriately authoritarian, sung with power and conviction. 

[Johnathon Kirby](/scene/people/johnathon-kirby/) and [Jacques Arsenault](/scene/people/jacques-arsenault/), playing the smugglers Le Dancaïre and Le Remendado respectively, made the most of their time onstage, with fine singing, engaging physicality and mugging when appropriate. One of the highlights of the opera for me is always the hugely difficult quintet in Act II. It rockets along at an alarmingly fast pace, but all the singers and the Winnipeg Symphony Orchestra somehow managed to keep it together under the skilled direction of maestro Tyrone Paterson for a rollicking, rowdy bit of virtuosic vocal fireworks. Also involved in this quintet was Frasquita, Carmen's friend, sung compellingly by [Lara Secord-Haid](/scene/people/lara-secord-haid/), another local singer who is much in demand lately, here and most especially in Europe. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713282681/MO_MO_Carmen_2024_Ginger_Costa-Jackson_Carmen.jpg){{% /md %}}

<figcaption>Ginger Costa-Jackson (centre) in the title role of Carmen, Manitoba Opera, 2024. Photo: R. Tinker.</figcaption>
</figure>

As the title character Carmen, [Ginger Costa-Jackson](/scene/people/ginger-costa-jackson/) was fiery, lusty, thrilling, playful, threatening, and all the while sung with her lush, rich mezzo-soprano voice. Contributing to her convincing Carmen as an impetuous and capricious vixen was a fair amount of chair-throwing, plus plenty of vibrant movement, powerful poses, and dramatic flair. For Carmen the opera to really succeed, you need an exceptional Carmen like Ms. Costa-Jackson.

Congratulation to Larry Desrochers, CEO of Manitoba Opera for assembling such a stellar cast, many of whom were brought back from the interrupted 2020 production. This is my fifth performance experiencing _Carmen_ but I still share in the thrill of first-timers, who would have discovered a bunch of music they had heard previously (maybe even some on _Bugs Bunny_ cartoons?), given this opera's huge appeal and massive popularity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713282681/MO_Carmen_2024.jpg){{% /md %}}

<figcaption>A scene from Carmen, Manitoba Opera, 2024. Photo: R. Tinker.</figcaption>
</figure>

I would be remiss to not mention my gratitude to Larry Desrochers, Manitoba Opera Production Manager Sheldon Johnson and the entire team at Manitoba Opera for producing my eigth opera, _Li Keur, Riel's Heart of the North_, co-composed with Métis fiddler and composer Alex Kusturok to a libretto by Suzanne Steele, as the opening production of their 2023-24 season. The entire company worked tirelessly for many months on this large and complex production, and I know I speak for all opera fans (including many new ones for whom _Li Keur_ was their first opera) in expressing gratitude for presenting this historic production.