+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-10T23:43:00-04:00"
lastmod = "2015-04-10T23:43:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428723797394/MetExterior_Fotor.jpg.jpg"
publishDate = "2015-02-25T09:13:00-05:00"
related_articles = ["articles/teddy-roosevelt-the-chicago-cubs-operas-by-women-at-the-met.md","articles/opera-by-the-numbers.md","articles/the-mets-201819-seaszzzzzzzzz.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "It’s old news by now, but the Metropolitan Opera has announced its season line-up for 2015/2016. I waited a bit before writing about the season, because I couldn’t seem to shake distinct feelings of exasperation. I figured that someone with more journalistic experience than myself would soon weigh in, shedding some light on what I thought were glaringly obvious problems with the Met’s 15/16 season."
slug = "missing-the-point-the-mets-201516-season"
title = "Missing the point: the Met&#039;s 2015/16 season"
+++

<p>
	It's old news by now, but the <a href="http://www.metopera-digital.org/metmobile/2015-16_season_subscriptions#pg1" target="_blank">Metropolitan Opera has announced its season line-up for 2015/2016</a>. I waited a bit before writing about the season, because I couldn't seem to shake distinct feelings of exasperation. I figured that someone with more journalistic experience than myself would soon weigh in, shedding some light on what I thought were glaringly obvious problems with the Met's 15/16 season.
</p>
<p>
	For example, there's nothing in English; yes, the productions of <em>The Barber of Seville</em> and <em>Die Fledermaus</em> are going to be sung in English, but those translations are usually lame and it's not really <em>opera in English</em>. Even if we put the language issue aside, it's a pretty conservative season. There are 24 shows in the Met's 2015/16 season, including 6 new productions, and <em>Lulu</em> (1935) is the most contemporary piece on the line-up.
</p>
<p>
	Even if I were to make a case for bringing back so many standards from the repertoire (<em>Tosca</em>,<em>Turandot</em>, <em>Don Pasquale</em>), the revolving door of casting negates the whole point of these pieces. Call me naïve, but when four sopranos and three tenors juggle the roles of Tosca and Cavaradossi in a single production, you're not going to see real drama entwined with music. Same thing with the three Turandots and two Calafs. The odds of ending up with a phoned-in production are astronomical.
</p>
<p>
	Now, amongst all the usual operatic suspects, there are things to get excited about. <a href="http://citizen.co.za/afp_feed_article/met-opera-aims-for-broader-audience-with-season-of-classics/" target="_blank">Shaun Tandon at <em>The Citizen</em></a> calls looks at it differently, calling it a "season of classics" aimed at recruiting broader audiences. I mean, there's Sondra's <a href="http://www.thestar.com/entertainment/2014/04/18/sondra_radvanovsky_tackles_operas_triple_crown.html" target="_blank">Three Queens Trilogy;</a> we get to see<em>Lulu</em> and <em>Elektra</em> in one season; Dolora Zajick's Azucena is not to be missed.
</p>
<p>
	It's not like there's nothing for me to look forward to at the Met next year, but frankly, I'm not the audience they need to convince.
</p>
<p>
	What confuses me the most about the 2015/16 season is how much it resembles the last ones. The Met saw a hellish summer of 2014, with bitter union negotiations with the orchestra and chorus members, and <a href="http://www.businessinsider.com/afp-met-opera-credit-rating-downgraded-despite-labor-deal-2014-12" target="_blank">their credit rating was downgraded</a> a few months later. The public learned more about the Met's reliance on donors, and we all found out the <a href="http://www.theguardian.com/music/2014/jun/06/new-york-met-opera-house-edge-precipice" target="_blank">price of those poppies</a>.
</p>
<p>
	I want to mention that definition of insanity, where it's when you keep doing the same thing while expecting different results. I want to ask why the Met is still putting out 24 shows after facing a very large, very obvious financial conundrum. To be fair, there are small steps being made,<a href="http://www.nytimes.com/2015/02/19/arts/music/metropolitan-opera-unveils-a-season-of-big-stars-and-6-new-operas.html" target="_blank"> vague as they may be</a>. The Met has introduced "Fridays under Forty", where on select Friday nights, people under 40 can get tickets for $60 or $100. They're also pushing back the curtain times on those nights from 7:30 to 8pm, to accommodate the work hours of under-40s, <a href="http://www.nytimes.com/2015/02/19/arts/music/metropolitan-opera-unveils-a-season-of-big-stars-and-6-new-operas.html" target="_blank">which are apparently longer</a>.
</p>
<p>
	From where I'm sitting, the arts have been learning to adapt to modern cultural and financial climates, and the opera scene is no longer exempt from the task. Younger generations no longer see opera as something to preserve, because they have no personal or cultural connection to it. In short, the standard operas (<em>La boheme, </em><em>La traviata</em>) no longer sell themselves. The Metropolitan Opera's answer to the question of pulling in a new audience is a season full of standard operas, many of which are in revival productions (Zeffirelli's <em>Turandot</em>, for example), with the occasional cheap(ish) Friday night.
</p>
<p>
	Now, I know that a year isn't long enough to roll out major changes in programming, and I get that the Met is under huge pressure from its donors. Perhaps you'll even argue that it's not the role of the Metropolitan Opera to push for the new face of opera, in the same way that<a href="http://schmopera.com/in-review-tcherniakovs-don-giovanni/" target="_blank">I've argued</a> that a function of the Canadian Opera Company is to bring the international opera scene to Toronto. But it no doubt took more than a year for the Met to foresee a decline in younger audiences and precarious donor dependence. I appreciate the big business machine that is the Metropolitan Opera, but I think today's opera lovers are growing wise to the artistic cost.
</p>
