+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2018-02-26T15:30:00-05:00"
lastmod = "2018-02-26T19:35:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519675857152/sq---image11.jpg.jpg"
publishDate = "2018-02-26T19:35:00-05:00"
related_articles = ["articles/clairvoyant-art-enrico-at-oper-frankfurt.md","articles/star-trek-and-the-opera.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/brian-mulligan.md","scene/people/kirsten-mackinnon.md","scene/people/michael-spyres.md","scene/people/claudia-mahnke.md"]
short_description = "In the 21st century, any production of an opera about a 15th-century colonizer is going to be about race and white guilt, whether it intends to be or not. While Kratzer adds in some key pieces of information that provide a certain degree of critical comment on the white colonial mindset, certain visual decisions throughout the production muddy that stance."
slug = "misnomers-interstellar-sex-scenes-vasco-de-gama"
title = "Misnomers &amp; interstellar sex scenes: Vasco de Gama"
+++

"Spoitus". That's the name my [friend](https://www.schmopera.com/scene/people/aj-glueckert/) came up with for the interstellar sex scenes in [Oper Frankfurt](/scene/companies/oper-frankfurt/)'s new production of Giacomo Meyerbeer's *L'Africaine/Vasco de Gama*, which premiered Sunday. Yes, it's that type of show. (Is that a type?)

Although parts of the production could be considered problematic, it is fair to say this *Vasco de Gama* took one giant leap for opera (sorry, had to). Between the space travel, the aliens, and the *Star Wars* nudges, the creative team brought something entirely new to the opera stage. And if nothing else, it had the Frankfurt audience giggling, jeering, cheering, booing, and talking amongst themselves, which in itself is cause for celebration in my books. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676148627/image2.jpg.jpg)
<figcaption>Ensemble, *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

First things first: let's settle on a title. This French grand opera by Meyerbeer was premiered in 1865, a year after his death, under the title *L'Africaine* - *The African Woman*. The composer, however, had only ever referred to his work as *Vasco de Gama*. What's more, the land that is "discovered" in the narrative is clearly somewhere in India, not Africa. The opera largely fell out of popularity in the 20th century, in part due to Nazi erasure of Meyerbeer in connection with his Jewish heritage, but has had a significant resurgence in Germany in the five years since the 150th anniversary of Meyerbeer's death. This new Oper Frankfurt production positions itself decidedly away from anything African (or Indian for that matter), though a number of unfortunately unimaginative details have it leaning a bit too heavily on a mish-mash of African and black visual representations and tropes. In any case, I will refer to the opera as *Vasco de Gama*, as the "official" title of *L'Africaine* was never approved by Meyerbeer, and is not only tokenizing but flat-out erroneous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676279782/image3.jpg.jpg)
<figcaption>Giacomo Meyerbeer.</figcaption>
</figure>

This is the issue opera is grappling with today: when measured against contemporary film or theatre standards, even the most outlandish new productions seem overly traditional, if not outdated. Great works (and the music and poetry of *Vasco de Gama* are great and worth preserving) can be hard to extricate from their sometimes unfortunate historical contexts. However, I always appreciate an honest go at it, which is what director Tobias Kratzer gives *Vasco de Gama* in his sometimes kooky, sometimes stunning new take on the work.

In the 21st century, any production of an opera about a 15th-century colonizer is going to be about race and white guilt, whether it intends to be or not. While Kratzer adds in some key pieces of information that provide a certain degree of critical comment on the white colonial mindset, certain visual decisions throughout the production muddy that stance.

### THE GOOD

Kratzer bookends the opera with two subtle non-sung scenes to critique the hypocrisy inherent in the colonizers' actions. 

In the first act, a group of school children tour a NASA-like space agency's headquarters. While the group learns about space exploration, a sole black boy in the group is taken aside and bullied by his classmates, out of earshot of the tour guide (Bianca Andrew). The white boys steal his toy spaceship and smash it in front of him. They point and laugh at him, and soon the whole class has joined in. With this silent scene, Kratzer sneaks in a subtle criticism of the explorers' heroism as implied in Meyerbeer's work. 

The other critique comes hours later, in the moment after the alien queen Sélika has sung the last note of her swan song and Nélusko has joined her in death. Sélika, consumed with her love for Vasco, has pardoned his unspeakable betrayal and freed him so that he could return to Earth and be with Inès. But in Kratzer's version, instead of graciously accepting Sélika's sacrifice for him and leaving her people alone, which is where the original work ends, a glory-hungry Vasco returns with backup to lay claim on the new planet in the name of the human race. With this addition, Kratzer casts a shadow on Vasco by retroactively painting his loving words to Sélika as empty, false, and opportunistic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676408495/image1.jpg.jpg)
<figcaption>Claudia Mahnke (Selika) with Chorus members, *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

### THE NOT SO GOOD

These valiant efforts to position Meyerbeer's opera in a 21st-century lens somewhat fall flat because of certain visual choices by set and costume designer Rainer Sellmaier. If we were decidedly not in Africa, why put Nélusko in a neck garment reminiscent of the Usekh collars worn by Ancient Egyptians? Why adorn Sélika in ample chains, if not to evoke African royalty? 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676482614/image8.jpg.jpg)
<figcaption>Claudia Mahnke plays the alien queen Sélika in *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

And why create alien head shapes that so closely resemble traditionally black hairstyles like thick cornrows (on Sélika) and Mr. T-style frohawks (on Nélusko and the chorus)? The alien population is also depicted as closer to nature, purer and more innocent than the self-proclaimed dominant Earthlings - an unfortunate and unnecessary perpetuation of the [noble savage](https://en.wikipedia.org/wiki/Noble_savage) myth. In the same vein, Sélika, a queen, is seen writhing around in the dirt, and is perpetually averting her gaze in gentle deference.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676645114/image6.jpg.jpg)
<figcaption>L-R: Baritone Brian Mulligan as the alien Nélusko and Claudia Mahnke as Sélika in a new production of Giacomo Meyerbeer's *Vasco de Gama*, Oper Frankfurt, 2018. Photos: Monika Rittershaus.</figcaption>
</figure>

It is hard not to draw immediate parallels with the 2009 movie *Avatar*, which was heavily criticized along the same lines. And that conversation is already nearly a decade old now. This production, just like New York Times columnist David Brooks [pointed out](http://www.nytimes.com/2010/01/08/opinion/08brooks.html) in 2010 about *Avatar*, "rests on the stereotype that white people are rationalist and technocratic while colonial victims are spiritual and athletic." (Regarding the latter, note that this production’s brawny Nélusko is approximately the size of two linebackers.) Why aren't we evolving the conversation? There is no reason opera should get a free pass, or get to have a discourse that is separate from (and behind) that of film and other cultural media. There is only a single cultural discourse. Artists deliberately choose either to be a part of it or to ignore it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676669933/image4.jpg.jpg)
<figcaption>Brian Mulligan (Nélusko), Claudia Mahnke (Sélika), Michael Spyres (Vasco da Gama), Kirsten MacKinnon (Inès) and Andreas Bauer (Don Pedro), with supernumeraries in background. *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

All that being said, the oddly specific libretto at times does not leave much room for flexibility in the interpretation. The noble savage myth is, perhaps, too built into the text to avoid. And I did appreciate that the creative team attempted to portray the aliens as technologically advanced, even if it was within the context of botany.

### THE PERFORMANCES

In contrast to all this, the beautiful tonal music served as a solid anchor throughout the 4.5 hours of the opera. [Claudia Mahnke](/scene/people/claudia-mahnke/) gave a great sing as Sélika ("l'Africaine" in question), a role that pushed her to the upper limit of her mezzo-soprano range. Her performance lacked on the characterization side of things, however: her contorted, hunched over postures felt unstable and discordant with her character's royal status. American tenor [Michael Spyres](/scene/people/michael-spyres/) was great as Vasco. His warm, buttery, legato tone prevailed throughout the long and ardent performance. This was Spyres's Oper Frankfurt debut, and I look forward to hearing more of him. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676741147/image12.jpg.jpg)
<figcaption>Michael Spyres plays the title character in Meyerbeer's *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

But the real standouts were the two supporting characters. 

In her Oper Frankfurt debut as Inès, Canadian soprano [Kirsten MacKinnon](/scene/people/kirsten-mackinnon/) gave a lovely, enchanting sneak peak of what Frankfurt audiences can expect when she joins the Ensemble next season. She lent a wonderful strength to the fawning, stereotypical damsel-next-door Inès, and found femininity in the role without resorting to the usual hysterics of opera's more typical romantic female leads. Inès is a tough character to play sympathetically - a Western woman who causes the hero to break his life-or-death vow with Queen Sélika - but MacKinnon struck the right chord.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676841852/image7.jpg.jpg)
<figcaption>Kirsten MacKinnon (Inès) with Chorus members. *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

The other standout was American baritone [Brian Mulligan](/scene/people/brian-mulligan/) as the alien Nélusko. Mulligan's signature stately, slow intensity and the razor-sharp cut of his voice both pair very well with this role. Putting aside the problematic costume characteristics as previously described, Sellmaier's look for Mulligan was by far the most successful in conveying character: a positively massive muscle suit, cranial ridge and deep blue hue made Mulligan's sanguine Nélusko look about as badass as one can look in a blue lycra bodysuit covered in starry constellations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676873756/image10.jpg.jpg)
<figcaption>Brian Mulligan (Nélusko), Claudia Mahnke (Sélika) and Kirsten MacKinnon (Inès) with Chorus members. *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

I also really enjoyed the various trios and quartets involving Don Diego (Thomas Faulkner), the evil Don Pedro (Andreas Bauer), Inès (MacKinnon) and Don Alvar (Michael McCown) in Act I, and the septet in Act II including Bianca Andrew as Anna. Andrew, a new addition to the Oper Frankfurt Studio hailing from New Zealand, certainly piqued my interest in one of her very first appearances with the company.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519676922329/image9.jpg.jpg)
<figcaption>Ensemble, *Vasco de Gama*, Oper Frankfurt, 2018. Photo: Monika Rittershaus.</figcaption>
</figure>

An additional hats-off to all: this French Canadian was especially impressed with the diction. I was able to sit back for most of the opera and just listen to the story, because everyone's French was spot-on.

*Vasco de Gama* is without a doubt one of the more worthwhile presentations in Oper Frankfurt's 2017-2018 season so far. Don't be put off by the opera's length: the beautiful, familiar yet fresh music and the two intermissions will carry you through. Get information and tickets [here](http://www.oper-frankfurt.de/en/season-calendar/l-africaine-vasco-da-gama/?id_datum=1039).
