+++
author = ["authors/michelle-telford.md"]
categories = "Editorial"
date = "2015-04-10T21:20:00-04:00"
lastmod = "2015-04-12T18:57:00-04:00"
preamble = "This is a guest post by Michelle Telford, custom surtitlist with Saskatoon Opera. \"Seeing is for suckers, and sleep is for the weak.\" - Michelle.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428715008105/4-Thats-Better.jpg.jpg"
primary_image_credit = "Michelle Telford"
publishDate = "2015-03-25T09:20:00-04:00"
related_articles = ["articles/tales-from-stage-management.md","articles/problems-we-didnt-know-we-had-surtitles.md","articles/vera-causa-opera-opera-for-all.md"]
related_companies = ["scene/companies/saskatoon-opera.md"]
short_description = "This is a guest post by Michelle Telford, custom surtitlist with Saskatoon Opera. &quot;Seeing is for suckers, and sleep is for the weak.&quot; - Michelle."
slug = "michelle-telford"
title = "Michelle Telford, Creating Custom Surtitles for Opera Today"
+++

In the English-speaking world of non-English language opera, a surtitlist's work is vital - some wouldn't agree, but every day a surtitlist has to wake up and ignore the haters. Surtitles have had their share of critique from the snob-pera folks (not that I'm against any form of opera, from the purest of the purists to Fat Mike's new "Home Street Home") but for many companies, they're essential to the success of a production by providing a more universal accessibility. 

I belong to the [Saskatoon Opera](http://www.saskatoonopera.ca/) - we are a small, happy, vibrant company in Saskatchewan, Canada. We put on one lavish mainstage production every summer, and the company is devoted to music education the rest of the year. I usually work a full-time job outside of the company, so the work I do with that year's production takes place in whatever free time I have left. It's what I look forward to every summer. 

A surtitlist is their own beast; we are not production, tech, crew, pit or cast, but a little bit of everything. When I began with Saskatoon Opera, it all boiled down to a) knowing the director and head of the board, b) being in university and needing a bit of pocket money, and c) being able to use a computer, read a piano/vocal score and chew gum at the same time. At the time, I had just switched majors from music education to women's studies, and I was eager to keep using my knowledge - I just didn't know it would be in opera! 

A day in my life as a surtitlist begins normally: I wake up and complain heartily about waking up, like most sane people. Then I go to work, and come home to write surtitles and work on cueing my score. It's painstaking and a bit tedious, especially when rehearsals begin and the director's notes are full of redirections and cuts, but it has to be done and it has to be done very accurately. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428715187766/MichelleCollage-1024x531.jpg.jpg)
<figcaption>This is what detail-obsessive face looks like in gel lighting.</figcaption>
</figure>

I attend production meetings and rehearsals as time allows in order to speak with the director and production team about the vision and staging, adjust the translation (does it need to be formal, more thematic, more contemporary, etc.) and discuss the fonts, transitions and actual amount of surtitles needed. For example, some companies will have surtitles up during pages and pages of repetition - I, personally, think it's a waste of time and energy, and I want to give the audience a bit of intellectual credit as well as let the actors see the scene through to the end on their own. A big thing in surtitles is making sure you pace the slides so that the laugh or the reaction comes at the right time - getting the audience engagement is a teamwork exercise.  

When it's performance time, I have my own rituals - grab a glass of wine or cup of coffee from the front of house bar, go upstairs to my booth, change into jean shorts and a tank top (because my closest friends in my booth are very hot pot lights) and hang up my dress to change into for the end of the evening. My only companions are the input for the projectors, a music stand, a card table and a chair, and I can see only about ½ of the stage at any given time. This is my trade-off for having a booth to myself to concentrate, away from crew chatter and the airless tech booth. 

I began thinking to myself one hectic summer, "Either my full-time job has to go, or I have to stop doing surtitles." That's when the plan hatched - I decided that writing surtitles for the rest of my life would be the cat's pajamas, and it would have to happen. That's when I decided to begin developing a tiered service program - I have a solid background in project and service delivery - and a marketing plan. I want to bring fresh, accessible, thematic titles to opera to help the production's authenticity and the director's vision shine through. I am always happy to use the newest technology necessary - for example, Skyping in to watch a rehearsal is part of the service I want to offer, so that I can give each company my best drafts as fast as possible. It keeps all of the editing and initial slide plotting off the director's plate until the director is ready to review. 

Custom surtitle work has to subtly reflect what's happening onstage. Marilyn Gronsdal, who works with the Canadian Opera Company, pointed out to me in email conversation that "(surtitles) are one of the major sources of communication between the audience and the performance." I attend as many rehearsals as possible in order to assist with cueing, any tech work related to the surtitles, and to ensure that what I've put in every single slide looks good with the director's vision and what's happening onstage. If there is a rehearsal after work, I try to cram food in my mouth while I'm driving and get to the theatre so I can review my work as I go. 

I write all of my titles fresh for every production - I don't believe in getting anything out of the can, because it feels like cheating, and my company deserves better. Every company deserves better! I've seen some good titles and terrible titles, but I'm going to go out on a limb and say that anything they can do, I can do better. I want every slide to look as good as the carefully-crafted sets and costumes. I want them to match the actors' portrayals and support their individual characters. I want to keep opera moving forward and help it stay relevant - it's an art that won't quit 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428715149564/2-Emoji-Carmen.jpg.jpg)
<figcaption>I'm terrified that emoji will eventually put me out of a job.</figcaption>
</figure>

I want every hour I put into writing, attending rehearsals, conferring with the director and maestro, and the time I spend chatting with the cast, to matter. Every company wants this, but sometimes they're not sure how to make it happen. I am firmly convinced that it's important. You have people dedicated to ensuring that your cast looks right and the orchestra is properly paced, and all of this is added value. It's a thrill to know that the audience is responding.  

It's time for good service to be accessible and affordable to companies in order to create that added value for their audiences. I believe that any project can be elevated with some care and attention paid to details, and having custom work done for your surtitles is a great way for any company to improve their production quality. 

Amen! What a cool job. Follow Michelle on Twitter, [@customtitles](https://twitter.com/customtitles), or get in touch via email, at michellektelford@gmail.com
