+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-07-20T17:43:00-04:00"
lastmod = "2016-07-21T09:42:00-04:00"
preamble = "This summer, [Summer Opera Lyric Theatre](http://www.solt.ca/performances.html) enters its 30th season; to celebrate, the line-up includes the world premiere of *A Tale of Two Cities*, a new operatic adaptation of Dickens' novel by Victor Davies and Eugene Benson. We spoke with Music Director and pianist Michael Rose about this new opera, some upcoming projects of his own, and about SOLT's mission to train young artists for the professional stage."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1469054124309/2016-07-20---Michael-Rose.jpg.jpg"
primary_image_credit = "Michael Rose, Music Director of A Tale of Two Cities, in rehearsal with Victor and Lori Davies."
publishDate = "2016-07-21T09:27:00-04:00"
short_description = "This summer, Summer Opera Lyric Theatre enters its 30th season; to celebrate, the line-up includes the world premiere of A Tale of Two Cities, a new operatic adaptation of Dickens&#039; novel by Victor Davies and Eugene Benson. We spoke with Music Director and pianist Michael Rose about this new opera, some upcoming projects of his own, and about SOLT&#039;s mission to train young artists for the professional stage."
slug = "michael-rose-on-a-tale-of-two-cities"
title = "Michael Rose on A Tale of Two Cities"
+++

## What makes *A Tale of Two Cities* a good story to tell in an operatic setting?

Recently, in anticipation of my role as MD for a new Canadian opera based on Dickens' *A Tale of Two Cities*, I reread the novel, having first encountered it as a teenager - some forty years nearer the Victorian era than I am now. At the time, I loved the famous bits, its magnificent beginning ("It was the best of times…") and ending ("It is a far, far better thing…"). But to my young self, the middle was a bit dense and slow going. So it was with some surprise that I found, this time around, Dickens' writing to be a model of lucidity and simplicity. It strikes me now as most modern in style. Its characters are real people – finely drawn, with explicit and perceptive psychology. 

It is this psychological depth that makes it an excellent subject for opera. The characters have a rich internal life. Their actions are the inevitable results of their mental states. Darnay, for instance, is driven to abandon his wife and child not just out of a sense of social duty, but also by his hubris and pride, flaws deeply ingrained by an upbringing of privilege. 

Music thrives in this inner world of psychology and emotion. That’s where opera or indeed any kind of music theatre shows its strength. 

## What kind of musical language can audiences anticipate?

Victor Davies is a composer with a fine melodic gift. The audience can expect to leave the hall humming the tunes, which is not the case with most modern opera. Victor eschews contrapuntal and harmonic complexity in favour of directness and simplicity. This gives his style a "retro" feel. I think audiences will find the music to be a not too distant relative of familiar, old-style musicals such as *Les Misérables* and *Phantom of the Opera*. In other words, don't let the phrase "modern opera" scare you away!

## How does *Two Cities* fit in with this summer's Summer Opera Lyric Theatre lineup?

SOLT is a training program for young singers. As such, it is an unusual venue in which to workshop a new work. The other two operas, Handel's *Julius Caesar* and Offenbach's *Tales of Hoffmann*, are established masterworks. So, in their case, it is the young singers who are being put to the test. In the case of our *Tale*, the work itself is on trial before an adjudicating public. 

With that in mind, SOLT has engaged singers ranging in experience from newbie through young semi-professional to experienced professional artist. It's a balance that seems to be working well. We're all learning from one another and enjoying the process. I'm encouraged and impressed by the cast's commitment and effort in getting Victor’s and Eugene’s work from page to stage.

## What can you tell us about your own upcoming projects?

On August 11th, I head to the [Kincardine Summer Music Festival](http://ksmf.ca/) in Kincardine, ON (oddly enough!) to perform a recital with the exciting young soprano Christina Haldane. For this occasion, Christina has put together a beautiful program of Spanish, French, and Italian song. 

That will be my last performance for the summer. After that, I’ll be heading to the sunny patio at my local coffee shop to scribble away at some writing projects: revisions to a musical (*Castaways*) that I wrote this last year, a reworking of a musical I wrote many years ago, and a new project that, to date, is only in the flowers and chocolates stage of development.

>For tickets to A Tale of Two Cities and other SOLT events, call the St. Lawrence Centre box office at 416-366-7723, or visit [stlc.com](http://www.stlc.com/).
