+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-09-17T18:24:00-04:00"
lastmod = "2015-09-18T12:27:00-04:00"
preamble = "Vancouver-based Composer and pianist [Michael Park](/scene/people/michael-park/) has spent considerable time thinking about how to talk about disease through music. He performed his [*Alzheimer's Variations*](https://www.youtube.com/watch?v=Oj2AXT23uVI) (absolutely worth a listen) as part of his TEDxSFU talk in 2013, entitled [\"Experience disease through music.\"](https://www.youtube.com/watch?v=Oj2AXT23uVI) Next month sees the premiere of Park's [*Diagnosis: Diabetes*](http://www.michaelpark.ca/diabetes-presskit/), his new \"interactive chamber opera\" featuring the [Erato Ensemble](/scene/companies/erato-ensemble/), October 10th at 8pm at The Orpheum Annex in Vancouver.\n\nI spoke with Park about writing an opera about disease, composing music to tell this kind of story, and the audience interaction that is crucial to *Diagnosis: Diabetes.*"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1442591708624/Erato-Cropped-Headshot-(1).jpg.jpg"
publishDate = "2015-09-18T12:15:00-04:00"
related_articles = ["articles/new-opera-more-singer-input-needed.md"]
related_companies = ["scene/companies/erato-ensemble.md"]
related_people = ["scene/people/michael-park.md"]
short_description = "Vancouver-based Composer and pianist Michael Park has spent considerable time thinking about how to talk about disease through music. He performed his Alzheimer&#039;s Variations (absolutely worth a listen) as part of his TEDxSFU talk in 2013, entitled &quot;Experience disease through music.&quot;"
slug = "michael-park-on-opera-disease"
title = "Michael Park: on opera &amp; disease"
+++

### 1. Why were you drawn to this story for your first chamber opera?

I guess the answer to that question depends on how far back we go...

When I needed to choose a project for my doctoral thesis, I was advised that developing previous work into a larger project was always a safe bet. Having written a scene in 2011 for the University of Manitoba's Contemporary Opera Lab, it made sense to expand it into a one-act opera. In writing that scene, on a very short deadline, the best advice I got was to write what I knew. And after twenty-some years, I certainly knew diabetes!

Coming of age as a diabetic, I saw a lot of my peers choosing paths whereby they devoted their lives to diabetes, as doctors, nurses, educators, researchers, and bloggers. At the time, I had no idea of how I might make my mark on the diabetes community, so the opportunity to explore and engage with diabetes artistically is something really special to me.

### 2. Diabetes is a health risk that’s fairly common today; why do you think this kind of story hasn’t been told in an operatic way before?

You're quite right - diabetes effects nearly one in ten adults in Canada, and yet it's often misunderstood by the general public. Other than a tattoo I have on my left wrist, you can't tell I'm diabetic from just looking at me - it's what they call an 'invisible illness'. Advocacy is a large part of why I'm doing this, and *Diagnosis: Diabetes* is aimed at showing and sharing the diabetic experience with an audience.

On the one hand, I'm surprised diabetes has never really been set operatically. Recitative and arias seem to me the perfect tools for bringing light to an invisible illness. On the other hand, diabetes is awfully specific compared to the universals opera does so well at (say, unrequited love or betrayal). That's actually a driving force behind how I approached the opera - unless I wanted to limit my audience to diabetics (which I didn't), I would have to give the audience the experience of being diabetic as part of the opera.

### 3. *Diagnosis: Diabetes* is an “interactive opera.” Can you tell us a bit about how it works?

This project brings together the two big areas I've been exploring in the last few years - audience interaction and musical experience. The audience interaction in *Diagnosis: Diabetes* is as direct as can be. Two of the scenes are mini gameshows where the singers ask multiple-choice questions of the audience, repeating the possible responses until the audience chooses. The following scenes have a good and a bad version. Which version the audience sees, is decided by how many questions they successfully answer. That part is super fun, but I'm even more excited about the other kind of interaction...*segue to next question*...

### 4. How have you chosen to the story of a disease, in terms of the music itself?

More than just a spectator, the audience actually shares many of the experiences of the main character, Charlie.

In scene 2, Charlie is in an office meeting when he experiences low blood-sugar. I knew it wouldn't be enough to rely on the visible symptoms, showing Charlie sweating or with shaky hands. I talked with other diabetics and confirmed that the hallmarks of experiencing hypoglycemia are an altered sense of time and a lack of comprehension. With the liberal use of accelerandi and crescendi, I was able to fluctuate the sense of time passing, and a technique I call garbling (mumbling, or rendering the text unintelligible) contributes to a sense of confusion. Garbling also allows for another benefit: two completely different versions of a scene can exist simply by controlling what portions of the text are understood. This means that the singers only have to learn one set of pitches, rhythms, and text.

### 5. What do you hope your audience will take away from this piece?

I know that there will be people coming to see a show about diabetes. For them, I hope to be a good ambassador for opera and new music. In the end, this opera is about connecting people, whether it's performers to their audience, or diabetics to the general public. I hope that the diabetics will feel less invisible, and that everyone else will gain a new perspective on what it's like living with a chronic illness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1442591511785/DiagnosisDiabetes-posterResize.jpg.jpg)
</figure>

>Diagnosis: Diabetes plays October 10th, 8pm at The Orpheum Annex in Vancouver. For details and tickets, follow the box office links below.
