+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-02T21:47:00+00:00"
lastmod = "2017-01-12T21:27:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483626621649/20-17-01-05---Fabiano---Doneson.jpg.jpg"
primary_image_credit = "Photo by Arielle Doneson"
publishDate = "2017-01-07T11:54:00+00:00"
related_articles = ["articles/arts-money-waste.md","articles/talking-with-singers-michael-fabiano.md"]
related_people = ["scene/people/rolando-villazon.md","scene/people/john-viscardi.md"]
short_description = "When it comes to young people with little to no extra-curricular activities in their daily schedules, it&#039;s a major discovery to see that students are eager to stay after school for their private sessions. &quot;Lots of the kids are genuinely excited to be able to stay after school and wait for a lesson,&quot; says Fabiano. &quot;To be able to focus on something every day, and to wait an hour to do their lesson, is good for them because it keeps them in the incubator environment.&quot;"
slug = "michael-fabiano-the-profound-effect-of-artsmart"
title = "Michael Fabiano: the &quot;profound effect&quot; of ArtSmart"
+++

A little over a year ago, the team that would make up ArtSmart sat down to take a hard look at the role of the arts in public school curriculum.  [Brian Levor](http://www.artsmart.org/author/blevor/) is a percussionist and teacher; [John Viscardi](/scene/people/john-viscardi/) runs a health care company and is a baritone with a burgeoning career; and [Michael Fabiano](/scene/people/michael-fabiano/) is one of the world's leading operatic tenors. All three were focused on two realities of arts education: that there isn't enough of it, and that students who do pursue arts degrees accumulate large amounts of student debt, while having a difficult time finding work in their field.

Fabiano, Levor, and Viscardi have started [ArtSmart](http://www.artsmart.org/), an organization with goals to improve the quantity and quality of public school arts curriculum, and to provide meaningful work opportunities for adult graduates of esteemed music programs. 

ArtSmart offers high-quality music education and private voice lessons, free of charge, to under-served students in schools with limited music programs. The teachers, one could argue, come from an under-served group of their own. Fabiano explains, "We provide teaching opportunities to recent graduates of good schools, qualified schools and universities, who are very excited to teach young teens." He adds that bilingualism is an important quality for ArtSmart teachers, with a high rate of Spanish-speaking students within their target communities.

Fabiano and his team recognized early on that schools in the United States, with their scarcity of music programs, were a perfect environment in which to begin their initiative. "We identified seven communities around the United States that have very iffy resources," he says, "communities where we know that there are a lot of under-served children, where the dropout rates are very high."

ArtSmart launched its pilot program at Newark East Side High School in New Jersey, a community with which Fabiano is familiar. Newark East Side's music program is a limited one;  they do have a choir program, yet less than 10% of the students are involved. Still, with the help of the school, the ArtSmart team vetted a group of students with an interest in studying music more regularly.

"We have two teachers that go to Newark, essentially for the day," says Fabiano. The teachers give private voice lessons to upwards of fifteen students, and at the end of the program, the students and teachers give a public concert together. "We want to create a concert that involves many different types of music that allows kids to aspire to something greater." 

The teachers are classically trained, but they have the flexibility to teach students in any musical style they like. "We're not imposing classical music on these kids. We're imposing music on them," says Fabiano. "That's all we care about." 

The ArtSmart curriculum includes universal singing skills, like breathing, sight-reading, stretching, and allowing the students to feel for themselves the healthy way to use their voices. Some students do show a particular interest in classical music or musical theatre, but more commonly, their vocal influences come from pop music. "A lot of these kids, they've never been to any sort of show. They just know their favourite artists." 

Students look to singers like Beyoncé and Adele, and begin to mimic their sounds - including "bad habits" of popstars, like breathiness or nasality - before fully understanding how the voice works. "We're shifting the paradigm on how they think about what singing is," says Fabiano, who's an admitted admirer of Lady Gaga. ("I think she's a pop artist that has a good voice, a legit voice.")

Anyone who has experienced the benefits of music education knows that it's not just about mastering an instrument. The students in the ArtSmart program are learning this, too. Fabiano notes, "One thing we've noticed is that the relationship between a teacher and a student, the mentoring relationship, really has a profound effect on a kid's well-being." Within a school with limited resources, that mentorship is "instrumental".

The ArtSmart team has paid close attention to the impact their program has on the students' grades, attendance records, and history of disciplinary actions throughout the year. "The progress on every kid's front is upwards. We've had the principal tell us directly that children in the program that had upwards of 100 disciplinary actions last year, have had 10 this year," says Fabiano. "We've had kids that have skipped school dozens of times, [who] skipped once this year. They genuinely want to be in the program."

When it comes to young people with little to no extra-curricular activities in their daily schedules, it's a major discovery to see that students are eager to stay after school for their private sessions. "Lots of the kids are genuinely excited to be able to stay after school and wait for a lesson," says Fabiano. "To be able to focus on something every day, and to wait an hour to do their lesson, is good for them because it keeps them in the incubator environment."

Despite a few masterclass-type sessions with the ArtSmart students, Fabiano's busy performance schedule leaves him little time to act as a teacher himself; yet his investment of time and energy in ArtSmart is vital to the program. "I've gone in to watch the teachers work a few times now. I've been a witness to what they're doing, I'm giving them feedback." 

"We are giving these students free voice lessons with the same teacher every week for the entire school year and if they choose to continue, their entire time in high school," Fabiano explains. "That kind of continuity is a game changer in many of these kids' lives."

He admits that the next step in developing the ArtSmart curriculum is to find a way for the students to stay accountable for the skills they build over the year. "The great thing about [El Sistema](https://en.wikipedia.org/wiki/El_Sistema) is that the kids are given instruments, so they treat their instruments like their child," he explains. "We haven't figured out yet how to tell kids to treat their voices like it's their child."

It's one of many conversations that ArtSmart is having as they prepare to expand to a second school. They plan to reach upwards of 20 schools and 500 students by 2018, giving a whopping 20,000 voice lessons. "As much as we want to grow quickly, we also want to grow cleverly," Fabiano says. "I want to grow where kids are most served." 

Fabiano is passionate about showing how arts education has tangible effects on the development of young people, and can create adults who are confident and self-motivated. Music education in particular can solve for low graduation rates and high recidivism rates, and young people can experience a sense of responsibility and pride for their own hard work. "If kids learn skills of accountability at a young age, they'll enter society ready," says Fabiano. For him, ArtSmart isn't about producing more well-trained musicians. "I'm interested in helping young adults progress to the point where they can enter society, and have more layers to themselves so they can get employment. Just that alone would be wonderful for us."

"I've always wanted to do this kind of thing," says Fabiano of his dedication to improving arts education for young people. ArtSmart continues to look forward, both with their mission, and with raising the funds needed to to make their mission happen. "We're definitely looking for more resources. If we're to expand our offering to more schools, we're going to need more signatory donations from people."

In an era where school boards are constantly searching for the most efficient use of money and resources, it's more important than ever to amass the data that shows the enormous value of studying music. Music school graduates can vouch for the skills in concentration, time-management, fine motor skills, group work, self-discipline, and confidence-building; ArtSmart is an initiative that starts with the broadest form of music education, making it flexible enough for everyone. 

Fabiano plans to take the data from ArtSmart's programs as high as he can go. "If we can show the links that music education - even the process of doing music in schools - helps kids turn a corner, we can make a case federally for the need for more arts curriculum in schools. We have the ability to prove that we're making consequential change in the classroom."

If ever there was a cause that deserves attention, it's the mission of ArtSmart. To make a donation to ArtSmart, [click right here](http://www.artsmart.org/donate/); to get involved, [click here](http://www.artsmart.org/get-involved/). You can (and should) read [Liz Letak's breakdown](http://www.artsmart.org/why-access-to-the-arts-matters/) of why arts educations matters, and Fabiano's own [blog post](http://www.artsmart.org/why-artsmart/) on starting the program.
