+++
author = ["authors/michael-fabiano.md"]
categories = "Op-ed"
date = "2016-08-07T10:46:00+01:00"
lastmod = "2016-08-12T09:43:00+01:00"
preamble = "This is a cross-post, originally published on tenor [Michael Fabiano](/scene/people/michael-fabiano/)'s blog, available [via his website.](http://michaelfabianotenor.com/2016/08/classical-music-deserves-better/) "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470563461846/2016-08-07---Library.jpg.jpg"
publishDate = "2016-08-12T08:00:00+01:00"
related_articles = ["articles/natalie-dessay-opera-is-an-art-which-has-not-been-able-to-renew.md"]
related_people = ["scene/people/rolando-villazon.md"]
short_description = "A recent article in The Atlantic titled &quot;The Tragedy of iTunes and Classical Music&quot; sheds a light on just how problematic iTunes and other major digital libraries are for storing and categorizing classical music. What exactly is the problem? Professional musicians, particularly classical ones, need quick and easy access to multiple recordings and iTunes just doesn’t cut it."
slug = "michael-fabiano-classical-music-deserves-better"
title = "Michael Fabiano: Classical music deserves better"
+++

Back in 1996, when the first metadata system was developed for MP3s there were only three options for attaching text to the files – artist, song name, and album.  Although categorization has changed, it hasn’t evolved to effectively categorize classical music.  It was only in 2004 that iTunes added a "Composer" tag.  A recent [article](http://www.theatlantic.com/technology/archive/2015/07/the-tragedy-of-itunes-and-classical-music/399788/) in *The Atlantic* titled "The Tragedy of iTunes and Classical Music" sheds a light on just how problematic iTunes and other major digital libraries are for storing and categorizing classical music.   What exactly is the problem?  Professional musicians, particularly classical ones, need quick and easy access to multiple recordings and iTunes just doesn’t cut it.

For example, A search for Tchaikovsky's Fourth Symphony can wield hundreds of results, many of which are different recordings, conducted by the one conductor or a recording of "Vissì d'arte" can be heard on multiple different recordings, but by the same artist. By comparison, searching for "Hello" by Adele is found with immediacy. The hassle of having to appropriately filter through results and whittle down to a desired specific choice is time consuming and arduous.

What compounds this problem is Apple's music search engine.  The *Atlantic* article gives the example of *Te Deum* by Benjamin Britten.  There are two settings of the *Te Deum* text, but if you type in "Britten" and "Te Deum," you receive a "no results found."  Further, there is no performer field in the search engine forcing people to type this information in the general comments field, which will increase the likelihood of inaccurate returns.  Classical music isn't the only genre that suffers as a result.  Audio books, lectures, and sound art do not adapt well either.

So what can we do to make this easier?  Here are four suggestions:

### Improve Metadata

Manual entry of data into music platforms like iTunes is costly and time consuming. It requires a vast team of people who are experts to know what to enter and how to enter it because of the complex nature of classical recordings. New classical works face an even greater problem since defining the music takes time and personnel. Instead, the process should be automated and individualized so classical artists can enter their own data and not depend on expensive field experts.

### Create a "Recommendations from an Expert"

A recommendation from key artists adds to the value proposition of classical arts and can quickly generate traction and traffic in one direction to a particular album or recording.  Otherwise, fans will have a hard time locating exactly what they are trying to find.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470563385704/2016-08-07---MichaelFabiano_Arielle-Doneson.jpg.jpg)
<figcaption>Michael Fabiano, tenor. Photo by Arielle Doneson.</figcaption>
</figure>

### Classical Music-Friendly Streaming

We should actively promote sites who are adapting to the music.  Streaming services like Hosted by dedicated classical labels or classical media suites like the Berlin Philharmonic Concert Hall should be at the top of the list.

### Records

There has been a [massive uptick in vinyl sales in the past two years](http://time.com/3663568/vinyl-sales-increase/), in large part because vinyl broadcasts the sound of a classical artist far clearer and true to its actual live state. The over stereophonic nature of recordings today has marginalized great artistry and has created a real versus computerized phenomenon that actually can suppress sales. Vinyl recordings that capture true sound and voice can reignite the flame of classical music distribution because of the "gotta have it" nature of the product and makes it incredibly easy to find the recording for which you are searching.

>How else can music streaming services improve their classical music libraries and searches? Let us know the comments below!
