+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-04-20T15:32:00-04:00"
lastmod = "2018-04-20T19:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524252282217/sqBorrowed_Blue_1st_Night_117.jpg.jpg"
primary_image_credit = "Celeste Godin in Miss Havisham's Wedding Night, MetroWest Opera, 2018. Photo: Nile Hawver."
publishDate = "2018-04-20T15:32:00-04:00"
related_articles = ["articles/in-review-bluebeards-castle-erwartung.md"]
short_description = "Of course, sometimes the trickiest part of finding a pair of operas to form a double bill with is finding the links between the two works to be presented: after all, an operatic double-bill is only made stronger with the right pairing of works to perform."
slug = "metrowest-double-bill-provides-thrills-delights-despite-mismatch"
title = "MetroWest Double Bill Provides Thrills &amp; Delights Despite Mismatch"
+++

Opera, perhaps more than any other performance art that I can think of, really likes to employ double bills. Of course, sometimes the trickiest part of finding a pair of operas to form a double bill with is finding the links between the two works to be presented: after all, an operatic double-bill is only made stronger with the right pairing of works to perform. Both shows also need to land on their own terms as individual pieces, although that part is significantly easier to pull off.

[MetroWest Opera](http://metrowestopera.org/) decided to take on this particular challenge with a pair of more recent works by Dominick Argento and Dan Shore, both of which have all-female casts. Opening the night was *Miss Havisham's Wedding Night*, a one-woman show in which Charles Dickens' famously jilted bride from *Great Expectations* relives her wedding night thirty years after it has happened. After intermission, we were treated to *The Beautiful Bridegroom*, a light comedy about a mother who seeks a bridegroom for herself and not her daughters. The link prescribed by director Cassandra Lovering's notes is a thematic one, about how men and the expectations of society in their respective time periods have shaped the characters.

I can certainly see the thematic link, for both characters do have to contend with the question of how men figure into these women's lives despite the fact that not a single man steps onto the stage during either opera. And indeed, the idea of characters who have to deal with the question of how agency is robbed from them by unseen men is an interesting idea to explore: Lovering compares Havisham to *Bridegroom*'s Terentia, the middle-aged mother who searches for a bridegroom. 

However, I find myself questioning the pairing, for the two characters are framed in such wildly different ways between the two works that it eventually obliterates the thematic link. Havisham, as the program admits, is entrusted into a sort of false agency by her own hurt feelings, and it is clear that she remains trapped by operatic convention as well given that it is essentially a fifty-minute long mad scene: however, she has nobody else to contend with but the scenery, which laser-focuses her as the emotional center of the opera. 

*Beautiful Bridegroom*, on the other hand, does have other characters, and there the work undermines Lovering's choice of pairing given that Terentia is not framed as a similarly centralized figure: the attention instead goes to Madame Kirsten, who is a literal gender-bent Figaro. In light of how the show frames Madame Kirsten, therefore, one has to contend with the fact that Terentia is framed as a kind of buffoon who needs to be taken down a notch, similar to Count Almaviva in *Le nozze di Figaro*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524252662886/Borrowed_Blue_1st_Night_255.jpg.jpg)
<figcaption>(l-r) Katherine Maysek, Elizabeth Kinder, Stephanie Hollenberg, Charlotte Jackson, Natalie Logan, and Brynne Pulver in *The Beautiful Bridegroom*, MetroWest Opera, 2018. Photo: Nile Hawver.</figcaption>
</figure>

The difference in how both works treat the point of comparison Lovering used made me question the wisdom of pairing them together, and I suspect the double-bill might have worked far better with other pairings. Still, even despite this disparity, the individual operas and the attendant performances were of sufficient quality that even the questionable logic behind their pairing was not enough to drag the evening down.

*Miss Havisham's Wedding Night* was a fascinating little tragedy, and a very refreshing take on Dickens' classic character. It can be easy to dismiss Miss Havisham given that she functions as a narrative obstacle in *Great Expectations*, but Argento and librettist John Olon-Scrymgeour do a wonderful job of displaying the humanity of the character by allowing her to express depths of emotion other than rage. 

It also uses its device of Miss Havisham reliving her wedding day years afterwards to incredible dramatic effect, especially on a musical level: the music allows her occupy the headspace of a nervous but happy bride one second, and the very next second, it pulls her back into the present, reminding her that she already knows how the night is going to end, before pulling her back into the first mood with no pre-amble. The score's neo-romantic lyricism might have felt trite under any other hands, but the frequent and unpredictable changes of mood gave the lyrical parts a sense of importance that cannot be understated.

As with any opera in which there is only one singer, Havisham is a challenge because it’s necessary to have a soprano who can navigate the many sudden mood changes and do it on the turn of a dime the way the score does. And here, Celeste Godin proves to be a revelation. She already showed that she's a wonderful singer-actress with her work in Boston Opera Collaborative's *La Bohème*, but here she navigates the many tricky shifts of the score with such virtuosity that I was blown away by the performance. It also helped that Lovering and scenic designer Lindsay Fuori gave her a suitably run-down set for her to work with, and used the space in interesting ways: I don't know if I have ever seen a better use of the theater door as a way to bring someone into the action than the use here.

*Bridegroom* was no less entertaining, even if it was for a completely different music. Musically, Dan Shore's score could not have been more different. Shore's music is very neo-Mozartean: for my taste, it was Mozartean to a fault, as there were times where the music did feel a little too simplistic. However, Shore makes up for the shortcomings in his music by writing his own absolutely hilarious libretto that gleefully sends up the operatic settings of the Beaumarchais plays in ways I never knew I wanted to see: the effect is that it almost makes it so that it's difficult to imagine the music of this opera having any other sound but a neo-Classical sound world. 

Lovering's staging also helped keep the work dynamic: it kept the pace of the comedy moving at a very fast clip, and it also used the projections in the back of the space in hilarious ways that backed the comedy already found in the work.

The six ladies who were cast in the opera were all endearing in their own right. Everybody's comic timing was spot-on, and the result was that there was no shortage of laughs from the performances. They also all sang with clear, crystalline diction that made every word comprehensible—important, since the production eschewed subtitles. Katherine Maysek made for a delightfully devious Madame Kirsten, and it was wonderful to see the gears in her mind work as she traversed about the stage. Brynne Pulver made for a really delightful mother, and even if her voice lacked a certain fullness she certainly did a wonderful job embodying her character. 

Charlotte Jackson and Stephanie Hollenberg also made for a pair of sisters who served as each other's best foils, particularly in a hilarious duet where Charlotte's Laurentia kept singing about how short-sighted men were while Stephanie's Leonora brushed her off while praising their ability to dance the minuet. Natalie Logan made for the perfect straight woman, as her Pernille expressed constant exasperation with the eccentricities of her cast mates with a sharp, agile voice. Rounding out the cast was Elizabeth Kinder's Captain von Frauenliebe, who leant a warm voice to an absolutely perfect lampoon of the trouser role that provided the best laughs of the night.

Overall, the night was still a good night at the opera. *Havisham* was the dramatic tour-de-force that the program described, and *Bridegroom* provided some very hoary laughs for the audience. Both works thus worked extremely well on their own terms. I suspect that different pairings might have worked better for the work, like pairing *Havisham* with, say, Poulenc's *La voix humaine*, or pairing *Bridegroom* with something like David Del Tredici's *Dracula*. However, even despite the mismatch the two works managed to shine on their own terms, and one can ask for nothing more on a double-bill such as this.

>Old New Borrowed Blue runs through April 21 at BCA Plaza Theatre. For details and tickets, [click here.](https://www.bostontheatrescene.com/season/Old-New-Borrowed-Blue/)
