+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-05-29T19:23:00-04:00"
lastmod = "2018-05-30T11:18:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527636141197/sqRake5.jpg.jpg"
primary_image_credit = "Ganson Salmon as Tom Rakewell in The Mannes Opera production of The Rake's Progress. Photo: Eugenia Ames."
publishDate = "2018-05-30T11:18:00-04:00"
short_description = "It is apparent that one doesn&#039;t question the avant-garde at Mannes, but welcomes it. Recent productions of Robert Ashley&#039;s conceptual Dust and Philip Glass&#039; rarely performed The Fall of the House of Usher reinforce that point. And there is enough invention in Stravinsky&#039;s composition and the beautiful libretto by W.H. Auden with Chester Kallman, (a satisfying read in its own right) to keep these gifted singers and musicians on their toes."
slug = "merrily-the-rakes-progress-rolls-along"
title = "Merrily The Rake&#039;s Progress rolls along"
+++

"I'll let you know when Stravinsky has a hit," chides Joe, the crass Broadway producer in Stephen Sondheim's *Merrily We Roll Along*. Joe is giving Sondheim's aspiring songwriting team the brush-off because he thinks their score is too avant-garde. Well, guess what Joe. Igor Stravinsky does have a hit. It's *The Rake's Progress* and The Mannes Opera had the good sense to produce it for two performances earlier this month.

First and foremost, Mannes, being the lauded music conservatory that it is, produces an opera as a learning experience for its students. Richard Kessler, who is Dean of Mannes and Executive Dean of Performing Arts at The New School, of which Mannes is a part, sees "a renewal that is just so evident in the world of opera." He adds that, "no one can remember a time with so many new works being created and so much experimentation."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635769422/Rake1.jpg.jpg)
<figcaption>Ganson Salmon as Tom Rakewell and Michael Pitocchi as Nick Shadow Photo: Eugenia Ames.</figcaption>
</figure>

Kessler's enthusiasm shows. It is apparent that one doesn't question the avant-garde at Mannes, but welcomes it. Recent productions of Robert Ashley's conceptual *Dust* and Philip Glass' rarely performed *The Fall of the House of Usher* reinforce that point. And there is enough invention in Stravinsky's composition and the beautiful libretto by W.H. Auden with Chester Kallman, (a satisfying read in its own right) to keep these gifted singers and musicians on their toes.

Stravinsky's score, as if to pique the interest of Sondheim's producer, sounds melodic, even Mozartian, one moment and then diabolically angular and nearly atonal the next. And so it goes in this rollicking if downward-spiraling tale of Tom Rakewell. William Hogarth's suite of eight 18th-century paintings that reside at Sir John Soane's Museum in London inspired the story. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635803609/Rake7.jpg.jpg)
<figcaption>Zachary Goldman as Tom Rakewell and members of the ensemble in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

Tom is seduced by just about everything that he comes in contact with. That his story manages to be touching and funny along the way is testament to the sensibility of the music and the literate libretto. With Nick Shadow, Satan's emissary, as Tom's guide, he gains sudden wealth, leaves his bucolic village for wicked London, loses everything and winds up in an asylum. Tom rolls merrily along, until he doesn't.

To maximize the number of qualified students performing in a fully staged opera, there was one set of principal performers for the Friday evening performance and another for the Saturday matinee. But before delving into what was different about the two casts, let's mention what both performances had in common.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635782608/Rake3.jpg.jpg)
<figcaption>Ganson Salmon as Tom Rakewell and Wan Zhao as Baba the Turk in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

For starters there were 20 singers in the ensemble but it seemed like there were many more because of their rich and varied portrayals including prostitutes and their clients, groupies of Baba the Turk (more on her later), greedy auction patrons, and, finally, inmates of the asylum at Bedlam. How grand they made the production look, dressed in Helen E. Rodgers' historically accurate, suitably salacious, and asylum-ethereal costumes. Laura Alley's smart and lively stage direction helped the ensemble, and the principals as well, to create finely tuned characterizations, on a level that is usually the pride of opera's more illustrious stages.

Roger Hanna's set was comprised of brick ramps and platforms with a minimum of fixed elements so that the scene changes were unencumbered. Wildly eccentric objects in Tom's London digs evoked Soane's eclectic museum collection, as clever a visual reference as one could hope for. A versatile curtain draped over part of the set was a useful and appropriately old-fashioned touch.

With the exception of an errant pediment on Friday evening that managed to find its proper fitting on Saturday, all worked smoothly. The screen of peering eyes above the asylum was a momentarily jarring and unnecessary element in an otherwise attractive and intelligent design.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635818656/Rake9.jpg.jpg)
<figcaption>Zachary Goldman as Tom Rakewell and Wil Kellerman as Nick Shadow in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

Stravinsky's score, to put it lightly, is rhythmically, melodically and harmonically, a minefield. Retiring director of Mannes Opera and *Rake*'s conductor, Joseph Colaneri, said that "from a pedagogical standpoint, it is important to 'push the envelope' with student singers and instrumentalists." Happily, his musicians pushed along with him. Perhaps because of the multi-leveled orchestra pit at the Gerald W. Lynch Theater, the horn and trumpet entrances weren't as sharp as they might have been. But overall the orchestra was precise and impressively confident. The strings, especially vulnerable in any Stravinsky, were bright and nuanced. Maestro Colaneri, who will be a guest conduct for Mannes in the future, must have been pleased that his last outing as director was such an unalloyed success.

Ganson Salmon was all anyone could ask for as Friday night's Tom. His tenor was clear and vigorous as a clueless romantic. With brilliantly expressive singing Salmon captured Tom's decline in ways that exceeded the requirements and the opportunities of the music and libretto. He animated his character's posture, facial looks and physical movement with an infectious wit that gradually dissipated. While terrifically entertaining, this Tom lost so much on his journey, that he was movingly sad.

Saturday's Tom, Zachary Goldman, was quite another story. With a handsome sound making one think that a recording of Puccini arias might be in his future, his Tom was congenial still water. Though steadily clouded by the temptations at hand, Goldman acquiesced to beautiful singing in place of deeper character development. His Tom was sweet in voice and nature but a little dull. To be fair, Goldman would have seemed more convincing (dull can work for Tom) had he not been preceded in the role by Salmon's virtuoso turn.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635797084/Rake6.jpg.jpg)
<figcaption>Danielle Beckvermit as Anne, Aaron Jenkins (Top Hat) as Sallen and Yinpei Han as Baba the Turk in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

Both Anne Truloves were well matched with their Toms. Friday's Meigui Zhang displayed a lovely soprano that transitioned from sheer romance to demonstrate her character's steadfastness and intelligence. On Saturday, Danielle Beckvermit was more the country girl, with a lovely sound and naive demeanor. Her tendency to drop low notes will hopefully dissipate as her vocal training moves forward.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635810377/Rake8.jpg.jpg)
<figcaption>Wil Kellerman as Nick Shadow in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

The Nick Shadows were chilling creations sung with sardonic wit and deceptive fawning by two winning baritones. Michael Pitocchi was an imposing and rather threatening Nick on Friday, whose menace was appropriately lost on Salmon's energetic and trusting Tom. Wil Kellerman's Nick on Saturday was sly, even impish at moments. It was readily understandable how Goldman's Tom failed to notice with whom he was dealing. Both interpretations converged unequivocally when Nick demanded his due. Pitocchi and Kellerman fully inhabited Nick's faintly modern persona and mined the character for its comic potential without dramatic compromise.

Maestro Colaneri commented that Baba the Turk, the infamous bearded lady who Tom marries, is, vocally speaking, "at times quite low and requires an energetic singing style in the lower ranges of the mezzo voice." How fortunate that Wan Zhao and Yinpei Han, two fine mezzo-sopranos, could channel this grotesque, overbearing and often funny character with such pointed singing and bombastic arrogance. These Babas were strangely likeable and elicited the production's biggest laughs during her temper tantrum.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635776124/Rake2.jpg.jpg)
<figcaption>Cloe San Antonio as Mother Goose, Ganson Salmon as Tom Rakewell and members of the ensemble in The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

For both performances Jongwon Choi, a penetrating bass, played Trulove, Anne's father, with a sturdy no-nonsense air. Samuel Rachmuth was an able townsman and William Desbiens and officious but empathetic keeper of the asylum. Toby Otorubio and Aaron Jenkins, two hearty tenors, were Friday's and Saturday’s Sellem, the lively auctioneer. Mezzo-sopranos Cloe San Antonio and Taryn Holback gave Mother Goose, the brothel proprietress a Weimar inspired whirl and delighted their audiences in the process.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527635789310/Rake4.jpg.jpg)
<figcaption>Michael Pitocchi, Jongwon Choi, Ganson Salmon, Wan Zhao and Meigui Zhang in the epilogue to The Mannes Opera production of *The Rake's Progress*. Photo: Eugenia Ames.</figcaption>
</figure>

When all seems lost and Tom has sacrificed his sanity in lieu of his life, to Nick, who himself is recalled, Stravinsky and Auden snap the principal singers back full throttle. They tell us that a moral can be drawn from everything we have just witnessed. Their warnings in this "greatest hits" curtain call are stern, cynical, rueful, naïve, and even sensible, depending on which character is singing. They are so amiably presented that, like Tom, we too rolled merrily along.
