+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-09-24T09:09:00-04:00"
lastmod = "2017-09-24T10:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506261885594/2017-09-24---square---Colm-Feore-Jag-Gundu.jpg.jpg"
primary_image_credit = "Colm Feore hosting the TSO\"s Tribute to Glenn Gould. Photo: Jag Gundu."
publishDate = "2017-09-24T10:22:00-04:00"
related_articles = ["articles/in-review-seven-deadly-sins-at-tso.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/jan-lisiecki.md"]
short_description = "Lisiecki had me stunned not over the deftness of his hands, but over his sense of breath, space, and chamber music. He left room for humanity in even the trickiest of passages, and he was constantly conscious of who his current duet partner was. He challenged the orchestra to play unbearably soft, and ferociously attacked the piano to achieve enormous volume, without ever leaving an ugly edge."
slug = "memorable-nights-the-tsos-tribute-glenn-gould"
title = "Memorable nights: the TSO&#039;s tribute Glenn Gould"
+++

In this final quarter of Canada's 150th year, I cross my fingers and hope that I'm not the only one who is just a pinch weary of concerts and theatre that make a point of paying timely homage to our country. Happily, there was something organic and cohesive about the [Toronto Symphony Orchestra](/scene/companies/toronto-symphony-orchestra/)'s *A Tribute To Glenn Gould*, presented this weekend at Roy Thomson Hall. The simple ingredients for a great concert were there: great music, eye-popping performers, and a thematic link that was endearing and interesting.

Friday night's concert began with Yannick Plamondon's Sesquie for Canada's 150th, *Wīhtikōw - In memoriam femmes mortes: enlevées et disparues*. A dissonant, even nauseating remembrance of the ~1860 Aboriginal women who have disappeared or been murdered since 2014, Plamandon's sound evoked something similar to Penderecki's *Threnody for the Victims of Hiroshima*. The piece is powerful and dense, and almost a risky choice for a concert opening; the chaotic dissonances seemed to give a big nod to the stereotypes of Canadian music, and the "where's the tune?" trope that half-jokingly accompanies.

The night's salute to Glenn Gould was generous, connected likably by host Colm Feore, whose own relationship with the Canadian pianist comes in his [*Thirty-Two Short Films About Glenn Gould*](http://www.imdb.com/title/tt0108328/) (1993). We heard Kelly-Marie Murphy's fantastical *Curiosity, Genius, and the Search for Petula Clark*, inspired by Gould's fascination with chasing radio stations along a drive up to Northern Ontario; at various points, Gould could hear on the radio the strains of Petula Clark's ["Who Am I?"](https://www.youtube.com/watch?v=Tvs-x6HKU6g), and he began to drive strategically so as not to miss the relayed broadcasts of the song. He speaks about this pop song with the same focus and intellect as he would use on Bach," writes Murphy in her programme notes. "It is both funny and charming." Murphy's piece is completely fun to hear, very film-score-inspired, yet fully capable of standing alone in a concert setting. The percussion section seemed to hog the spotlight, except during the notable exceptions of the kick-ass brass writing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506261730495/2017-09-24---Jonathan-Crow-Kelly-Marie-Murphy-Peter-Oundjian-pc-Jag-Gundu.jpg.jpg)
<figcaption>TSO Concertmaster Jonathan Crow, composer Kelly-Marie Murphy, and TSO Music Director Peter Oundjian. Photo: Jag Gundu.</figcaption>
</figure>

Wagner's *Siegfried Idyll* came as a gorgeous sorbet for the ears. Its place on the programme comes from Gould's recording of his own piano transcription of the piece; in one of his earlier forays into conducting, he also recorded the original chamber version we hear from members of the TSO.

The concert's second half was filled by Johannes Brahms' mammoth *Piano Concerto No. 1 in D Minor*. The piece is heavy, yet the Gould connection is a cool mix of intriguing and light-hearted. Gould's infamous [1962 performance of the concerto](https://www.youtube.com/watch?v=zuxPKikM0NI) with the New York Philharmonic was part of his significant working partnership with Leonard Bernstein - "Glenny and Lenny". Before Gould's performance, [Bernstein made an introduction-disclaimer](https://www.youtube.com/watch?v=zuxPKikM0NI) (perhaps intended as a joke) that their opinions over the tempo was one of their largest artistic differences to date. In short, Gould wanted the Concert played slowly, and Bernstein wanted it fast.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506261842896/2017-09-24---full---Jan-Lisiecki-Peter-Oundjian-Jag-Gundu.jpg.jpg)
<figcaption>Pianist Jan Lisiecki and TSO Music Director Peter Oundjian. Photo: Jag Gundu.</figcaption>
</figure>

Peter Oundjian's tempo was merciful, paving the way for us to focus in on the incredible [Jan Lisiecki](/scene/people/jan-lisiecki/) at the piano. It's easy for eyebrows to raise when one hears the words, "22 year-old pianist", but Lisiecki was a real-deal phenomenon. The pairing of pianist and concert was notable, too; compared to the abandon and bravura of Rachmaninoff or Liszt, Brahms' Concert is carefully crafted so as every notes counts, and no page in the score contains thoughtless fluff or texture. Everything is measured and accounted for, and so every note counts.

Lisiecki had me stunned not over the deftness of his hands, but over his sense of breath, space, and chamber music. He left room for humanity in even the trickiest of passages, and he was constantly conscious of who his current duet partner was. He challenged the orchestra to play unbearably soft, and ferociously attacked the piano to achieve enormous volume, without ever leaving an ugly edge. I got honest-to-goodness chills as he tore into the third movement with a rockstar bite to his sound; he left Oundjian's reponse sounding a bit tame - lame, even? - as though he was on the losing end of a really exciting play-off.

Lisiecki's standing ovation was immediate and totally well-deserved. How exciting to see a young performer show off a rare combination of fresh energy and settled musicianship!
