+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-26T19:34:00-04:00"
lastmod = "2015-10-29T12:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446085538390/15-10-29%20-%20PocketConcertsVertical.jpg.jpg"
primary_image_credit = "Photos by Bo Huang."
publishDate = "2015-10-29T11:30:00-04:00"
related_articles = ["articles/pocket-concerts-and-their-worthy-campaign.md"]
related_companies = ["scene/companies/pocket-concerts.md"]
related_people = ["scene/people/rory-mcleod.md","scene/people/emily-rho.md"]
short_description = "The concept of going to someone&#039;s house for some live chamber music might seem strange to anyone who isn&#039;t a big concert goer. But musicians know that house concerts are a common occurrence, that they&#039;re often under-advertised and often private, and that they&#039;re a fantastic way to experience music. The folks from Pocket Concerts are taking the in-home concert model, and making it an experience that anyone can have."
slug = "meet-the-folks-pocket-concerts"
title = "Meet the folks: Pocket Concerts"
+++


The concept of going to someone's house for some live chamber music might seem strange to anyone who isn't a big concert goer. But musicians know that house concerts are a common occurrence, that they're often under-advertised and often private, and that they're a fantastic way to experience music. The folks from [Pocket Concerts](/scene/companies/pocket-concerts/) are taking the in-home concert model, and making it an experience that anyone can have.

Pocket Concerts director and violist [Rory McLeod](/scene/people/rory-mcleod/) remembers talking with his brother and fellow violist, Alex McLeod, about the great experiences they had had performing house concerts. These concerts usually come up through the musician grapevine; someone, or their friend, knows a musician, and they reach out directly for a concert request. McLeod was interested in making this process accessible to the general public.

"Our conversation was basically about, ‘how can we make more house concerts happen?’ And so the real planning was about figuring out how to create an organization that anybody can access, where you don’t need to know the musicians in advance, but you can have that house concert experience in your home if you want to, as long as you have the space."

From her own house concert experience, pianist and Pocket Concerts co-director [Emily Rho](/scene/people/emily-rho/) knows that the value of an intimate space extends to the players as well as the audience. "As a performer, I feel like everyone can see every single one of my fingers, and every single thing I do with my feet with the pedal. It’s pretty intense, but I love that energy."

## Creating performance opportunities

One trope that young musicians hear often upon leaving school is that they must be willing to create their own opportunities to perform. "To be honest, there was a little bit of frustration that drove it at the beginning," says McLeod. "I love playing chamber music, but there were enough opportunities to play it." 

For musicians, a series like Pocket Concerts solves the problem of getting chamber music heard by more people, and it solves the problem of getting more gigs. "So yes, I was trying to create opportunities for myself and other young musicians especially, but that was also part of it. Trying to make the experience available to anybody who wants it."

## An interactive listening experience

"One thing that’s really different about Pocket Concerts," explains Rho, "is that there’s really no distinction between the 'stage' and the audience." It's a set-up that can seem intimidating for concert newcomers, but Pocket Concerts is set on keeping their performances barrier-free.

"If people want to clap after a movement or something, we let them. If the piece ended in a heroic, V-I cadence, they’re gonna want to clap. The music demands that first of all, and we don’t want them to feel uncomfortable."

Rho has seen the results of a comfortable audience, where accessibility leads to curiosity. "If there’s a stop between movements or pieces, people often ask question. Sometimes it leads to a mini-discussion." It's a rare thing in concerts, but not entirely new; McLeod recalls [Rob Kapilow](http://www.robkapilow.com/) hosting a Q&A session at Roy Thomson Hall, "but the audience had to yell their questions from the back of the hall." 

Just like in everyday life, conversations are more possible when people share an intimate space. "The experience was really rewarding for everybody involved," says McLeod, "because the musicians get a chance to really connect with the audience. There’s a little bit of back and forth throughout the performance; people can ask questions, the atmosphere is casual and comfortable for people."

## Positive feedback

"Maybe we're redefining home entertainment," laughs McLeod. "Youtube and Netflix can only give you so much satisfaction, and people are longing, I think, for a real personal contact." Musicians don't always get to mingle with their audience directly after a concert, nor audiences with the performers. McLeod loves the integration of a Pocket Concerts performance.

"That’s one of the most rewarding things for us, is to see how open the audience is after a performance. We get a bunch of strangers together in a room, and they sit down for an hour and listen to music. And it transforms the whole dynamic, the energy in a room." 

Rho agrees that sharing a musical experience can make friends out of a group of strangers. "I just love seeing new connections forming and those connections lasting beyond the Pocket Concert circle. I know two couples who met at Pocket Concerts last January, and they became friends very quickly at this event. That kind of connection being made, it is so much more than just listening to music together."

## Office Concerts

Recently, Pocket Concerts has extended their reach, offering concerts in offices and workspaces. The plan for Office Concerts centred on a desire to expand the Pocket Concerts audience, "without sacrificing the intimate quality of it." McLeod and Rho started looking at offices as another avenue for concert spaces, noting that second to the home, the workplace is where many people spend large amounts of their time. McLeod adds, "we’re hoping that Office Concerts will be a stimulus for that kind of social contact, that will actually be able to help create connections at work."

They anticipate demand for office concerts with companies trying to foster a creative and social work environment. "Startups, for example, might be interested in hosting an event like this," says McLeod. "Big corporations downtown might feel like ‘we want to give something back to their employees, we have the money to do this.' We’re hoping to make it a regular event with some organizations. They could book a monthly concert if they want."

It's a significant mission of Pocket Concerts, to lower barriers between listeners and their idea of a classical music concert; with Office Concerts, zero work is asked of the audience. "Being able to enjoy a concert at work, say at the end of the day, or during lunch hour, you don’t have to go anywhere. And why not? Chamber music is a very portable art form."

## Come to a concert

The next Pocket Concert is [November 29th, 2pm](https://www.universe.com/events/pocket-concerts-presents-brahms-at-the-wharf-tickets-toronto-SN18H4). Violinists Andrea Tyniec and Rebecca MacLeod, violists Rory McLeod and Theresa Rudolph, and cellists Rachel Desoer and Bryan Holt host a [*Party with Brahms at the Wharf*](https://www.universe.com/events/pocket-concerts-presents-brahms-at-the-wharf-tickets-toronto-SN18H4). The programme even includes my all-time fave, the String Sextet in B-flat Major.

If you can't make it in November, head to the Annex to hear [Aaron Schwebel](/scene/people/aaron-schwebel/) (violin), [Britton Riley](/scene/people/britton-riley/) (cello) and Pocket Concert's Emily Rho (piano) take on Mendelssohn's Piano Trio in C minor.

If you know of an office in need of chamber music, get more info about Office Concerts [right here](http://www.pocketconcerts.ca/#!office-pocket-concerts/mli9a). For details on hosting a private house concert, [click here](http://www.pocketconcerts.ca/#!private-pocket-concerts/c380). Rory McLeod vouches for concert lovers and first-timers alike. "I haven’t had an experience where someone said it wasn’t for them."

>For details and ticket information for Pocket Concerts on November 29th, follow the box office links below.
