+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-01T14:28:00-05:00"
lastmod = "2015-11-06T15:41:00-05:00"
preamble = "[Liza Balkan](/scene/people/liza-balkan/) is a Canadian dancer, actor, writer, and director of theatre and opera. After seeing her fantastic work with [The Bicycle Opera Project](/in-review-shadow-box/) this summer, I spoke with Balkan between rehearsals at The Glenn Gould School for their upcoming production of Xavier Montsalvatge's *Puss in Boots*, with Luciano Berio's *Folk Songs*. She talks about her work with Canada's fringe opera scene, and what it feels like to hear the words she writes set to music.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446512239093/2015-11-02---Liza-Balkan---Square.jpg.jpg"
publishDate = "2015-11-03T11:57:00-05:00"
related_articles = ["articles/opera-directors-an-unfair-disadvantage.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/the-bicycle-opera-project.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/liza-balkan.md"]
short_description = "&quot;Why do I do it? I love telling stories.&quot; Balkan agrees that the process can be different from theatre to opera, from workshop to finished product, but it&#039;s always inspiring. &quot;The collective minds in a room, what can be created that way is just so delicious.&quot;"
slug = "meet-the-director-liza-balkan"
title = "Meet the director: Liza Balkan"
+++

## From theatre to opera

"Every now and then I’ll miss performing, but mostly these days I love telling stories, whether it’s writing, or most especially directing. So it’s a juggle, but it seems like less of a juggle these days." Liza Balkan's career has evolved over several decades, from her original background in dance and acting, to writing and directing works of her own. These days, she's primarily a director, with a few libretti in "the early stages."

Her interest in directing came out of a desire "to tell stories as a director rather than just be involved in the telling as an actor." A visual thinker, she had her own list of stories she wanted to tell. Balkan had also met Canadian director [Tom Diamond](//tom-diamond-on-directing-opera/) at The Banff Centre in the 1970s; when he later began working at [Tapestry New Opera](/scene/companies/tapestry-opera/), she asked if she could sit in on his rehearsals. "It just felt like home, I understood it. I read music, I understand music, even in directing plays it’s always the musicality of a piece that I latch onto."

One of her first musical projects was *Still the Night*, a 1997 co-production with Tapestry New Opera, Theatre Passe Muraille, and Tova Entertainment, for which Balkan received a Dora Award. "It was a music theatre piece, based on the Holocaust. It was a two-hander, myself and Theresa Tova. That was my entrance into Tapestry."

Her work with Tapestry continued, after she helped direct one of Tapestry's Opera Briefs. "I was lucky enough to work with people like [Carla Huhtanen](/scene/people/carla-huhtanen/), [Keith Klassen](/scene/people/keith-klassen/), that beautiful tribe of artists. They approached the material as singers and also as actors." She calls it "an exciting challenge, it offered all kinds of puzzles that I was chomping at the bit to jump into."

There indeed is a big puzzle that opera presents to all directors, and that's the fact that the action doesn't unfold in real, naturalistic time; the addition of music can stretch a moment into several minutes (see: Wagner), or it can make a man declare his love for a woman within 15 minutes of meeting her (see: Puccini). "But that’s always a key challenge; where does the piece live when the singing stops? And how do the relationships continue on, how does the story continue on?"

How does Balkan find the balance between being inspired by the music, and superimposing upon it? "You want to honour that story, and at the same time you want to keep the dramatic through line going forward." Tom Diamond has mused before about how Mozart is one of the greatest stage directors who ever lived, and that his music can tell him everything he needs to know. Balkan echoes the same sentiment: "If you are willing to just shut up and really listen, the music tells you where to go."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446570427898/2015-11-02---Bike-Opera-Balkan-.jpg.jpg)
<figcaption>Geoffrey Sirett in The Bicycle Opera Project's *shadow box*, directed by Liza Balkan, 2015. Photo: Terry Lim.</figcaption>
</figure>

## Opera on the fringe

Balkan's experience in opera can be considered "on the fringe," including lots of work with Tapestry Opera and the [SummerWorks Festival](http://summerworks.ca/2015/). She directed [*Opera on the Rocks*](http://www.thegate.ca/reviews/01561/toronto-fringe-08-opera-on-the-rocks/) in 2008, one of the first site-specific operas in Toronto, at [Pauper's Pub](http://www.pauperspub.com/home). "The pieces were written by six different playwrights, and one composer. The pieces were about hockey, and people were on the bar, and it was about your BFFs, and drinking, and [Lavalife](https://www.lavalife.com/), and people would be eating their chicken wings, and there would be Keith Klassen getting right up close and singing." 

*Opera on the Rocks* was part of opera's newest evolution, bringing the "high art" into small venues, where the performers could be integrated with the audience; companies like [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/), and [FAWN Chamber Collective](/scene/companies/fawn-chamber-collective/) have followed suit. For Balkan, the appeal of this model is simple: "Getting that close to opera is thrilling."

She has directed "traditional" opera, too, directing *L'elisir d'amore* and *Le nozze di Figaro* at the [Centre for Opera Studies in Italy](/cosi-centre-for-opera-studies-in-italy/). "I’d love to do more Mozart. It’s all subtext and gorgeous music."

More recently Balkan worked with The Bicycle Opera Project ("They’re insanely talented, and they’re amazing.") on *shadow box*, their 2015 touring production in Nova Scotia and Ontario. "I love Bicycle Opera. I’m in awe of them, just their stamina, their artistic and their physical stamina!" *shadow box* is a collection of scenes by Canadian composers and librettists, and this season, Bike Opera took it on about 1000kms of road. "I saw them as operatic improvisors, which is a rarity. They would go into a space, and each space was different. And on their own, they would figure out, ‘ok, in this space there’s a balcony, let’s put that piece up on the balcony,' or ‘let’s use that entrance over there.’"

Bike Opera's mandate is in line with Balkan's philosophy on the funtion of live theatre. "Their desire is to make opera accessible, and to tell stories, and to find eco-friendly ways of doing it as well. So, honouring the art, honouring the planet, honouring themselves, honouring the writer and composer."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446570304738/2015-11-02---TapestryBriefs2012---Harold-Henz-pc.jpg.jpg)
<figcaption>Andrea Ludwig in Tapestry Opera's *Opera Briefs*, 2012, written by Liza Balkan and directed by Michael Mori. Photo by Harald Benz.</figcaption>
</figure>

## Her words, set to music

"Opening nights are always challenging for any director. I have many friends who are always at bars down the street on opening nights," laughs Balkan. I told her I didn't blame them. The vulnerability for criticism is huge for a director, but she does take time to enjoy her finished products. "There’ll be times when I’ll return to see pieces that I’ve directed, because I’m proud of the work we all created, and I enjoy watching it."

Balkan is a librettist, too, and she has great respect composers, and for "rigour and training involved" in the singers' skill. "It’s such a joy and honour to hear words that I’ve written accompanied by music. Because the words change, because the music does its own thing, music tells an extraordinary story on its own. So when both are supporting each other, I’m so happy to hear it. In some ways I’m able to stand back and think 'oh my goodness, that’s a beautiful thing.’ And, you know at times ‘oh, that’s a less beautiful thing, and I wonder why’, and so it helps me understand the nugget around how to create work that I think is worthwhile and compelling."

With the "joy and honour" comes that same vulnerability, agrees Balkan, when a librettist hears her words sung by others. "Seeing it out there, hearing it out there, sure, hearing your words spoken by the people, it’s both thrilling and horrifying at times."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446732265122/DSC_2972.jpg.jpg)
<figcaption>Wallis Giunta in the Canadian premiere of Louis Andriessen's *Anais Nin*, 21C Festival, Koerner Hall. Photo: Lisa Sakulensky.</figcaption>
</figure>

## Why do it?

"Why do I do it? I love telling stories." Balkan agrees that the process can be different from theatre to opera, from workshop to finished product, but it's always inspiring. "The collective minds in a room, what can be created that way is just so delicious."

Opera has presented puzzles and challenges to Balkan over nearly two decades of work in the genre; in the end, it's about expanding the palate of colours available to paint a picture, to tell a story. "That’s what it comes down to, is the desire, for me, to tell what is the truth of a story. It takes an enormous amount of work, often, to find the truth, and sometimes the work is just getting out of your own way, because the truth is present."

>The Glenn Gould School presents Montsalvatge's *Puss in Boots* and Berio's *Folk Songs* November 13th and 14th, 7:30pm in Mazzoleni Hall. For details and tickets, follow the box office links below.
