+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2024-06-02T00:00:00-00:00"
lastmod = "2024-06-02T00:00:00-00:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1717446779/Polenzani_Recital.jpg"
primary_image_credit = "Pianist Ken Noda and tenor Matthew Polenzani acknowledged with floral bouquets after their recital in the Board of Officers Room at the Park Avenue Armory. Photo: Mike McHugh."
publishDate = "2024-06-02T00:00:00-00:00"
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/michael-spyres-at-the-park-avenue-armory-big-voice-in-an-intimate-room.md"]
related_people = ["scene/people/matthew-polenzani.md"]
related_companies = [""]
short_description = "Pianist, Ken Noda, with whom Polenzani shares a seemingly symbiotic musical relationship, projects an all together different presence. Appearing almost motionless at the keyboard, he nonetheless captures the myriad moods and musical nuances required by the songs. Noda appeared to be holding his breath while Polenzani reveled in the music. Their interplay was mesmerizing."
slug = "matthew-polenzani-in-recital-an-abundant-performance"
title = "Matthew Polenzani in recital: an abundant performance"

+++
When [Matthew Polenzani](/scene/people/matthew-polenzani/) entered the Board of Officers Room at the Park Avenue Armory for his recent recital he was greeted with rapturous applause, the kind associated with operatic superstars. I guess he is one but you might not know it by his neighborly demeanor. A stalwart at the Metropolitan Opera, he's an impressive presence in a range of roles including the noble Idomeneo, passionate Nadir in _Les pécheurs de perles_ and a delightfully earnest Enresto in _Don Pasquale_.

We should not be surprised that he takes to the recital stage with the same ability to create vivid characterizations. Polenzani's voice is robust, velvety, and supremely confident, imbuing each song with a unique immediacy. In this abundant recital he delves into the works of Franz Schubert, Gerald Finzi (a mixed blessing), Robert Schumann, and Charles Ives, like a master storyteller. His gestures and physical bearing, calibrated with seasoned awareness, contributed to an engaging theatrical atmosphere. This expressive tenor knows what he is singing and how to reach his audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1716563518/MatthewPolenzani-FayFox.jpg){{% /md %}}
<figcaption>Tenor Matthew Polenzani sang songs by Franz Schubert, Robert Schumann, Gerald Finzi and Charles Ives. Photo: Fay Fox.</figcaption>
</figure>

Pianist, Ken Noda, with whom Polenzani shares a seemingly symbiotic musical relationship, projects an all together different presence. Appearing almost motionless at the keyboard, he nonetheless captures the myriad moods and musical nuances required by the songs. Noda appeared to be holding his breath while Polenzani reveled in the music. Their interplay was mesmerizing.

Polenzani opened with Schubert's "Im Frühling", singing of a man lost in memory and closed the Schubert set with "Im Abendrot", in which the narrator reckons with faith and mortality. In between he made room for "Ständchen", by art song standards a runaway hit, that blends night sounds with a melancholic romantic plea. Ernst Schulze, Karl Lappe and Ludwig Rellstab provided the texts respectively. 

Heinrich Heine's poems expressing both passion and dispassion, were the basis for Schumann's nine-song cycle. If there was to be a test of Polenzani's interpretative prowess and ironic sensibility, this was it. Happily and sadly, one song mounted upon another. "Morgens steh' ich auf und frage", and "Ich wandelte unter den Bäumen" fully realized the tremulous state of a sometimes lighthearted, often dispirited and eternally faithful lover.

Finzi's _A Young Man's Exhortation_, a cycle of ten songs, though something of a kindred spirt to the Schumann, was quite another matter. Noda is to be commended for summoning, when the songs allowed, that unmistakable English sound, of which Finzi along with Ralph Vaughan Williams are major exponents. Based on a group of poems by Thomas Hardy, part one depicts in some detail the glories of youthful love while part two counters with images of aging and resignation. Polenzani, mindful of the divide, sang in the main with requisite energy and gravity, particularly in the title song and in part two's "The Sigh",
an endearing and sad lament. But in total the cycle often overheated the otherwise warm acoustics of the armory's baronial room. It left this listener wanting less Finzi.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1717446779/Charles_Edward_Ives_-_National_Portrait_Gallery__Smithsonian_Institution__NPG.82.185.jpg){{% /md %}}
<figcaption>Songs by modernist composer Charles Ives hinted at the tremendous invention he would bring to the art song and showed that he was not put off by a lovely melody. Photo: Clara Sipprell, National Portrait Gallery, Smithsonian Institution.</figcaption>
</figure>

Conversely I wanted more of Ives added to the wild grouping by this modernist, especially as Polenzani sang them in his own contemporary mode. "The World's Highway" and "Rather Sad", both with lyrics by Ives, charmed with their sweetness and drama. Polenzani brough high energy to "The Greatest Man", from a prose poem by Anne Collins, which hinted at the tremendous invention he brought to the American art song. "Rather Sad", a wistful tune featuring another Ives lyric and the heart-rending ballad, "When stars are in the quiet skies", set to a poem by Edward Bulwer-Lytton, reminded us that this experimental composer was not put off by a lovely melody.

"Danny Boy", then, seemed the inevitable encore. What for some was a misty-eyed departure, Polenzani and Noda left the stage, bedecked with large floral bouquets, to even more rapturous applause.