+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-18T17:06:00-04:00"
lastmod = "2018-03-23T10:59:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521407190631/Geoffrey-Sirett-as-Akakiy-in-The-Overcoat-A-Musical-Tailoring_Photo-Credit-Dahlia-Katz.jpg.jpg"
primary_image_credit = "Geoffrey Sirett as Akakiy in The Overcoat, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz."
publishDate = "2018-03-20T20:28:00-04:00"
related_articles = ["articles/in-review-rocking-horse-winner.md","articles/in-review-tapestry-briefs-booster-shots.md","articles/a-perfect-fit-the-overcoat.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/vancouver-opera.md"]
related_people = ["scene/people/geoffrey-sirett.md","scene/people/asitha-tennekoon.md"]
short_description = "&quot;The overcoat is stunning,&quot; says baritone Geoffrey Sirett, who is set to sing the role of Akakiy. &quot;It transforms his life, because it is so beautiful and immaculately designed, and it gives him his five minutes of fame.&quot;"
slug = "materialism-turns-tragic-dont-miss-the-overcoat"
title = "Materialism turns tragic: don&#039;t miss The Overcoat"
+++

*The Overcoat*, the 1842 Ukrainian short story by Nikolai Gogol, sees its second adaptation this month in a [co-production with Tapestry Opera, Canadian Stage, and Vancouver Opera](https://tapestryopera.com/the-overcoat-a-musical-tailoring/). Director and playwright Morris Panych first imagined *The Overcoat* 20 years ago with movement director Wendy Gorling, as a piece of "silent-theatre" underscored by selected music by Dmitri Shostakovich. Now, Panych and his creative team revisit the story, adapted into an opera with an original score by James Rolfe (*Beatrice Chancy*, *Crush*, *Elijah's Kite*).

The operatic *Overcoat* has origins in Tapestry Opera's LibLab, a bootcamp of sorts that pairs together composers and librettists to create sixteen original scenes in a dense four-day workshop. Panych was part of the 2014 LibLab, and when his composer partner had to unexpectedly withdraw, he found himself instead working with Rolfe. One of the final scenes they produced over the four days was one inspired by a story Panych knew well, *The Overcoat*.

Rolfe and Panych's adaptation, [*The Overcoat: A Musical Tailoring*](https://tapestryopera.com/the-overcoat-a-musical-tailoring/), has its world premiere this month, running in Toronto **March 29 to April 14**, before heading west as part of Vancouver Opera's second annual Vancouver Opera Festival, [**April 28 to May 12**](https://www.vancouveropera.ca/The-Overcoat). 

Despite its materialistic title, *The Overcoat* is surprisingly heartbreaking. Akakiy Akakiyevich, an under-appreciated, introverted working man, asks a tailor to make him a new overcoat, one that will earn him status, respect, and perhaps even happiness. His plan works, at least for a short while - until his high hopes turn pitiful.

"The overcoat is stunning," says baritone Geoffrey Sirett, who is set to sing the role of Akakiy. "It transforms his life, because it is so beautiful and immaculately designed, and it gives him his five minutes of fame."

With a name like Akakiy Akakiyevich - a fabricated Ukrainian name with scatological etymology - it's no mystery that he is a man passed over by society, viewed as lowly, even invisible. Starting at such social depths only gives Akakiy farther to go in his journey toward achieving social status - and of course, subsequently gives him farther to fall.

The role of Akakiy is certainly an exaggeration, a caricature of men and women with fluctuating self-worth, yet his story is one that resonates with reality. It may sound like hyperbole, but it's certainly relatable to put unreasonable expectations onto our material possessions. "This coat gives him an importance," says tenor Asitha Tennekoon, who sings The Manager. "This coat raises his status in the eyes of his colleagues."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521410037511/SirettTennekoon.jpg.jpg)
<figcaption>Geoffrey Sirett (left) and Asitha Tennekoon, both singing in the world premiere production of Morris Panych and James Rolfe's *The Overcoat*, 2018.</figcaption>
</figure>

It seems to be human nature, the desire to own something that can transfom our lives. Instead of asking ourselves who we are, says Tennekoon, "You put all your hopes and dreams into one particular thing."

For those who haven't seen or read *The Overcoat*, the story is still intriguing on reputation alone; it's a story that, in its already varied media, inherently draws in its audience.

For Sirett, there's unique power in Gogol's story, which "can cover the full scope of tragedy, with just a single item."

*The Overcoat* premieres on March 29 at the Bluma Appel Theatre, 27 Front St. E., directed by Morris Panych and conducted by Leslie Dala. For details and ticket information, [click here.](https://www.canadianstage.com/Online/default.asp?BOparam::WScontent::loadArticle::permalink=overcoat)
