+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-08-12T03:34:00-04:00"
lastmod = "2015-09-04T08:39:00-04:00"
preamble = "American choreographer, director and conductor [Mark Morris](/scene/people/mark-morris/) is one of those people that's difficult to introduce. He has worked with the likes of Peter Sellars, Yo-Yo Ma, and Mikhail Baryshnikov, and opera lovers will know his choreography in Adams' *Nixon in China*, and his direction/choreography of Gluck's *Orfeo ed Euridice*, both at the Metropolitan Opera.\n\nHis company, the [Mark Morris Dance Group](/scene/companies/mark-morris-dance-group/), is a tight group of dancers, designers, and musicians, and they travel across the globe, presenting an average of 90 shows a year. \n\nI met Morris for a brief chat at The Banff Centre this past summer, where he seemed to speak about everything. His frank passion for theatre stayed with me, and made me want to talk more and more. Morris was kind enough to indulge me in a honest interview about how he's been able to do all that he does."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441224982387/Mark-Morris_Amber-Star-Merkens_2015-selectSquare.jpg.jpg"
primary_image_credit = "Photo by Amber Star Merkens."
publishDate = "2015-09-04T08:00:00-04:00"
related_articles = ["articles/united-we-stand-divided-we-fall.md"]
related_companies = ["scene/companies/mark-morris-dance-group.md"]
related_people = ["scene/people/mark-morris.md"]
short_description = "American choreographer, dancer, director and conductor Mark Morris is one of those people that&#039;s difficult to introduce. He has worked with the likes of Peter Sellars, Yo-Yo Ma, and Mikhail Baryshnikov, and has a firm hand in dance and opera today. His company, the Mark Morris Dance Group, is a tight group of dancers, designers, and musicians, and they travel across the globe, presenting an average of 90 shows a year."
slug = "mark-morris-clarity"
title = "Mark Morris: &quot;Clarity.&quot;"
+++

### 1. Why do you think your work, and your company, have stayed so strong and so relevant over several decades?

I am a very good choreographer. I have a company of very good dancers and musicians. I work with very good designers and I have a very good team and staff. We work very hard and present consistently high quality and humane concerts. We have a big international audience of all kinds of people. Not just a dance public. I'm interested principally in the relationship between "live" music and "live" dance. We are invited back to most places where we have performed. We are reliable. I'm honest.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441224494571/the-hard-nut-stephanie-berger-20Resized.jpg.jpg)<figcaption>A scene from *The Hard Nut*, Mark Morris' take on *The Nutcracker*. Photo by Stephanie Berger.</figcaption>
</figure>

### 2. You’ve worked in various performance media (ballet, opera, conducting, etc.). Do they have similar challenges and learning curves?

My company, MMDG is my chief job. Ballet and opera projects are a direct extension of my choreomusical point of view and aesthetic. Conducting is my most recent endeavor and therefore the most challenging and daunting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441224579571/Allegro_Lincoln-Center-2013_Kevin-Yatarola_loResized.jpg.jpg)<figcaption>A scene from *L'Allegro, il Penseroso, ed il Moderato*. Photo by Kevin Yatarola.</figcaption>
</figure>

### 3. You’ve worked with the greats of ballet, opera and classical music. What did you find there was to learn from collaborators like this? 

It is far easier to work with people who are excellent in what they do and have appropriate self-confidence and generosity. Plus, it's a lot more fun and stimulating.

### 4. Whether or not art is “relevant” is a popular topic right now. What does “relevant art” mean to you? 

Any art that's good and direct is relevant. Automatic "updating" or contemporising is not the route to relevance. Classical structure and forthrightness have endured for a long time and continue to provide the reward of artistic fulfillment. It's all about communication.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441224902173/Snow-scene_2009_Photo-by-Susana-MillmanResized.jpg.jpg)<figcaption>A scene from *The Hard Nut*. Photo by Susana Millman.</figcaption>
</figure>

### 5. You spoke about the exaggerated "schmacting” aesthetic that’s often found in opera. How do you stay expressive without being meaningless? 

Stylisation, historical tradition, honesty are all key to a convincing performance. Self expression is interesting only to yourself; expression of the text/music/story is what is really important. Not that theater is without artifice. It is the definition of artifice. Let the audience in on it. Clarity.

### 6. Is there any project that you’ve not yet done that’s still on your to-do list? 

I have lots of projects and potential projects lined up well into the future. I'm in the job that I love and still find fascinating and surprising. I'm lucky to have just what I want and continue to love.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/Ys-ACA3LGEY" frameborder="0" allowfullscreen></iframe>
<figcaption>Joyce DiDonato interviews Mark Morris on his *Orfeo ed Euridice* at the Metropolitan Opera.</figcaption>
</figure>
