+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2020-03-16T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1584407663/media/2020/03/sqHGOco-MariansSong-PhotographerLynnLane-126_ijwria.jpg"
primary_image_credit = "Zoie Reams as Marian Anderson in Marian's Song, HGO, 2020. Photo: Lynn Lane."
related_articles = []
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/zoie-reams.md"]
short_description = "Some variant of this sentence appears in many a history textbook at some point, but only rarely can it hope to make the sheer impact that Marian's Song did in Houston Grand Opera's world premiere performance. "
slug = "marians-song-a-poignant-hopefuly-message"
title = "Marian's Song: a poignant, hopeful message"
youtube_url = ""

+++
On Easter Sunday, 1939, Marian Anderson made history by performing her famous open-air concert on the steps of the Lincoln Memorial. Some variant of this sentence appears in many a history textbook at some point, but only rarely can it hope to make the sheer impact that _Marian's Song_ did in [Houston Grand Opera](/scene/companies/houston-grand-opera/)'s world premiere performance. Certainly, persons who have effected lasting change and serve as a model to others are ripe as potential operatic subjects.

As poignant as the hopeful message communicated in _Marian’s Song_ was, I perceived it as a classic case of _Prima le parole, poi la musica_. Indeed, the libretto, by Poet Laureate Emeritus of Houston Deborah D.E.E.P. Mouton, was muscular, supple, and commanding. Assertive yet malleable enough to convey its author’s adept pen, it was quite ideal as a libretto. Combined in an experimental fashion with spoken word, video projections, and music by Damien Sneed, the work had all the elements that should have resulted in an enlightening finished product. However, combined, these elements felt overcrowded as they competed to be perceptible. Indeed, one of the phrases Marian sings, "\[We\] fought for space," was ironically emblematic of the whole hour-long work.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584407746/media/2020/03/HGOco-MariansSong-PhotographerLynnLane-5_enuepb.jpg){{% /md %}}

<figcaption>Tina B and HGO Studio artist Nicholas Newton in Marian's Song, HGO, 2020. Photo: Lynn Lane.</figcaption>

</figure>

As one of the aspects which most intrigued me, poet Tina B played the role of a college student, Neveah, fighting to keep Marian Anderson's historic neighborhood church standing. As she interspersed various spoken word commentaries in a manner that reminded a classicist like me of Homer's _Catalogue of the Ships_, I got the perennial sense that she had so much to say, but far too little time to say it. While I did appreciate the sounds and rhythms, I could have wished that words' concatenated flow did not depend so heavily upon their breathless speed. (Thankfully, volume was not a concern, although her microphone was not activated until several minutes after the start.) The theatrical construct consisted of her reciting some commentary, then suddenly remember her grandmother telling her tales of Marian Anderson's singing, leading to the flashbacks which got many people to this theater in the first place. (The agitated underscore music, almost racing her to the end of whichever passage was then playing, certainly did not encourage me to perceive these passages as always being relevant or even necessary.)

Throughout these passages, there were frequent video projections of events that certainly hit close to home for some among us. Most were par for the course, but the inclusion of various events from as recently as the past decade sparked in me the realization that the gap between a biopic and an overtly political piece had been rather transparently blurred. (Again, two different modi operandi "fighting for space" without fully having time to develop.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584407789/media/2020/03/HGOco-MariansSong-PhotographerLynnLane-49_gtevqt.jpg){{% /md %}}

<figcaption>Zoie Reams as Marian Anderson in Marian's Song, HGO, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Former HGO Studio Artist [Zoie Reams](/scene/people/zoie-reams/) sang the title role with grace and conviction, with a very flush lower register and a great sense of dramatic poise. She was ideal for conveying Marian's not overly optimistic, yet constantly self-assured character. I certainly felt as empty as she did upon us encountering her first concert to a nearly vacant hall and singing an especially desolate rendition of "They Crucified My Lord." Likewise, the sense of alienation that she experienced upon being turned away from the Philadelphia Music Academy on account of her race was inescapable; I knew it was coming, but the sheer impact of such prejudice was well-approached, if more in the music than in the prosody. At any rate, Sneed's underscoring in this scene was quite adept at conveying the chorus's suppressed agitation at seeing (gasp) a non-white person daring to attempt to audition? ("The temerity!" I could imagine them saying.) Effecting that sort of broad impression without being overly psychodramatic is no mean feat on any composer's part. When it came to her renditions of Marian’' repertoire, consisting of spirituals, arias, and of course "My Country 'Tis of Thee" (look up how many countries the tune has served as national anthem for), she was highly affecting. One especially got a sense of the alienation she could feel at home when she was so greatly successful in Europe.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584407820/media/2020/03/HGOco-MariansSong-PhotographerLynnLane-79_xfqdfi.jpg){{% /md %}}

<figcaption>Zoie Reams as Marian Anderson in Marian's Song, HGO, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Current HGO Studio Artist Nicholas Newton filled the role of her friend and regular accompanist, Billy King, with a solid measure of good humor, especially in the early years. I could not escape the feeling that his character felt somewhat perfunctory, a shame given Reams’s and his clear onstage sense of camaraderie.

Geoffrey Peterson as NAACP head Walter White (and a highly sly concert promoter) was compellingly perseverant, and UH faculty member Cynthia Clayton as First Lady Eleanor Roosevelt and Jane Roberts, the faux-prudish head of the Daughters of the American Revolution, was sufficiently catty in both of these feline roles. Nevertheless, these roles could not be taken as anything other than dramatic ciphers solely for the purpose of plot advancement. Both of these characters had moments reading letters that they had dictated for the purpose, whether in person or from a sufficiently lofty distance. Regrettably, whenever Sneed encountered such passages (and I do not know if they were verbatim or stylized), I sensed he was attempting to shoehorn them into cookie-cutter rhythms at the expense of natural speech delivery. Maybe this was intended to highlight the artificial nature of such communications, but I sensed very little in terms of inner thought process or actual effort made to highlight such letters in their context or content. I could not tell if they were even the plausible products of real people. A scrivener's dictation scene from _Khovanshchina_ or a "Noi Don Magnifico" these were not.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584407845/media/2020/03/HGOco-MariansSong-PhotographerLynnLane-112_f9hd03.jpg){{% /md %}}

<figcaption>Zoie Reams and Nicholas Newton in Marian's Song, HGO, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Conductor Benjamin Manis did everything in his power to keep the 10-member ensemble vivid, but these efforts to work with the music felt like overkill. The score was most often a highly suitable, yet anodyne, accompaniment for the singers, but rarely aspired to anything greater. Utilizing a great deal of doubling of a piano base, the texture was outwardly pleasant, yet its lack of timbral versatility did not make it very easy for the listener to grab on to anything for extended periods. I sense this to have been more a product of the time constraint of this score than anything. Paradoxically, I understand from speaking with various orchestral players afterwards, that several more intricate wind passages had to be excised for rendering the texture too dense. I still do not know if I should have been disappointed upon hearing this news.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1584407875/media/2020/03/HGOco-MariansSong-PhotographerLynnLane-184_aqvp6v.jpg){{% /md %}}

<figcaption>Zoie Reams (centre) with the cast of HGO's Marian's Song, 2020. Photo: Lynn Lane.</figcaption>

</figure>

In the end, besides inviting us to question just how far our country has come in the quest for civil rights, _Marian's Song_ invited me to consider the dichotomy of: whether this was an opera summarizing the life of one of music's great heroines for us to passively admire? Or was this biographical subject merely a veneer for a sort of watered-down American agitprop that might overwhelm the work's content? I got the sense that combining these two approaches did not necessarily make the combined impact of them stronger. But the idea of combining artistic approaches was inspiring in terms of the experimental possibilities of American art, if only to determine how to make them coexist rather than compete. Something tells me we will need to hold on to this inspiration for a while.