+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2019-09-09T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1568074222/media/2019/09/sqCallas3_o1maxy.jpg"
primary_image_credit = "BASE Hologram interactive concert performance with Roy Orbison and Maria Callas at the Jazz at Lincoln Center Frederick P. Rose Hall on Sunday January 14, 2018, in New York. Photo by Evan Agostini for BASE Hologram."
related_articles = ["articles/go-see-this-carla-huhtanen-and-nicole-lizee-in-tapex-tables-turned.md", "articles/cleanedup-callas-the-remastered-live-recordings.md"]
related_companies = []
related_people = []
short_description = "Coming into this concert, I wasn’t exactly sure what to expect. Coming out of it, however, I felt a rekindled appreciation for Callas as a stage artist."
slug = "an-audible-huff-of-awe-and-amusement-maria-callas-in-concert"
title = "An audible huff of awe and amusement: Maria Callas in Concert"
youtube_url = ""

+++
It was surreal to hold a ticket with the words "Maria Callas in Concert" printed on it. But sure enough, this past Saturday evening, I was in possession of just such a ticket, eagerly waiting for "La Divina's" return to the stage of Chicago's Lyric Opera House for a one-night only performance.

Created by the company [BASE Hologram](https://basehologram.com), the Maria Callas Hologram Concert has been touring worldwide for a few years before making its Chicago debut this weekend. Conductor Eímear Noone and director Stephen Wadsworth, the creative team behind this tour, have put together an event that is as much a celebration of theatrical technology as it is of the famous soprano herself. In recent years, holograms have resurrected artists such as the late Tupac Shakur, Roy Orbison, and Whitney Houston to name a few (the latter two by BASE Hologram). Maria Callas, though, is the first classical musician to have been revived in such a way.

> Credit must be given to Noone and Wadsworth for avoiding the pitfalls of gimmickry, into which an endeavor of this sort can easily fall.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1568160265/media/2019/09/MariaCallas4000-20_erwswj.jpg){{% /md %}}

<figcaption>Maria Callas in Concert, Lyric Opera of Chicago, 2019. Photo: Won J. Park.</figcaption>

</figure>

Curious and a bit skeptical before the curtain rose, I joined the rest of the audience in an audible huff of awe and amusement when the great diva walked out from the wings to center stage. Visually, the image was quite stunning: the pace of her walk, the elegance of her gestures, the flow of her wrap were all razor sharp and smooth.

Bolstering verisimilitude were some striking sonic details such as the clack of her heels across the floor, the rustle of her gown, and the crumpling of paper in the Letter Scene from Verdi's _Macbeth_, "Vieni t'affretta...Or tutti sorgete." The audio was piped through the theater's loudspeaker system, but consisted of high-definition remasterings of Callas' recordings. The orchestras from those original recordings were edited out and in their stead we heard a live ensemble, comprised of members of the LOC orchestra, under the direction of Noone.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1568074192/media/2019/09/Callas1_s0d398.jpg){{% /md %}}

<figcaption>BASE Hologram interactive concert performance with Roy Orbison and Maria Callas at the Jazz at Lincoln Center Frederick P. Rose Hall on Sunday January 14, 2018, in New York. Photo by Evan Agostini for BASE Hologram.</figcaption>

</figure>

For the conductor, a concert like this must be akin to conducting a film score. Indeed, as a leading conductor of films and video games, Noone worked wonders as regards precision and timing, despite a couple of moments of slight misalignment, which merely exposed the artifice of the undertaking. Next to Noone's music desk was a tablet-sized screen that served as a click track for the concert, thus further dispelling the smoke and mirrors.

> Hearing Callas' expressive range, especially the softer end of her spectrum, in a large theater, gave me chills.

Callas was by many accounts, "an artist who was known by conductors for being incredibly difficult to accompany," as Noone herself notes in an insightful [interview she gave for WFMT](https://www.wfmt.com/2019/09/05/meet-the-conductor-whos-resurrecting-maria-callas-in-hologram-form/) about the hologram project.

The challenges of collaborating with Callas in this scenario notwithstanding, and despite the artificial feel to the accompaniment, there were moments of pure beauty. The first highlight of the evening for me was the aria "Ebben, ne andrò lontana" from Catalani's _La Wally_. Hearing Callas' expressive range, especially the softer end of her spectrum, in a large theater (as opposed to laptop speakers or earbuds), gave me chills. While in the Sleepwalking Scene, "Una macchia è qui tutt'ora" from Verdi's _Macbeth_, we experienced Callas' masterful control of intensity with the sparest musical means.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1568160291/media/2019/09/MariaCallas4000-24_u5aug5.jpg){{% /md %}}

<figcaption>Maria Callas in Concert, Lyric Opera of Chicago, 2019. Photo: Won J. Park.</figcaption>

</figure>

Credit must be given to Noone and Wadsworth for avoiding the pitfalls of gimmickry, into which an endeavor of this sort can easily fall. The musical selections were beautifully balanced between popular favorites like "Je veux vivre" from Gounod's _Roméo et Juliette_ and the Habanera from _Carmen_ and more deep-cutting numbers such as those already mentioned from Verdi's _Macbeth_ as well as from Thomas' _Hamlet_, and Ponchielli's _La Gioconda_. This program showcased Callas' range as a vocal-dramatic artist and all the qualities for which she was admired and emulated, from heartbreaking vulnerability to imposing strength.

> I felt a rekindled appreciation for Callas as a stage artist.

At the end of the program, "La Divina" did not disappoint the audience in her two encores, "Vissi d'arte" from Puccini's _Tosca_ and "Casta Diva" from Bellini's _Norma_ - arguably the two most iconic Callas staples. In what was otherwise a technologically flawless concert, during the final encore a technical glitch made both the hologram and audio first freeze and then quickly fadeout, thus bringing the evening to perhaps a quicker end than intended. Though amusing at first, it was also poetically appropriate for the abruptness of the hologram's fadeout unwittingly reflected the real Callas' own all-too-abrupt departure not just from the stage, but from the world back in 1977 at the age of 53.

</figure>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1568074209/media/2019/09/Callas2_si7zhj.jpg){{% /md %}}

<figcaption>BASE Hologram interactive concert performance with Roy Orbison and Maria Callas at the Jazz at Lincoln Center Frederick P. Rose Hall on Sunday January 14, 2018, in New York. Photo by Evan Agostini for BASE Hologram.</figcaption>

</figure>

Coming into this concert, I wasn't exactly sure what to expect. Coming out of it, however, I felt a rekindled appreciation for Callas as a stage artist. It is one thing to watch her videos on YouTube and another to experience her on a grand stage, even if only as a digital projection. Whatever the arguments may be about Callas as a vocalist, it's clearer to me why she was and continues to be so beloved by audiences across the globe and across generations.