+++
author = ["authors/andrea-lett.md"]
categories = "Review"
date = 2022-09-09T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1662642469/media/2022/09/sqMUO_MF7_ikzqhx.jpg"
primary_image_credit = "Matt Pauls as Bartolo in Manitoba Underground Opera's production of The Marriage of Figaro, 2022. Photo: Paul McKeen."
related_articles = []
related_companies = []
related_people = []
short_description = "As a singer transitioning out of a performing role and into the role of an audience member, board member, and now reviewer, it is surreal to watch this company grow as a spectator on the outside."
slug = "a-queer-friendly-figaro-out-of-manitoba-underground-opera"
title = "A queer-friendly Figaro out of Manitoba Underground Opera"
youtube_url = ""

+++
[Manitoba Underground Opera](/scene/companies/manitoba-underground-opera/)'s new season aimed to provide an immersive theatrical experience that facilitated contemporary social commentary. The season, entitled "For Better or For Worse", featured the operas _Orphée and Eurydice_ and _The Marriage of Figaro_.	While I was unable to see _Orphée and Eurydice_, the production of _The Marriage of Figaro_ easily accomplished these goals, and then some.

Community presence seemed to be large contributing factor when it came to MUO's success in ticket sales. Winnipeg summers are short and jam-packed with various shows, festivals, and activities. So, while folks in 2022 _are_ ready to experience art in person again, the sheer amount of live theatre in the city can make it difficult to draw a substantial crowd. However, MUO had won over Winnipeg's attendance, and their website indicated sold out shows.

As a singer transitioning out of a performing role and into the role of an audience member, board member, and now reviewer, it is surreal to watch this company grow as a spectator on the outside. Looking at the program, I did not know as many names as I have in the past, and it was an exciting prospect to be able to hear some of the voices in the next crop of Canadian singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1662642723/media/2022/09/MUO_MF1_kmdc1j.jpg){{% /md %}}

<figcaption>Heather Molloy (Figaro) and Chelsea Kutyn (Susanna) in Manitoba Underground Opera's production of The Marriage of Figaro, 2022. Photo: Paul McKeen.</figcaption>  
</figure>

Club 200 is a local, queer-friendly space that prides itself in being one of Canada's longest running gay bars. During the show, audience members sat at tables around the club, and food and drinks were served. The atmosphere was relaxed, inclusive, and accessible. The choice of venue held a certain degree of interest, as it was evident from listening to the various conversations at nearby tables that there were a great deal of "firsts"—many of them a direct result of being in an unapologetic 2SLGBTQIA+ space. Some audience members were experiencing gender-neutral washrooms for the first time, and others were asking questions about pronouns that they likely would not have asked otherwise. Paired with the audience members who had never been to an opera before, the air felt full of curiosity.

Adam Da Ros' setting and interpretation fit effortlessly with the intention of the show and its exceptional English translation. The show itself was set in a bar, with the Count as the owner, and Figaro, Susanna, and Cherubino as employees. This resonated particularly well, given that in some capacity, many folks working in the service industry have—at some point—dealt with sexual harassment in the workplace. Certain phrases like: "after all, I own the place" from the Count, or: "I do this for a living…" from Susanna are, unfortunately, attitudes that are not uncommon in the service industry even today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1662642782/media/2022/09/MUO_MF3_ici7pj.jpg){{% /md %}}

<figcaption>(l-r) Kyle Briscoe (Basilio) Matthew Pauls (Bartolo), Heather Molloy (Figaro) Chelsea Kutyn (Susanna) Rosemarie van der Hooft (Marcellina) in Manitoba Underground Opera's production of The Marriage of Figaro, 2022. Photo: Paul McKeen.</figcaption>  
</figure>

Da Ros' use of the space delightfully included the audience as the performers mingled with tables and interacted with patrons around the club. The direction and choices were clear and inclusive in all senses, with mindfulness to the hosts and staff at Club 200, while still bringing the audience into the story for an immersive experience.

A small ensemble consisting of violin, bassoon, and piano, led by conductor Diane Speirs filled the intimate space and provided support for the singers. Speirs was attentive to the singers and kept the music smooth and effortless. The choice to cast Figaro as mezzo-soprano Heather Molloy paid off in spades. Molloy was engaging, genuine, and expressive. She was a joy to watch, and the stage chemistry between Molloy and soprano Chelsea Kutyn was heartwarming and unapologetic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1662642858/media/2022/09/MUO_MF4_dbmjka.jpg){{% /md %}}

<figcaption>Henry Chen (Count) in Manitoba Underground Opera's production of The Marriage of Figaro, 2022. Photo: Paul McKeen.</figcaption>  
</figure>

As Susanna, [Chelsea Kutyn](/scene/people/chelsea-kutyn/)'s voice sparkled with warmth and sincerity. Kutyn was quick, clever, and heartfelt—a magnetic artist to watch. Henry Chen’s full, striking voice matched his commanding stage presence. An excellent actor, Chen's portrayal of the Count was a huge highlight, and I am excited to see where his journey takes him. During [Karen Santos](/scene/people/karen-santos/)' aria, "Porgi, amor", the entire club was silent and fixated on her heartbreaking honesty. To hear this soprano's rich, velvety voice was truly a highlight. Santos balanced the strength of the Countess with the vulnerability of a woman who was grieving the loss of love.

Cherubino (played by Hailey Witt) was a non-binary character, emphasized with clear and deliberate they/them/their pronouns throughout the show. The English translation of "Voi, che sapete" was exceptionally well-crafted, and beautifully depicted the young teenager exploring their identity. Witt displayed thought, understanding, and sensitivity in the portrayal of Cherubino, and exhibited a natural versatility in both acting and singing. Kyle Briscoe was possibly one of the most charming Don Basilios I've seen, and balanced elegance and sass as he fueled the drama with gossip and scandal. Rosmarie van der Hooft as Marcellina and Matt Pauls as Bartolo charismatically stole the audience's hearts and gaze with their fabulous costumes, flare, and vocal blend. Special mention should be made of [Jolean Groundbeef](https://www.instagram.com/joleangroundbeef/?hl=en), who consulted on Pauls' stunning drag outfit.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1662642924/media/2022/09/MUO_MF5_m28gyr.jpg){{% /md %}}

<figcaption>Chelsea Kutyn (Susanna), Hailey Witt (Cherubino), and Henry Chen (Count) in Manitoba Underground Opera's production of The Marriage of Figaro, 2022. Photo: Paul McKeen.</figcaption>  
</figure>

Looking back on the night, everything seemed to be in its right place in MUO's _Marriage of Figaro_. The sense of community, learning, and joy could not be ignored in the room. When looking at the future of opera, this small company seems to have figured out a thing or two, and their work would make any Winnipegger proud to be part of the arts community.