+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = "2024-10-09T00:00:00-00:00"
lastmod = "2024-10-09T00:00:00-00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1728508271/sqMUO_Tales_of_Hoffman-8.jpg"
primary_image_credit = "Stephen Haiko-Pena (Four Villains) in Manitoba Underground Opera's production of The Tales of Hoffmann, 2024. Photo: Paul McKeen."
publishDate = "2024-10-09T00:00:00-00:00"
related_articles = ["articles/manitoba-underground-opera-s-marriage-of-figaro.md"]
related_companies = ["scene/companies/manitoba-underground-opera.md"]
related_people = [""]
short_description = "There's something elemental about the raw power of the human voice that can move the soul. When a singer is right behind you or a few feet in front of you, there's something magical that happens that can be hard to put into words. I felt like I was part of the show, part of the story, even in the show."
slug = "immersive-and-imaginative-manitoba-underground-operas-tales-of-hoffmann"
title = "Immersive and imaginative: Manitoba Underground Opera's Tales of Hoffmann"
+++
[Manitoba Underground Opera](/scene/companies/manitoba-underground-opera/)'s recent production of Offenbach's _Tales of Hoffmann_ was a delight in so many ways. Major companies all over Canada owe a debt of gratitude to MUO and other companies of their ilk, for the imaginative, ingenious and high-quality performances they put on stages all over Manitoba, for all kinds of different audiences.

I loved enjoying the many results of the refreshingly diverse cast utilized by Executive Director Brendan McKeen and his team. I felt like every voice perfectly suited the character(s) they were portraying, whether they were a young singer just finished their training, a voice ready for the mainstage, or an older performer. The unique advantages of body-positive casting was also apparent, as the show seemed all the more real because the diversity of body types was a more authentic representation of what you see in society, instead of a misguided "thin-is-in" ideal. Studies have shown (including from august Cornell University) that body-positive ideals help everyone, including increased body appreciation and self-compassion for all.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1728508257/MUO_Tales_of_Hoffman-7.jpg)
<figcaption>The full cast of Manitoba Underground Opera's production of The Tales of Hoffmann, 2024. Photo: Paul McKeen.</figcaption>
</figure>

I am also very on board with MUO's "Let's rewrite the story" motto, which includes translations into English and the updating of storylines, characters and lyrics. The fact that some of the lyrics were appropriately laced with F-bombs and other modes of contemporary speech (alongside what was obviously the more florid English translation from the original French) helped the opera transport itself through time to be meaningful in our present day. Kudos to the team that did all the translating! McKeen was an engaging and funny host, immediately putting everyone at ease by offering the "rules of engagement". This set the tone for the evening, with some performers doing catcalls and observations from the audience, with the audience joining in as well.

As an opera composer and conductor, I've been fortunate over my career to be close to some amazing voices. For most people, however, being mere feet away from a superbly trained voice (to say nothing of the affectingly simple but effective costumes) is a new experience. There's something elemental about the raw power of the human voice that can move the soul. When a singer is right behind you or a few feet in front of you, there's something magical that happens that can be hard to put into words. I felt like I was part of the show, part of the story, even _in_ the show. Characters were walking around us, having conversations with other characters on the other side of the bar. Some characters were lounging around the bar, biding their time and watching the spectacle until it was their turn to chime in -- in an interesting paradox, these characters initially seemed to be a part of the audience. The whole blending of audience and performer was quite intoxicating and thrilling for me, and I'm sure for others as well.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1728508271/MUO_Tales_of_Hoffman-13.jpg)
<figcaption>Alice Macgregor as Olympia in Manitoba Underground Opera's production of The Tales of Hoffmann, 2024. Photo: Paul McKeen.</figcaption>
</figure>

Back in the day (Mozart's day), the opera was a place to go, bring a picnic and a bottle of wine, and watch a performance while munching and swigging – it was the rule, not the exception. And, if the production or the singers were not up to snuff, they might have a breadcrumb (or worse, a bottle) thrown at them. While I think these last actions are maybe not to be recommended for a contemporary opera crowd, the chance for a "dinner and a show" opera experience is not to be discounted. With a 7pm curtain on weekdays, there's not enough time for most people to get dinner after work (myself included) so having dinner and a few drinks while watching this show felt like a perfectly natural thing to do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1728508261/MUO_Tales_of_Hoffman-10.jpg)
<figcaption>Christopher Dunn (Hermann and Schlémil) and Janice Marple (Giulietta) in Manitoba Underground Opera's production of The Tales of Hoffmann, 2024. Photo: Paul McKeen.</figcaption>
</figure>

MUO has been leading the way when it comes to engagement with the 2SLGBTQIA+ community. It is true that the arts in general, and opera in particular, has always been welcoming to this community, but the engagement shown is truly exemplary. Opera has always had a gender-bending side to it, with [women playing men in pants roles](/breeches-trousers-and-pants/), so in a way, MUO is just taking that a step further to increase the art form's relevance today with having characters in drag or androgynous. MUO is also very dedicated to a young audiences, with their extended tours of underserved and remote Manitoba communities, building audiences for opera one child at a time. Also let me say that Winnipeg always seems to have so many fine young singers, and the amount of experiences available to them are limited. But to get the chance to sink your teeth into a real opera like _Tales of Hoffmann_ is such a great opportunity for the emerging artist, be they an on-stage performer or part of the production team. Another element I really liked was the large number of performances, which allows the show to grow and mature, at the same time building the audience as word of mouth spreads – the show I was at was sold out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1728508259/MUO_Tales_of_Hoffman-6.jpg)
<figcaption>The cast of Manitoba Underground Opera's production of The Tales of Hoffmann, 2024. Photo: Paul McKeen.</figcaption>
</figure>

I have decided to go with a more general review here, as the large cast (10 principal performers portraying over 20 characters) precludes me from going into detail about specific performances. It needs to be said that all the performers were standouts in my view, as every single performance was engaging, very well sung, and with lots of dramatic flair. Three brief shout-outs: Chorus Master Shannon Hiebert, who would be gratified to know that the ensemble was amazingly tight all night; Music Director Megan Dufrat, who held everything together with her tremendous playing and listening, bringing the orchestra to life through her keen pianistic skills; and Stage Director Matthew Paris-Irvine, who demonstrated superb artistry in using every square inch of the venue to achieve a truly stunning visual effect. MUO also has some pretty stellar alumni who have gone on to achieve great things in the world of opera, including Brenna Corner, currently enjoying a huge international career as a stage director and who was recently appointed Artistic Director of [Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/). Manitoba Underground Opera is in good company with their take on opera, which includes companies like [Tapestry Opera](/scene/companies/tapestry-opera/) and [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), both based in Toronto. All three companies are blazing trails for legacy opera as well as for new works, and it's so great to see the creativity and imagination being brought to bear on old and new works alike. 

I'm very excited to see what MUO has planned for next season, and I look forward to seeing as many shows as I can!