+++
author = ["authors/neil-weisensel.md"]
categories = "Review"
date = "2017-11-20T21:17:00-05:00"
lastmod = "2017-11-21T13:25:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511230713459/2017-11-21---square---MB-Opera%2C-Madama-Butterfly%2C-2017-Hiromi-Omura-Cio-Cio-San-and-David-Pomeroy-Pinkerton.-Photo---R.-Tinker.jpg.jpg"
primary_image_credit = "Hiromi Omura (Cio-Cio Sam) and David Pomeroy (Pinkerton) in Madama Butterfly, Manitoba Opera, 2017. Photo: R. Tinker."
publishDate = "2017-11-21T13:25:00-05:00"
related_articles = ["articles/rohs-madama-butterfly-better-to-be-furious-than-bored.md","articles/in-review-madam-butterfly-at-eno.md"]
related_companies = ["scene/companies/manitoba-opera.md"]
related_people = ["scene/people/david-pomeroy.md","scene/people/gregory-dahl.md","scene/people/laurelle-jade-froese.md","scene/people/hiromi-omura.md","scene/people/nina-yoshida-nelsen.md"]
short_description = "This fabulous production that Manitoba Opera has mounted at the Centennial Concert Hall in Winnipeg, with an absolutely stellar cast, has made me remember why Madama Butterfly is one of the most popular operas of all time."
slug = "making-the-connection-madama-butterfly-in-manitoba"
title = "Making the connection: Madama Butterfly in Manitoba"
+++

I had forgotten what a great opera Puccini's *Madama Butterfly* is. My introduction to the piece, at the University of Manitoba's School of Music many years ago, was an unfortunate encounter between Puccini's beautiful melodies and a flighty soprano who was years away (if ever) from being able to sing the role.

This [fabulous production that Manitoba Opera](http://www.manitobaopera.mb.ca/operas/madama-butterfly.html) has mounted at the Centennial Concert Hall in Winnipeg, with an absolutely stellar cast, has made me remember why *Madama Butterfly* is one of the most popular operas of all time.

I have a confession of sorts to make: over the last few years I've decided to not read opera synopses when I go to opera performances. I want to imagine the story anew, without the huge "spoiler alerts" present in all opera synopses. So, in that vein, I'm going to restrict my comments to the music and the singers in the Manitoba Opera production I attended last night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511230788664/2017-11-21---MB-Opera-Madama-Butterfly%2C-2017.-Photo---R.-Tinker.jpg.jpg)
<figcaption>*Madama Butterfly*, Manitoba Opera, 2017. Photo: R. Tinker.</figcaption>
</figure>

All I will say about the plot is that it remains eerily prescient, 113 years after its premiere at La Scala in Milan. Set in 1904, an American naval officer stationed in Japan has agreed to rent a house, an arrangement that includes two servants and a marriage to a 15-year-old girl through a marriage broker. Recent events in the USA regarding underage girls and a certain political candidate flew through my mind as Butterfly's age is revealed onstage, and added to the more chilling aspects of the drama for me. As well, the not-so-subtle examples of American triumphalism and nationalism inherent in Pinkerton's character were also a stark reminder of the problems the current resident of the White House is inflicting on the world.

Puccini's score is a lush interweaving of full-blooded romanticism, early 20th-century "Orientalism" (think black keys on the piano – more on that unfortunate term later) that was so popular in music at the time, and musically shape-shifting harmonies called augmented chords. These chords are usually presented amid swirling orchestral harmonies that give us a sense of uncertainty, and also serve as harmonic portals to remote key areas, a device Puccini uses particularly well. The way the composer stops on a stylistic dime, to pivot into a completely new idea where warranted by the libretto, is fascinating. The multi-layer musical universe he creates is attractive to both the opera newbie and the hard-core fan, which is probably one of the main reasons for Puccini's enduring success. Personally, when I was recently orchestrating my first opera *Gisela in her Bathtub* (1991) the orchestration "bible" I always had nearby was Puccini's *La Bohème*, so I definitely count this composer among my heroes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511230900700/2017-11-21---MB-Opera%2C-Madama-Butterfly%2C-Hiromi-Omura-Cio-Cio-San.-Photo---R.-Tinker.jpg.jpg)
<figcaption>Hiromi Omura as Cio-Cio San in *Madama Butterfly*, Manitoba Opera, 2017. Photo: R. Tinker.</figcaption>
</figure>

I'm always amazed how maestro Tyrone Paterson and the Winnipeg Symphony Orchestra pull together such an impassioned and detailed reading of this lush and complex score with such limited rehearsal time. The orchestra sounded tight and majestic, and the balance between the orchestra and singers was perfect from where I was seated.

We are very fortunate that, despite the fact we live in a smaller centre, Manitoba Opera always gives us the top shelf of internationally renowned opera singers. Naval officer B.F. Pinkerton was brought to life by tenor [David Pomeroy](/scene/people/david-pomeroy/), a Newfoundland native who has been enjoying considerable success in big roles on both sides of the Atlantic. The first note I ever heard him sing, in MOA's stellar production of Beethoven's *Fidelio*, was so beautiful it left my heart in tatters. Here, his depiction of the child-marrying cad was beautifully shaped, both dramatically and especially vocally. Pomeroy is one of the top tenors around, a true singing actor like all the performers onstage tonight, possessing a voice of exquisite beauty and power. Some of my most memorable moments were when he and Sharpless, the American Consul in Japan, sang together. As Sharpless, baritone [Greg Dahl](/scene/people/gregory-dahl/) (a local Winipeg boy!) inhabited his character as a wise, prophetic man sent, ultimately, to do Pinkerton's spade work for him. Dahl is able to effectively convey a wide range of emotions, and his voice is also smooth, powerful, and to me, the epitome of what the perfect manly baritone should sound like. I would love to hear him singing some of my music…

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511231077434/2017-11-21---MB-Opera-Madama-Butterfly-2017%2C-Laurelle-Froese-Kate-Pinkerton%2C-Nina-Yoshida-Nelsen-Suzuki%2C-Gregory-Dahl-Sharpless.-Photo---R.-Tinker.jpg.jpg)
<figcaption>Laurelle Froese (Kate Pinkerton), Nina Yoshida (Suzuki), and Gregory Dahl (Sharpless) in *Madama Butterfly*, Manitoba Opera, 2017. Photo: R. Tinker.</figcaption>
</figure>

Madama Butterfly, also known as Cio-Cio-San, was portrayed with great emotion and depth by Japanese soprano [Hiromi Omura](/scene/people/hiromi-omura/). Her entrance really moved me, when she was climbing the hill with her geisha girlfriends to get to Pinkerton's rented house on the shores of Lake Nagasaki. For this scene, Puccini lays down beautiful pillowy-soft sequences of those ambiguous augmented chords in the orchestra. Butterfly's entrance has to contain some of the best "entrance music" in all of opera. It was stunning how Omura's rich, lush voice was heard above an entire chorus of women singing, even though the action up to this point was happening behind a screen. 

As Goro the sketchy marriage broker, tenor James McLennan brought his usual dramatic flair and expert vocalizing to the Concert Hall stage. McLennan, who sang the title role in my 2017 opera *Merry Christmas Stephen Leacock*, is always a pleasure to watch onstage because he fully inhabits his character. He is so light on his feet, always sings beautifully, and has great stage presence. We are fortunate that he calls Winnipeg home.

Butterfly's maid Suzuki was characterized with heart-rending tenderness and grief by the excellent mezzo [Nina Yoshida-Nelsen](/scene/people/nina-yoshida-nelsen/). As Butterfly's friend and confidant, she bore the brunt of Sharpless' bad news with electrifying ardour. People all around me were crying and sniffling at this point in the opera, as Yoshida-Nelsen seemed to embody the impending disaster to Butterfly implied by Sharpless' pronouncement.

I'm always happy to see Mel Braun onstage with Manitoba Opera, in this instance playing the dual roes of the Imperial Commissioner and later, Prince Yamadori. Braun's voice is such a fine instrument, and he brings these characters to life vividly. (I was lucky enough to have Mel premiere the character of Al the City Foreman in my 1992 opera *City Workers in Love*, a collaboration with well-known opera director Michael Cavanagh.) David Watson as Bonze, Butterfly's outraged priestly uncle, brought the requisite scorn and anger to his character.

As opera producers, Manitoba Opera understands the impact that community engagement engenders, and this production continued that important trend. Sometimes it's a challenge to mount operas that seem disconnected from the reality of our 21st-century lives. But, like all great art, opera has a way of connecting us and reflecting us back at ourselves. The importance of the arts in communities, and building bridges between artistic organizations and the communities they serve is an area of great growth. To this end, MOA organized a diverse range of engaging outreach events. A panel discussion on "Cultural Appropriation & The Arts" was held at the Canadian Museum for Human Rights, the Baby and Mom Supplies Drive aided single moms in the community, and the Japanese Cultural Association of Manitoba (JCAM) presented displays and activities, including origami-making and some amazing kimonos, at the venue. Other events included "Understanding the music of *Madama Butterfly*", "Cultural Differences and Couples Relationships", opera primers, a trivia night at a local brewery, and "An Evening of Sushi and Sake."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511231299971/2017-11-21---MB-Opera%2C-Madama-Butterfly%2C-2017.-Photo---R.-Tinker.jpg.jpg)
<figcaption>*Madama Butterfly*, Manitoba Opera, 2017. Photo: R. Tinker.</figcaption>
</figure>
 
Producing opera is a risky and expensive undertaking. I have nothing but praise for companies like Manitoba Opera who are doing the important work of connecting to their community, and bringing the highest-quality art to this community. I talked to a lot of people after the show, and many mentioned that this production of *Madama Butterfly* was superior in many ways to what they had seen in larger cities. Whether you are an opera newbie or a long-time opera fan, this production is highly recommended.

>Manitoba Opera's [*Madama Butterfly*](http://www.manitobaopera.mb.ca/operas/madama-butterfly.html) is onstage through November 24. For details and ticket information, follow our box office links below.
