+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-03T09:17:00+01:00"
lastmod = "2016-08-04T13:06:00+01:00"
preamble = "Next week, the Glyndebourne Festival opens its 8-show run of Peter Hall's 1981 production of Britten's [*A Midsummer Night's Dream*](http://www.glyndebourne.com/tickets-and-whats-on/events/2016/f16dream/), revived for the first time in 10 years. We have plenty of love for Britten's operas, and we can't wait for our trip to Lewes to catch *Dream*, one of our favourites.\n\nSo, it was a pleasure to chat with two members of the cast: mezzo-soprano [Elizabeth DeShong](/scene/people/elizabeth-deshong/), singing the role of Hermia, and bass [Matthew Rose](/scene/people/matthew-rose/), who will don the infamous donkey costume as Bottom. The two singers offer up insight on the \"magic\" of Hall's *Dream*, the trick to singing beautifully in English, and their definitions of off-stage fun in the countryside."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470212913351/2016-08-03---Midsummer.jpg.jpg"
primary_image_credit = "Matthew Rose as Bottom in A Midsummer Night's Dream, 2006. Photo: Mike Hoban © Glyndebourne Productions Ltd."
publishDate = "2016-08-04T12:59:00+01:00"
related_articles = ["articles/talking-with-singers-elizabeth-deshong.md","articles/in-review-hamlet-at-glyndebourne.md"]
related_companies = ["scene/companies/glyndebourne.md"]
related_people = ["scene/people/elizabeth-deshong.md","scene/people/matthew-rose.md"]
short_description = "&quot;Peter Hall&#039;s Midsummer is the first &#039;traditional&#039; production of this opera that I have been a part of. It is specific without being rigid, magical without being obvious, and true to the story and setting. It is important to not shy away from the harshness within Midsummer, and to acknowledge the individual journeys of each of the characters, joyful and pitiful, alike.&quot;"
slug = "magic-high-standards-midsummer-at-glyndebourne"
title = "Magic &amp; high standards: Midsummer at Glyndebourne"
+++

## What does it mean to you to be performing in *A Midsummer Night's Dream* in the 400th anniversary of Shakespeare's death?
 
**Elizabeth DeShong**: It is a special honour to perform Britten at Glyndebourne, and combining that with the unique occasion of marking the 400th anniversary of Shakespeare’s death, adds all the more depth to the experience. This is my sixth run as Hermia, and I can't imagine a better place to bring that collective experience full circle, than in the country of Shakespeare's birth.

**Matthew Rose**: Obviously Shakespeare is one of the great artistic treasures of planet earth. To get to perform in a piece by him, even in the form of an opera, is a great, great honour. I love every second of playing this amazing character that he created; with one of the funniest and most pertinent names in all of theatre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470309348121/2016-08-04---MND_rehearsal-2---pc---Richard-Hubert-Smith.jpg.jpg)
<figcaption>The cast of *A Midsummer Night's Dream* in rehearsal. Photo by Richard Hubert Smith, Glyndebourne Productions Ltd., 2016.</figcaption>
</figure>

## How have you found your roles evolving as you return to Glyndebourne with various productions?

**Rose**: It has been a very strange thing to come back to. The offer of *Dream* at Glyndebourne for the 2006 production was my first real job after the Young Artists Programme (Royal Opera House) and obviously a huge deal for me at the time. I grew up not far from Glyndebourne and the whole thing was magical, being given, with much unmerited trust, the perfect role for me and the whole thing was beyond anything I could ever have dreamed of doing. 

Now I am ten years further on in my professional life and I have done nine other productions of *A Midsummer Night's Dream* around the world (including ROH, la Scala and the MET) and six productions (operas) at Glyndebourne so I am in a completely different place in my career and in the way I think about opera, this role and life, and all the thoughts and feelings of then are very much part of my experience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470309368210/2016-08-04---MND_rehearsal-1---pc---Richard-Hubert-Smith.jpg.jpg)
<figcaption>Matthew Rose as Bottom, rehearsing *A Midsummer Night's Dream*. Photo by Richard Hubert Smith, Glyndebourne Productions Ltd., 2016.</figcaption>
</figure>

**DeShong**: There seems to be a real commitment to hiring the very best people for their specific roles at Glyndebourne. That sounds obvious, however, you will find artists that have previously sung title characters (such as myself, having sung here in 2012, as Angelina in *La Cenerentola*), returning to do smaller roles for which they are uniquely well-suited. This results in shows that are solid from top to bottom, all roles being filled with highly qualified and experienced singers. Having sung (in order) Hänsel, Kitchen girl (*Rusalka*), Angelina (*La Cenerentola*), and now, Hermia in *A Midsummer Night's Dream*, I can say that it is an honour to work in an environment so dedicated to quality on every level.

**Rose**: I have to say, it has been such a joy and I appreciate the greatness of this production way more now, and even after many performances of the role, the MAGIC and BRILLIANCE of the opera are something I appreciate and adore more and more. Is lovely that Kate Royal is here too from 2006 production, she is a special artist and wonderful person, and we are so lucky to be back. Nothing is guaranteed in this life/career, so to get a second chance at something this wonderful is a real blessing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470212837690/2016-08-03---DeShong.jpg.jpg)
<figcaption>Elizabeth DeShong, mezzo-soprano. Photo by Dario Acosta.</figcaption>
</figure>

## What can you tell us about Peter Hall’s production this summer?

**Rose**: Again, I appreciate the design of this show even more now. The set is very simple and clean, and yet through its use of real human trees and bushes, mirrored and polished surfaces and brilliant lighting design, creates the perfect world for this play and for Britten's amazing score. The staging is simple, but completely honest and very much fun to be part of. It is not a surprise that such a production has lasted so long. 

**DeShong**: Peter Hall's *Midsummer* is the first 'traditional' production of this opera that I have been a part of. It is specific without being rigid, magical without being obvious, and true to the story and setting. It is important to not shy away from the harshness within *Midsummer*, and to acknowledge the individual journeys of each of the characters, joyful and pitiful, alike. Peter Hall achieves this balance expertly. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470309397403/2016-08-04---MND_rehearsal-3---pc---Richard-Hubert-Smith.jpg.jpg)
<figcaption>The cast of *A Midsummer Night's Dream* in rehearsal. Photo by Richard Hubert Smith, Glyndebourne Productions Ltd., 2016.</figcaption>
</figure>

## What unique challenges do you find when singing opera in English?

**Rose**: Maybe English isn't ideally suited for "operatic" treatment, and yet it is something I always relish. Britten's word setting is so good that it kind of looks after itself and you can sing long legato lines and get all the words across. I have done much Britten and much singing in English and I have, over time, worked out the best way to get the text across (I hope). I don’t believe in rolling or flipping r's too much, so you won’t hear me doing that and it is something I stress when teaching young singers that not rolling or flipping r's makes the English language much more natural, and even easier for audiences to digest.

**DeShong**: I think that when singers are performing in their native language, there is often a tendency toward laziness. It becomes all the more important to heighten the text beyond what seems natural. The text has to stay constantly in the forefront of my mind, because comfort can take its toll on clarity.

**Rose**: We have the extra luxury of Dame Felicity Palmer as out Head Coach on this production and she doesn't let one single wrong or unheard consonant escape. The care she and conductor Jakub Hruša are taking with the text is really wonderful and I think the audiences will benefit greatly for this and hopefully not have to read the supertitles too much, which is a win for us all. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470212862741/2016-08-03---ROSE-Matthew-Lena-Kern.jpg.jpg)
<figcaption>Matthew Rose, bass. Photo by Lena Kern.</figcaption>
</figure>

## During your free time at Glyndebourne, what do you do for fun?
 
**DeShong**: I'm fortunate to have many long-time friends working here at Glyndebourne this summer! Kathleen Kim, our Tytania, and I have been friends for over a decade, and have taken to Sunday brunches at Bill's and hikes in the beautiful countryside. Another colleague and I have started a little supper club, where we (mostly he) prepare a different type of cuisine each week, and also, occasionally do tastings of local scotch. Aside from that, I'm in the practice room preparing for my next engagement. I promise, that also qualifies as fun!

**Rose**: I now live in London (I was a Sussex resident for a long time) so I have been commuting up and down to Lewes for the rehearsals. With the wonderful Southern Railway problems means most of the day is taken up and I have a very busy life in London, teaching, and have fingers in many projects, so I don’t have so much free time as I once did. 

But the one piece of kit that I always have in my work bag is a Frisbee and I am very good a coercing fellow cast members, orchestral musicians, children, Glyndebourne staff, the owner's dogs, etc., to play Frisbee on the lawn in front of the house. I am pretty convinced that was the original design concept for the lawn, and take advantage of it in every break we have away from the rehearsal room or during stage rehearsals. We have also had a few swims in the lake on hot days. It isn’t all hard work and when it's raining, table tennis, although sadly the children fairies have found the room, so getting in there for a game is not as easy or as quiet as it once was. 

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/OZ9NAagdJko" frameborder="0" allowfullscreen></iframe>
</figure>

>A Midsummer Night's Dream runs at the Glyndebourne Festival August 11-28. Seats are going quickly! For details and ticket information, follow our box office links below.
