+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-10-17T13:27:00-04:00"
lastmod = "2017-10-18T10:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508260971133/2017-10-16---square---Arabella-MC-0629.jpg.jpg"
primary_image_credit = "Erin Wall as Arabella and Tomasz Konieczny as Mandryka in the Canadian Opera Company’s new production of Arabella, 2017, photo: Michael Cooper."
publishDate = "2017-10-18T10:38:00-04:00"
related_articles = ["articles/tim-albery-flawed-operas-falling-empires.md","articles/review-arabella-or-poor-little-rich-girl.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-santa-fe-opera.md"]
related_people = ["scene/people/erin-wall.md","scene/people/jane-archibald.md","scene/people/tomasz-konieczny.md","scene/people/michael-brandenburg.md","scene/people/john-fanning.md","scene/people/gundula-hintz.md","scene/people/claire-de-sevigne.md","scene/people/patrick-lange.md"]
short_description = "A woman with a spine is somewhat of a rare find in opera, and so it&#039;s hard to admit that Arabella is a woman who warrants very little empathy - even from this female reviewer. Arabella&#039;s insistence on waiting for the &quot;right man&quot; among her train of suitors is something that&#039;s admirable and surprisingly contemporary even for this 1932 opera. "
slug = "luxury-at-arms-length-arabella"
title = "Luxury at arm&#039;s length: Arabella"
+++

When it offers nothing but good news - stunning music that seems to make a few early nods to the motifs of *Der Rosenkavalier*, and the central woman who holds herself with poise and self-respect - it's hard to articulate why Strauss' [*Arabella*](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx) had me perched squarely on the fence. It's a strange experience to spend three acts wavering between feeling swept away by stunning singing and lush worlds that seem to ooze romance, and feeling entirely suspicious and even exasperated by the battles picked by Arabella and her in-dire-straits-of-their-own-doing family.

Arabella's parents are well-meaning but frustratingly naïve. Her father strikes a happy balance between being oblivious to his gambling addiction, and having little shame about digging his family out of financial stresses. Her mother, who at one time held that strange sort of reverence for metropolitan life in Vienna, now seems to blame the city for not unfurling for her a life of good fortune.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508261027643/2017-10-16---Arabella-MC-0115.jpg.jpg)
<figcaption>(l-r) Erin Wall as Arabella and Jane Archibald as Zdenka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

The good news: their children are savvy and surprisingly well-adjusted. Zdenka, the youngest daughter, arguably takes on the brunt of the family sacrifice by living her public life as a young man; and when we meet Arabella, she is in the midst of a high-pressure social life, calmly juggling the handful of suitors and admirers vying for her hand in marriage.

In the title role, [Erin Wall](/scene/people/erin-wall/) introduces us to an Arabella with some sass, well aware that for her suitors, she's a prize worth competing for. Wall seems to fit the role like a glove, both in voice and proud posture; it's not hard to see why Arabella is a hot commodity. COC Resident Artist [Jane Archibald](/scene/people/jane-archibald/) is a strong match as Zdenka, her warm sound filling the space of Strauss' writing and passing well as a strange sort of sometimes-trouser-role. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508261050113/2017-10-16---Arabella-MC-0680.jpg.jpg)
<figcaption>Michael Brandenburg as Matteo and Jane Archibald as Zdenka in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

The lives of the two women are well mirrored in Tim Albery's production, which offers glimpses of luxury - stark and isolated as they may be - while keeping true comfort at arm's reach. [In his review](/review-arabella-or-poor-little-rich-girl/), Greg Finney pointed out that the plot of *Arabella* is pulled straight from the shelves of operetta; the score - and perhaps in response, the cast - maintains a *gravitas* to the story and pulls it away from real exaggeration or hilariously exasperating scenes of miscommunication. 

Maybe that's why it was difficult to connect with these characters. Arabella's suitors come along with clear personalities, yet only Elemer - hollered beautifully by [Corey Bix](/scene/people/corey-bix/) - demonstrates a worst-case scenario for her arranged marriage; Elemer is too loud and he speaks at her instead of to her, but he shows no signs of mistreating her. Arabella's sister gives up much of what's good about a young woman's life in early 20th-century Vienna; it's almost frustrating to watch Zdenka maintain such secrecy and unhappiness in her life, when Arabella herself seems to shrug her well-dressed shoulders at the situation and turn her attention back to herself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508261071515/2017-10-16---Arabella-MC-0712.jpg.jpg)
<figcaption>Erin Wall as Arabella and Corey Bix as Count Elemer in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

A woman with a spine is somewhat of a rare find in opera, and so it's hard to admit that Arabella is a woman who warrants very little empathy - even from this female reviewer. Arabella's insistence on waiting for the "right man" among her train of suitors is something that's admirable and surprisingly contemporary even for this 1932 opera. Yet it seems almost selfish for her to dig in her heels so forcefully in these circumstances: her family's financial situation is dire, her sister is being made to live a lie, her suitors are imperfect but not dangerous, and arranged marriages are a reality of her world. I'd understand more if we learned that Arabella's holding out for the right guy was code for "I'm really nervous about getting married", yet Hofmannsthal's libretto has her more proudly resistent to - and amused by - the idea of suitors, at what's frankly a really bad time for pride.

Exasperating women aside, the COC cast features some thrilling voices not limited to the beauty in Wall and Archibald. [Tomasz Konieczny](/scene/people/tomasz-konieczny/) packed an exciting punch as Mandryka, his cannon-like sound instantly adding a shot of strapping masculinity and humanity onstage. He was constantly likable, even in his first scene where Mandryka utterly emasculates Count Waldner (sung amiably by [John Fanning](/talking-with-singers-john-fanning/)), and does it somehow without being an ass. He shows himself to be a man worthy of Arabella's standards, his mystique helped by that exhausting trope where a woman is attracted to men who don't immediately fall at her feet. Konieczny's sound, impressive as it is, seemed monochromatic; the man-to-man colour he used to speak with Waldner was the same when he interacted with Arabella, and at times it gave him a caveman-like quality (charming as that often is).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508261060595/2017-10-16---Arabella-MC-0895.jpg.jpg)
<figcaption>(l-r) Claire de Sévigné as the Fiakermilli, Tomasz Konieczny as Mandryka, John Fanning as Count Waldner and Gundula Hintz as Adelaide in the Canadian Opera Company's new production of *Arabella*, 2017, photo: Michael Cooper.</figcaption>
</figure>

[Claire de Sévigné](/scene/people/claire-de-sevigne/) gave us a much-needed dose of colour, agility, and humour as the Fiakermilli. She handled well the role's semblance to a bat out of hell, starting in the stratosphere with no warning, and pairing dizzying coloratura with cracks of her riding crop. In his busy staging for her scenes, Albery didn't seem to quite trust that the Fiakermilli's music is enough to impress; I kept wanting de Sévigné to park herself downstage and wail away, even for a few still seconds.

For an opera that didn't get the same careful revision process as other Strauss/Hofmannsthal works (*Elektra*, *Der Rosenkavalier*), *Arabella* does seem to tumble along with refreshing organicism. Patrick Lange leads the COC Orchestra through an elastic score; at times it covered the singers, but Strauss always does seem to warrant more of an egalitarian balance between voices and instruments (plus, the orchestra level is the trickiest spot in the Four Seasons Centre for acoustic balance). 

*Arabella* is a piece I'm glad to have seen, considering its rare place in Canada's opera line-up, and even among the Strauss picks worldwide.

>The [COC's production of Arabella](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx) continues through October 28. For details and ticket information, follow our box office links below.
