+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-06-22T21:38:00-06:00"
lastmod = "2015-06-24T07:22:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435124568059/Translation.jpg.jpg"
publishDate = "2015-06-24T07:20:00-06:00"
related_articles = ["articles/6-learn-language.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md"]
short_description = "A translated libretto is one of the more exasperating things in the life of an opera singer. Not always, of course; English to German and vice versa work pretty well, similarly with Italian to French. For reasons that sound trite, singing an English Il barbiere di Siviglia or a German Carmen can feel uncomfortable and weird."
slug = "lost-in-translation"
title = "Lost in translation?"
+++

A translated libretto is one of the more exasperating things in the life of an opera singer. Not always, of course; English to German and vice versa work pretty well, similarly with Italian to French. For reasons that sound trite, singing an English *Il barbiere di Siviglia* or a German *Carmen* can feel uncomfortable and weird. The vowels are all wrong and the rhythms make less sense; worst of all, you can *really hear* when what you're saying sound really lame.

Now, I'll grant that there are some objectively lame translations out there, mostly archaic English found in Schirmer Mozart scores. So it's neat to spend time working with something better than a translation: a fresh libretto. Mozart's *Così fan tutte* becomes *A Little Too Cozy*, complete with new text by Joel Ivany, and basically a new story. For a nerd like myself, this is a sort of perfect storm: music that's spectacular, text that's contemporary, and a common goal among the creative team to tell a new story. 

It means we're ironing out musical details, adapting them to English. Rhythms that make a lot of sense in Italian often make zero sense in English, and even the odd note exchange is a small price to pay for clarity and direct communication with the audience. I realize I just argued that changing Mozart's notes is a small price to pay, but I actually think he'd be on board. Accompanied recits are a perfect example; if Mozart's recits had been set to any language other than Italian, they would sound entirely different. He was a drama-first sort of person when it came to writing opera, and I doubt every sixteenth note is as sacred to him as his texts.

It can be illuminating to sing new text to music with which you're familiar. If a singer knows a role in Italian, but doesn't speak it, trying on an English translation can really show that singer where he wasn't *really speaking*. It's harder to do that in one's native language, and I think it can be intimidating for many.

In details like these, it becomes obvious that a project like *A Little Too Cozy* is indicative of authentic opera-making; the language is accessible, the story is contemporary, and the music and text serve each other. 

Best of all, singers who can shine in this sort of opera will probably knock your socks off in Mozart and Verdi, too.
