+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-08T21:10:00-04:00"
lastmod = "2018-04-08T21:20:00-04:00"
preamble = "Laurence Osborn's new full-length opera, [*The Mother*](https://mahoganyoperagroup.co.uk/productions/the-mother/), sees its world premiere this month at the Polish Social and Cultural Association (POSK). Commissioned by [Mahogany Opera Group](/scene/companies/mahogany-opera-group/), *The Mother* is based on the 1924 play of the same name by Polish playwright Stanisław Ignacy Witkiewicz (known as Witkacy), which tells an \"anarchist, surrealist\" story of the relationship between one mother and her son.\n\nWe spoke with mezzo-soprano Lore Lixenberg, who sings the title role in Mahogany Opera's staged concert world premiere of *The Mother*, April 25; she gives an enthralling insight into her curious character, and what audiences can expect at the show."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523236206177/Lore-Lixenberg.jpg.jpg"
publishDate = "2018-04-08T21:19:00-04:00"
related_articles = ["articles/talking-with-directors-frederic-wakewalker.md","articles/uncomfortable-premieres-the-mother.md"]
related_companies = ["scene/companies/mahogany-opera-group.md"]
short_description = "&quot;The satire and explosiveness is in the score, as Laurence is playing around with Witkacy&#039;s pure form and putting that into music. Also the performance is actually a staged concert that is often a financial decision for a company, opera is expensive, but has the benefit of really putting more focus on the score and the structure of the piece and in my opinion gives an opera performance a certain clarity.&quot;"
slug = "lore-lixenberg-is-the-mother"
title = "Lore Lixenberg is The Mother"
+++

## What kind of woman is The Mother?

She is many many things. On the surface she is an archetypical overbearing, overprotective, overambitious mother who is totally deluded by her offspring's interests and capabilities. She is a faded beauty but is appealingly pragmatic and philosophical about the passing of time in this way, at the same time is deeply nostalgic for a past that as a witness to her story you are never quite sure actually happened. She is classic of women of her time in that they tended to live through the prism of the men in their lives, even the dead ones! 

Although this character is drawn from a Polish writer, being myself of Central European descent, I really recognise this type of person who longs for the past, longs for the old empire, the delusion of order that that brings, the trappings of bourgeois lifestyle and yet also feeling trapped by the trappings. She is a kind of Polish dadaist Hyacinth Bucket! 

She also represents and embodies a dying Europe and a dying century. There is a stench of decay around this character, as though she is rotting inside her own skin as we watch her wend her way through the story to her miserable seedy end. But in spite of this she is likeable, she does everything for the right reasons, but is just blind to the realities around her, and I feel sometimes a bit sorry for her. 

She is addicted to cocaine, alcohol, morphine, misery....and knitting. 
Misery seems to be a pleasure for her. She talks all the time about misery in such ecstatic terms you can almost see the dopamine flooding the reward centres of her brain when she gets onto the subject. The only person in this story that could be remotely considered as a friend is the equally deranged and culinarily challenged maid.

She has a kind of compulsive obsessive disorder, she knits all the time, her response to crisis both good and bad is to knit and the knitting is the only thing in the opera she really has control over and has a huge meaning for her and represents the thread of life itself almost as if she didn't knit life on earth as we know it would stop!

Possibly she is the kind of character that would have some people shrieking misogyny at Witkacy whose great life love and fiancée killed herself and who (naturally, snore) had a problematic relationship with his own mother. But a writer who creates such a blazing wonderful central role for a woman could never ever be accused of that! There is definitely a touch of the Emilia Marty's about this character.

## What does this opera say about familial relationships?

I suppose It basically says that you can pick your nose but you can't pick your relatives; that blood ties can be pretty meaningless and abstract in the end.

## With *The Mother*, how does Mahogany Opera Group create a "satirical and explosive response to the traditions of opera"?

The satire and explosiveness is in the score, as Laurence is playing around with Witkacy's pure form and putting that into music. Also the performance is actually a staged concert that is often a financial decision for a company, opera is expensive, but has the benefit of really putting more focus on the score and the structure of the piece and in my opinion gives an opera performance a certain clarity.

Also I think the Mahogany Opera Group USP is to "explode the traditions of opera" whether its in a gently radical way as in Hind's *Lost in Thought* or by grabbing them young and turning their creative heads around as in the Snappy Operas!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523236678067/MOG_wrkshps_3and4-9.jpg.jpg)
<figcaption>Mahogany Opera Group Artistic Director Frederic Wake-Walker in a MOG workshop.</figcaption>
</figure>

## What do you hope audiences will take away from this world premiere performance?

I hope they go away revolted, disgusted, delighted and enlightened. I hope the opera has the effect of a great Lynch film. I hope they don't have too many nightmares from it. I hope they don't take up knitting.

>[*The Mother*](https://mahoganyoperagroup.co.uk/productions/the-mother/) premieres on April 25 at POSK, London. For details, [click here.](https://mahoganyoperagroup.co.uk/productions/the-mother/)
