+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-11-24T13:49:00+00:00"
lastmod = "2016-11-25T11:47:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480011117783/2016-11-24---LooseTEACarmen-byDahliaKatz-6282.jpg.jpg"
primary_image_credit = "Erica Iris and Andrey Andreychik in Loose TEA Music Theatre's Carmen, 2016. Photo by Dahlia Katz."
publishDate = "2016-11-25T11:27:00+00:00"
related_articles = ["articles/erica-iris-singing-a-radically-revisionist-carmen.md","articles/meet-the-folks-alaina-viau-of-loose-tea.md"]
related_companies = ["scene/companies/loose-tea-music-theatre.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/erica-iris.md","scene/people/alaina-viau.md","scene/people/beth-hagerman.md"]
short_description = "Viau&#039;s new take on the story has John already married to Michaela who comes and pleads for his return home for the sake of their kids, as opposed to his mother in the original. Ricardo is an investment banker ready to support Carmen in her dream of opening her own watering hole in exchange for her feminine charms. John is infatuated with Carmen, as she treats him like he&#039;s still a human being - something he doesn&#039;t recognize in others after two violent turns in Afghanistan."
slug = "loose-tea-raises-funds-for-radical-new-vision-of-bizets-carmen"
title = "Loose TEA raises funds for radical new vision of Bizet&#039;s Carmen"
+++

One of the best things about the Toronto [Indie Opera](/scene/companies/indie-opera-to/) scene, is the willingness to perform in venues not accustomed to housing operas. Yes, usually this finds you in a bar or a pub, but that's great. These places have beer, and taverns often play a very crucial role in some of our favourites in the canon. 

Tuesday night was no exception, at the new(ish) [Club 120](http://www.club120.ca/) on Church Street, [Loose TEA Music Theatre](/scene/companies/loose-tea-music-theatre/) offered up their [new take on the Bizet classic, *Carmen*](/erica-iris-singing-a-radically-revisionist-carmen/). The space was intimate and dark, much like the story Bizet set, which in this particular production focuses on two very serious themes facing us in the public today. The first being the treatment of women in society and breaking the patriarchal status quo of them being property or something for someone to provide for, and the second the cost of Post-Traumatic Stress Disorder not only on the person carrying said diagnosis, but the people who love and care for them. 

The show was a highlight reel of the Carmen "hits." "La fleur que tu m'avais jetée," "Je dis que rien ne m'epouvante," the Habanera, the Seguidilla and the Toréador song all showed up and kept the audience glued to the stage. The show opened up with a series of [four videos](https://www.youtube.com/channel/UCiYEOqBZMigUcbMSwzHBmcQ) shot by Darren Bryant and directed by Artistic Director [Alaina Viau](/scene/people/alaina-viau/) that told the exposition of the four characters in this pared down version: Carmen, John Anderson (Don José), Ricardo (Escamillo), and Michaela (Micaëla - okay maybe I didn't need to clear that one up). 

Viau's new take on the story has John already married to Michaela who comes and pleads for his return home for the sake of their kids, as opposed to his mother in the original. Ricardo is an investment banker ready to support Carmen in her dream of opening her own watering hole in exchange for her feminine charms. John is infatuated with Carmen, as she treats him like he's still a human being - something he doesn't recognize in others after two violent turns in Afghanistan. The two suitors meet, and clash, and then people die. 

This show featured new dialogue and a transladaptation of the libretto by Viau herself. [Natasha Fransblow](/scene/people/natasha-fransblow/) of [MYOpera](/scene/companies/myopera/) fame was at the keys. One of my favourite additions was that of sound design and collaborations with [Slowpitchsound](http://www.slowpitchsound.com/). The "overture" and Carmen's redux of the song she sings with John before he hears the call of the batallion (in this production treated as a hallucinatory side-effect of the PTSD) were the genesis of what I think could become a really meaningful and current treatment of Bizet's score. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480013917652/2016-11-24---LooseTEACarmen-byDahliaKatz-6176.jpg.jpg)
<figcaption>Photo by Dahlia Katz.</figcaption>
</figure>

Fresh off her amazing run of [*Naomi's Road* for Tapestry Opera](/in-review-naomis-road/), mezzo [Erica Iris](/scene/people/erica-iris/) holds down court in the title role (#BowDown). In this show she's a bartender/server with dreams of opening her own establishment. Erica brought a tangible realness to the character of Carmen that's often missing when I see this produced elsewhere. She's regularly played as an archetype with an infallible kind of strength, here, her vulnerability shone through. It doesn't hurt that Erica sang the heck out of it either. In top vocal form, we were brought a brighter sounding Carmen than I'm used to, even with Ms. Iris's natural, honey-coloured tone, and I really appreciated it. She was able to bring some of the playfulness, which is the source of her Carmen's charisma, into her vocalisation and it made it, dare I say, fun? Yes, I dare. Her Carmen was fun, she wasn't clouded by this sense of doom, even though Bizet's score keeps thrusting it at our eardrums. It brought some youth back into the role and was a very, very effective choice (whether made consciously or not.)

[Ryan Harper](/scene/people/ryan-harper/) brings us the embattled John Anderson (Don José). Ryan is such a generous actor on-stage and his characterizations are rooted solidly in physical truth of gesture. I really applaud Harper for his sensitive and intelligent portrayal of such a complex condition. I can't wait to see how it pans out further as this project develops. Harper sang John with a full-throated, rounder sound that's developed quite a lot since the last few times he and I were onstage together, and the progress is exciting. Living even-more in a full Lyric mode, the line was easy and well-produced and energized. I was particularly fond of his use of head voice at certain points during his singing, and I think this is a tactic he could explore and execute more often as the sound is exquisite. I think there could be some pacing issues though as he did seem to get a little vocally tired towards the end, but this is probably due to a number of factors not the least of which the heightened emotional state he dwells in for the entirety of the production. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480013906831/2016-11-24---LooseTEACarmen-byDahliaKatz-6298.jpg.jpg)
<figcaption>Ryan Harper in Loose TEA Music Theatre's *Carmen*, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

As Ricardo (Escamillo) baritone Andrey Andreychik sang with a bright, steely tone that was solid through his whole register. Reminding me somewhat of Val Kilmer in his Batman days, Andreychik had the perfect balance of swagger, darkness, and unintentional smarm. Although we don't see a whole lot of him in this run, it's nice to see him not portrayed too sleazily. Yes, he's got an ulterior motive, but it seems like it comes from him wanting to be with Carmen more so than just own her. But this is also how a stalker can start out, which I think is the important question here considering the shows focus on women's safety. 

Once again, soprano [Beth Hagerman](/spotlight-on-beth-hagerman/) proves why she's one to watch on the scene here in Toronto. Her Michaela was devastating and her ability to keep the stress-level up that high was something to see. Her voice, flawless as always, is a stellar match for the surprisingly huge sing that is Michaela. When singing of the loss her kids felt with their father's disappearance, she dug into the flesh of your feelings and refused to let you go. It was a great thing to watch. I love when a singer is really good at dealing with the audience being very close to them, and Hagerman loves the crowd and you can tell, whether she interacts with them directly or not. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480012183438/2016-11-24---LooseTEACarmen-byDahliaKatz-6217.jpg.jpg)
<figcaption>Erica Iris and Ryan Harper in Loose TEA Music Theatre's *Carmen*, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

Viau's work with Loose TEA is taking a more direct tack now, and she's decided to use the company to examine the struggle of women in today's society. Attacking constructs and displaying these struggles in intimate venues where the issues won't be glossed over by the grandeur of the standard performing practice. I found that this interpretation of Carmen was a perfect match for that, and I'm looking forward to it's development. There's a [Kickstarter campaign](https://www.kickstarter.com/projects/looseteacarmen/carmen-a-modern-re-visioning) if you'd like to contribute to making the full show a reality. 
