+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2019-10-15T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Lyric Opera of Chicago's [production of _Luisa Miller_](https://www.lyricopera.org/productions/2019-20/luisa-miller/) runs through October 31."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571168903/media/2019/10/sqQuinnKelsey_KrassimiraStoyanova_LUISAMILLER_LyricOperaofChicago_LYR191008_427_y3wu71.jpg"
primary_image_credit = "Krassimira Stoyanova (Luisa) and Quinn Kelsey (Miller) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg."
related_articles = ["articles/roundtable-an-operatic-triple-threat.md", "articles/loc-barber.md", "articles/talking-with-conductors-enrique-mazzola.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/christian-van-horn.md", "scene/people/enrique-mazzola.md", "scene/people/quinn-kelsey.md", "scene/people/joseph-calleja.md", "scene/people/krassimira-stoyanova.md"]
short_description = "While in the first act, the singers interacted awkwardly, with little to no dramatic commitment to their movements or singing, in the final moments of the show, the principals all rose to the occasion, singing and acting with dramatic impetus that temporarily stopped time. "
slug = "luisa-miller-a-suberbly-shaped-start-to-chicagos-early-verdi-venture"
title = "Luisa Miller a \"superbly shaped\" start to Chicago's early Verdi venture"
youtube_url = ""

+++
With this weekend's opening of [_Luisa Miller_](https://www.lyricopera.org/productions/2019-20/luisa-miller/), Lyric Opera of Chicago launches what is planned to be a multi-season exploration of Verdi's early operas. [Enrique Mazzola](/talking-with-conductors-enrique-mazzola/), LOC’s music director designate, is slated to lead the cycle. If this weekend's opening night performance of _Luisa Miller_ is anything to go by, Chicago audiences will be treated to dynamic, superbly shaped, and dramatically incisive interpretations of Verdi.

The undisputed stars of last night's performance were the Lyric Opera Orchestra and Mazzola himself. The LOC Orchestra rarely disappoints, but they were in truly exceptional form Saturday night. From the opening whirls of the overture to the sublime stasis of the finale, the LOC Orchestra wowed with a vibrant palette of colors, virtuosic precision, and three-dimensional textures. A special shout out must be given to principal clarinetist Charlene Zimmerman for her gorgeously played solos. No doubt, Maestro Mazzola was an invigorating and inspirational presence, particularly as this is the very repertoire that established his reputation as one of today's leading interpreters of Italian bel canto. It will be exciting to see how Mazzola will continue to mold this orchestra over the coming years.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571168945/media/2019/10/SolomanHoward_QuinnKelsey_LUISAMILLER_LyricOperaofChicago_LYR191008_150_jb6s0a.jpg){{% /md %}}

<figcaption>(l-r) Soloman Howard (Wurm) and Quinn Kelsey (Miller) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Of course, it's true for any piece, but scores like _Luisa Miller_ benefit immensely from the dedicated and sensitive treatment given it by Mazzola and the LOC Orchestra. Universally labeled a "transitional" opera within Verdi's output, _Luisa Miller_ premiered in 1849 and was the composer's fifteenth completed work. In the next few years Verdi would go on to write three of his most beloved operas: _Rigoletto_, _Trovatore_, _Traviata_.

> If _Luisa Miller_ lacks in recognizable tunes, it makes up for it with interesting moments of orchestration, structure, and drama.

Yet, it fascinates me to recall that, by this time in his career, the thirty-six-year-old Verdi had already produced such masterful works as _Nabucco_, _Ernani_, and _Macbeth_, among others. _Luisa Miller_ marks a period of growth and experimentation for Verdi. As Maestro Mazzola himself described it in a [recent interview](/talking-with-conductors-enrique-mazzola/), it's a "study opera in which Verdi explores possibilities that he will develop over the next decades of his life."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571168957/media/2019/10/KrassimiraStoyanova_QuinnKelsey_LUISAMILLER_LyricOperaofChicago_LYR191008_154_grhpos.jpg){{% /md %}}

<figcaption>Krassimira Stoyanova (Luisa) and Quinn Kelsey (Miller) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Indeed, if _Luisa Miller_ lacks in recognizable tunes, it makes up for it with interesting moments of orchestration, structure, and drama. Especially noteworthy were striking moments of a cappella ensemble singing as well as colorful doublings and dove-tailings between the orchestra and voices. It was fascinating to observe the progression of the opera, from a rather matter-of-fact first act, to an increasingly complex second act, leading to an electrifying Verdian finale. Director Francesca Zambello, returning to LOC after last season's _West Side Story_ for this production of Luisa Miller, notes Verdi's compositional "transition" over the course of the opera with Act III being the work's, and by extension Verdi's, "arrival."

> When their fates finally collide at the opera's conclusion, the singers' embodiment of their characters was gripping and heart wrenching.

This same sense of arrival toward the end of the opera was felt from the stage. Though simple, this production's set was visually pleasing and really placed the dramatic onus on the music and, ultimately, the singers. Designed by Michael Yeargan, the set consisted of a prominent backdrop of painted forests, their tone and shade reflecting the states of mind of the characters. During the opera's final 20 minutes, I was completely engrossed in the doomed fortunes of the main characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571168967/media/2019/10/KrassimiraStoyanova_JosephCalleja_LUISAMILLER_LyricOperaofChicago_nnfves.jpg){{% /md %}}

<figcaption>Krassimira Stoyanova (Luisa) and Joseph Calleja (Rodolfo) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Andrew Cioffi.</figcaption>

</figure>

Singing the role of Miller, Luisa's father, was baritone and Chicago-favorite [Quinn Kelsey](/scene/people/quinn-kelsey/); as Luisa, we heard Bulgarian soprano [Krassimira Stoyanova](/scene/people/krassimira-stoyanova/) and Maltese tenor [Joseph Calleja](/scene/people/joseph-calleja/) returns to LOC as Rodolfo, Luisa's true love interest. This lead trio is supported by bass-baritone Christian Van Horn as Miller’s rival, Count Walter, and bass [Soloman Howard](/scene/people/soloman-howard/) as Wurm, the Count's steward and Luisa's conspiring would-be lover.

> There's an uncanny resemblance in Calleja's timbre with that of Pavarotti, particularly in the softer end of the spectrum—something that made me listen with even more rapt ears.

When their fates finally collide at the opera's conclusion, the singers' embodiment of their characters was gripping and heart wrenching. It seemed they too underwent something of a "transition" over the course of the show. While in the first act, the singers interacted awkwardly, with little to no dramatic commitment to their movements or singing, in the final moments of the show, the principals all rose to the occasion, singing and acting with dramatic impetus that temporarily stopped time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571168982/media/2019/10/ChristianVanHorn_KrassimiraStoyanova_QuinnKelsey_LUISAMILLER_LyricOperaofChicago_LYR191008_288_xszmad.jpg){{% /md %}}

<figcaption>(l-r) Christian Van Horn (Walter), Quinn Kelsey (Miller) and Krassimira Stoyanova (Luisa) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Vocal highlights of the evening came from Joseph Calleja. Despite some brief, but surprising, moments of raspiness, the tenor stunned with his superb cantabile and crystalline tone. His Act II aria, "Quando le sere al placido," made one's heart soar with his silken tenor voice. Maybe I'm the only one who thinks this, but there's an uncanny resemblance in Calleja's timbre with that of Pavarotti, particularly in the softer end of the spectrum—something that made me listen with even more rapt ears.

> Here’s someone who excels at volcanic vocalism and arias that erupt in anger or resentment.

Similarly captivating in his lyric moments, baritone Quinn Kelsey delivered a multi-dimensional portrayal of Luisa's father. Here’s someone who excels at volcanic vocalism and arias that erupt in anger or resentment. I still vividly recall his "Cortigiani vil razza dannata" from LOC's _Rigoletto_ two seasons ago. In this production, his beautiful Act I aria "Sacra la scelta," was a standout of the evening as were his duets with Stoyanova, who seemed to embody her character more and more as the opera progressed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571168997/media/2019/10/AlisaKolosova_JosephCalleja_LUISAMILLER_LyricOperaofChicago_LYR191008_248_riqxwf.jpg){{% /md %}}

<figcaption>Joseph Calleja (Rodolfo) and Alisa Kolosova (Federica) in Luisa Miller, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Making his LOC debut in this production, American bass Soloman Howard offered an intimidating performance of Wurm. His tremendous voice was matched by his towering stature. Also making her LOC debut was Kathleen Felty, a current member of the Ryan Opera Center. The American mezzo-soprano sang the role of Laura, a village girl, with charm and an easy stage presence. Her bold, honeyed mezzo seemed to float through the theater and complemented her colleagues beautifully.

Luisa Miller plays at LOC until October 31 and should not be missed by Verdi-lovers.