+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = 2019-11-17T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Lyric Opera of Chicago's production of [_Don Giovanni_ ](https://www.lyricopera.org/productions/2019-20/don-giovanni/)runs through December 8."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574035300/media/2019/11/sqFang_LucasGIOVANNI_LyricOperaofChicago_227_nrg1fh.jpg"
primary_image_credit = "Ying Fang (Zerlina) and Lucas Meachem (Don Giovanni) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker."
related_articles = ["articles/talking-with-singers-rachel-willis-sørensen.md", "articles/spotlight-on-amanda-majeski.md", "articles/don-giovanni-strengthened-by-reinterpretation.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/brandon-cedel.md", "scene/people/ying-fang.md", "scene/people/ben-bliss.md", "scene/people/lucas-meachem.md", "scene/people/amanda-majeski.md", "scene/people/rachel-willis-sorensen.md"]
short_description = "For generations of (male) musicologists, the character Don Giovanni has been something of an egalitarian sex god. These academics propped up their vision of Don-G-as-political-progressive with weak evidence, citing his willingness (compulsion?) to sleep with any woman, even fat, poor, and old ones. "
slug = "a-don-giovanni-with-style-in-chicago"
title = "A Don Giovanni with style in Chicago"
youtube_url = ""

+++
_Don Giovanni_, that most inimitable of Mozart's collaborations with librettist Lorenzo Da Ponte, is something of an operatic Rorschach test; tell me what you think is funny about _Don Giovanni_ and I could guess your age, average annual income, and definitely your gender. Personally, I don't believe this work has persisted as a canonical hit for centuries because it's \~hilarious\~ but rather because its intrinsic complexities are borne out in a well-paced work of theater that happens to contain some of the best music Mozart wrote for voices.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035331/media/2019/11/BenBliss_RachelWillisS%C3%B8rensen_DONGIOVANNI_LyricOperaofChicago_074_kwiqsv.jpg){{% /md %}}

<figcaption>Ben Bliss (Don Ottavio) and Rachel Willis-Sørensen (Donna Anna) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

For generations of (male) musicologists, the character Don Giovanni has been something of an egalitarian sex god. These academics propped up their vision of Don-G-as-political-progressive with weak evidence, citing his willingness (compulsion?) to sleep with any woman, even fat, poor, and old ones. Such interpretations skirt his cruelty and ignore his utter lack of empathy not just for women but for anyone outside himself. 

At the same time, many so-called "#MeToo" productions of this opera that have cropped up in recent seasons turn Don Giovanni into a mere monster and thus too miss the mark as in addition to flattening the titular character, they tend to simplify the motivations of the three central women, (Donna Anna, Donna Elvira, Zerlina), whose rich interior lives and complex plot lines ought to stand in stark contrast to Don Giovanni's pathology.

> Indeed, so easy and playful is their chemistry, Meachem and Rose ought to be cast as a package deal.

The [current production at Lyric Opera of Chicago](https://www.lyricopera.org/productions/2019-20/don-giovanni/), (a remount from the 2014-15 season),  negotiates the inherent challenges of _Don Giovanni_ with style. Here, the action moves to 1920s Spain, an ingenious choice that has Leporello and Don Giovanni snorting coke at a ubiquitous red-checked café table in the piazza as the rest of the cast appears in a veritable fashion show of peak-Gatsby fabulosity, care of costume designer Ana Kuzmanic. Every bespoke detail from Kuzmanic is a joy to behold, from Zerlina's dainty white pumps to Donna Elvira's motorcycle cap and goggles. 

The gorgeous sets, designed by Walt Spangler, are big and striking, favoring cascades of greenery and flowers. I particularly love the towering altarpiece of the Act II church scene, which features a larger-than-life madonna bedecked in glowing candles. Duane Schuler's lighting design was highly evocative, punctuating moments of revelation and reflection with a switch to an uncanny, white light.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035356/media/2019/11/BrandonCedel_YingFang_DONGIOVANNI_LyricOperaofChicago_179_w7b8ca.jpg){{% /md %}}

<figcaption>Brandon Cedel (Masetto) and Ying Fang (Zerlina) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

Holding the center of the drama, [Lucas Meachem](/talking-with-singers-lucas-meachem/)'s Don Giovanni is strongly-sung with a finely-wrought interpretation. Meachem achieves an incredible range of colors and emotions in his recitatives, from a seductive whisper to explosive, rage-fuelled shouts. Meachem's Giovanni feels dangerous and unpredictable in all the right ways, alternating between sudden violence, (especially in his fight with Masetto and the manhandling of chorus girls in his speedy "Fin ch'han dal vino"), and tenderness; his Act II aria "Deh, vieni alla finestra" was shiveringly beautiful. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574051256/media/2019/11/LucasMeachem_DONGIOVANNI_LyricOperaofChicago_757_qcm75s.jpg){{% /md %}}

<figcaption>Lucas Meachem (Don Giovanni) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

His ultimate demise, ingeniously choreographed on a capsized banquet table, was sensational to watch. Meachem snarled and raged through Act II's infamous dinner scene, the perfect foil to Mika Kares' dignified turn as the Commendatore's statue.

> Fang is a true Mozartean, with an alluringly light voice and a great sense of style.

[Matthew Rose](/scene/people/matthew-rose/)'s Leporello, Don Giovanni's ambivalent sidekick, was equally stellar. Rose's burnished bass voice paired nicely with Meachem's baritone. Indeed, so easy and playful is their chemistry, Meachem and Rose ought to be cast as a package deal.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035373/media/2019/11/AmandaMajeski_BenBliss_RachelWillisS%C3%B8rensen_DONGIOVANNI_LyricOperaofChicago_397_lb3ibd.jpg){{% /md %}}

<figcaption>(l-r) Amanda Majeski (Donna Elvira), Ben Bliss (Don Ottavio), and Rachel Willis-Sørensen (Donna Anna) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

Donna Anna is increasingly a signature role for [Rachel Willis-Sørensen](/talking-with-singers-rachel-willis-sorensen/). Her abiding grief at the loss of her father, (who is murdered by Giovanni in the first scene of the opera), is palpable throughout the rest of the show. Willis-Sørensen's unusually dark, rich voice makes a striking contrast with the rest of the cast and while her "Non mi dir" felt preternaturally slow and laborious, virtually everywhere else Willis-Sørensen's singing was admirably naturalistic and expressive. You can read Rachel Willis-Sørensen's own thoughts on this role in the [most recent instalment](/talking-with-singers-rachel-willis-sorensen/) of Schmopera's _Talking with Singers_ series.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035386/media/2019/11/LucasMeachemandcast_DONGIOVANNI_LyricOperaofChicago_365_zhp8wi.jpg){{% /md %}}

<figcaption>Lucas Meachem (Don Giovanni) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

As her betrothed, Don Ottavio, tenor [Ben Bliss](/scene/people/ben-bliss/)' light, appealing voice sailed through the challenges of the part's two arias, "Dalla sua pace" and "O mio tesoro." Not one of the most dynamic tenor roles in the Mozart repertoire, Ottavio wiles away the opera badgering Donna Anna about a timeline for their wedding and consistently failing to do the one thing she’s asked him to do: avenge her father's death.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035396/media/2019/11/MatthewRose_LucasMeachem_DONGIOVANNI_LyricOperaofChicago_596_tm3ayb.jpg){{% /md %}}

<figcaption>(l-r) Matthew Rose (Leporello) and Lucas Meachem (Don Giovanni) in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

In this production, Donna Elvira ([Amanda Majeski](/spotlight-on-amanda-majeski/)) rolls into town on a broken-down motorcycle, (complete with sidecar!) with a series of costumes seemingly plucked from [Edith Crawley](https://66.media.tumblr.com/cc9b3398c5181a2395c67da2cd875f70/tumblr_inline_nlm86eouia1touigu_1280.jpg)'s _Downton Abbey_ season 3 wardrobe. A punishing role to sing, Mozart wrote Donna Elvira with wild leaps and an ever-changing tessitura. Majeski manages these challenges well, with a vibrant, bright voice with plenty of ping.

Making her Lyric debut, [Ying Fang](/scene/people/ying-fang/) sings Zerlina, the peasant who Giovanni targets on her wedding day, with knowing cheek and endless charm. Fang is a true Mozartean, with an alluringly light voice and a great sense of style. [Brandon Cedel](/scene/people/brandon-cedel/), (also in his house debut), makes a pitch-perfect Masetto, playing Zerlina's fiancé as a sensitive guy with a macho streak.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574035409/media/2019/11/AmandaMajeski_DONGIOVANNI_LyricOperaofChicago_574_rtddab.jpg){{% /md %}}

<figcaption> in Don Giovanni, Lyric Opera of Chicago, 2019. Photo: Kyle Flubacker.</figcaption>  
</figure>

At the end of the opera, the house lights suddenly come up as the cast sings the moralistic line, "Such is the end of the evildoer: the death of a sinner always reflects his life!" It's a cheeky, funny send-off, with the cast pointing to specific audience members as the opera reaches its conclusion. Our anonymity prematurely yanked from us, we laugh nervously, join the wild clapping, then pull on our coats and gloves and head out into the busy, dark world once more.