+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2019-02-04T19:15:32+00:00"
disclaimer = ""
image_gallery = []
postamble = "You can see [Strauss' _Elektra_ at the Lyric Opera of Chicago](https://www.lyricopera.org/concertstickets/calendar/2018-2019/elektra-opera-tickets) on select dates between now and February 22nd. I recommending reading a little Jung before you head to the theater!"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549581054/media/2019/02/sqNinaStemmeELEKTRALyricOperaofChicago.jpg"
primary_image_credit = "Nina Stemme in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver."
related_articles = ["articles/inflatable-beasts-vocal-brilliance-locs-siegfried.md", "articles/elektra.md"]
related_companies = []
related_people = ["scene/people/elza-van-den-heever.md", "scene/people/michaela-martens.md", "scene/people/nina-stemme.md"]
short_description = "Every facet of this production is thoughtful and dramatic, so much so that even the actors aren't immune from its terrors. It was announced before curtain that Stemme sustained a knee injury during a rehearsal (one look at the steeply raked set and you'll wonder the whole cast isn't on crutches!)."
slug = "stemmes-elektra-visible-in-every-wild-look-and-lurching-step"
title = "Stemme's Elektra visible in every wild look and lurching step"
youtube_url = ""

+++
[Nina Stemme](/scene/people/nina-stemme/), the powerful soprano known around the world for her commanding leading roles, scorches the stage as an unparalleled Elektra at the Lyric this month. If you have the chance to experience her historic Chicago debut, seize it. You will be mesmerized by the size and beauty of her incredible voice. Stemme imbues every phrase, word, and _note_ with expressivity and nuance, giving no indication (despite the role's notorious difficulty) that she is conserving or rationing her vocal strength. Singing Elektra is often compared to summiting Mount Everest—requiring diligent preparation and uncommon physical and mental endurance just to get through it. Yet Stemme performs with grace and energy, never once hinting at any strenuous exertion. An artist renowned for her intellect and self-discipline as well as her vocal prowess, Stemme is also a deeply engaging actor. Her very personal understanding of the multi-faceted Elektra is visible in every wild look and lurching step.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581135/media/2019/02/NinaStemme2ELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Nina Stemme in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

> Every facet of this production is thoughtful and dramatic, so much so that even the actors aren't immune from its terrors.

Almost a premonition, _Elektra_ premiered a full four years before Carl Jung wrote about the "Electra Complex" in his _The Theory of Psychoanalysis_. It is unclear whether Jung ever attended Strauss' opera or his librettist Hugo von Hofmannsthal's earlier adaptation of the Sophocles play, but it seems very likely. As Nina Stemme put it in a conversation with me last week, _fin de siècle_ Germany was a singular time, when "psychoanalysts were going to the theater and the opera composers were reading psychoanalysis." Freud and Jung couched, (pun intended), their psychological theories in the language of classical mythology, while modernist artists worked to articulate the political and social upheaval of the time by self-consciously creating new expressive modes. It was in this context that Strauss abandoned conventional harmonic structures in favor of powerful _leitmotives_ set against a backdrop of wild dissonances that only occasionally, (as in the sublime Elektra-Orest reunion scene), relax into a blanket of tonality. Broadly a meditation on female power, sexuality, and the malignancy of revenge, _Elektra_ has endured over 100 years not just because the music is truly amazing but also because the anxieties this story provokes are as significant as ever.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581200/media/2019/02/ELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

[David McVicar's production](https://www.lyricopera.org/concertstickets/calendar/2018-2019/elektra-opera-tickets) is bold, dark, and full of bald-headed women in ratty panniers and smeared makeup. It is eerie, haunting, and wholly original. I loved it.

_Elektra_'s unique dramatic structure consists of a series of tense exchanges between Elektra and the four other main players in the drama: her sister, Chrysothemis; her mother, Klytämnestra; a stranger, (revealed to be her brother, Orest); and her stepfather, Aegisth. [Elza van den Heever](/scene/people/elza-van-den-heever/) makes a deeply sympathetic, crucially feminine Chrysothemis, Elektra's pitiable sister. With a graceful stage presence and sweet but full lyric voice, van den Heever is the perfect foil to Stimme's angular embodiment of madness.

> Donald Runnicles makes a stellar, and long overdue, debut at LOC with this production of _Elektra_.

Van den Heever's focused, agile sound lends itself to an unusually diverse singing schedule; she appears next as Vitellia in Mozart's _La clemenza di Tito_ at the Met and made her Lyric Opera of Chicago debut less than ten years ago singing (of all things) Armida in Handel's _Rinaldo._

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581286/media/2019/02/ElzavandenHeeverELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Elza van den Heever in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Totally unrecognizable, mezzo-soprano [Michaela Martens](/scene/people/michaela-martens/) is riveting as the haunted Klytämnestra. I could have listened to Stemme and Martens go head-to-head all night—there is such a great chemistry between them. Martens singing is emotionally-charged, with a text delivery that is powerful in its remarkable clarity and refined subtleties.

As Elektra's long-lost brother Orest, Scottish baritone Iain Paterson was stoic almost to a fault. A solidly-sung performance was undercut by a wooden physicality in the opera's most beautiful moment: his reunion with Elektra.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581323/media/2019/02/MichaelaMartensELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Michaela Martens in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Robert Brubaker, a tenor with a powerful, characterful voice, makes his Lyric debut as the reviled Aegisth, making a strong impression despite limited stage time. I hope he will return to Chicago soon with a meatier part to play.

Every facet of this production is thoughtful and dramatic, so much so that even the actors aren't immune from its terrors. It was announced before curtain that Stemme sustained a knee injury during a rehearsal (one look at the steeply raked set and you'll wonder the whole cast isn't on crutches!). I want to wish her a speedy recovery and stress that the injury in no way impaired the dramatic intensity of her performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581402/media/2019/02/NinaStemmeElzavandenHeeverELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Elza van den Heever and Nina Stemme in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

Donald Runnicles makes a stellar, and long overdue, debut at LOC with this production of _Elektra_. The Scottish maestro, formerly music director of the San Francisco Opera and currently the General Music Director of the Deutsche Oper Berlin, is one of today's leading interpreters of Strauss and Wagner. Together with the superb Lyric Opera of Chicago Orchestra, Runnicles navigated Strauss' dense score with mesmerizing incisiveness and dramatic sweep.