+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = 2020-02-11T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1581451847/media/2020/02/sq-resized-DeborahNansteel_AnaMar%C3%ADaMart%C3%ADnez_GrahamMacfarlane_MADAMABUTTERFLY_LyricOperaofChicago_LYR200203_1536_tcmsab.jpg"
primary_image_credit = "Ana María Martínez (Cio-Cio San), Deborah Nansteel (Suzuki) and  Graham Macfarlane (Sorrow) in Madama Butterfly, Lyric Opera of Chicago, 2020. Photo: Todd Rosenberg."
related_articles = ["articles/a-tale-of-two-ciocio-sans.md", "articles/4-opera-scenes-that-should-have-happened.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/deborah-nansteel.md", "scene/people/ana-maria-martinez.md", "scene/people/brian-jagde.md"]
short_description = "Puccini’s Madama Butterfly hardly needs any introduction, being one of the top 10 operas performed yearly in both the U.S. and Europe. The story of a young geisha jilted by a selfish, predatory American naval officer has gripped audiences since the first decade of the 20th-century, as has Puccini’s masterful score. "
slug = "martinez-creates-an-empowered-cio-cio-san-at-lyric-opera-of-chicago"
title = "Martínez creates an empowered Cio-Cio San at Lyric Opera of Chicago"
youtube_url = ""

+++
Puccini’s _Madama Butterfly_ hardly needs any introduction, being one of the top 10 operas performed yearly in both the U.S. and Europe. The story of a young geisha jilted by a selfish, predatory American naval officer has gripped audiences since the first decade of the 20th-century, as has Puccini’s masterful score.

Lyric Opera of Chicago’s current run of [_Madama Butterfly_](https://www.lyricopera.org/productions/2019-20/madama-butterfly/) hits many of the right notes in doing justice to this well-known masterpiece. For starters there’s the production itself. Director Louisa Muller revives Michael Grandage’s original co-production for the Houston Grand Opera and the Grand Théâtre de Genève. Christopher Oram’s sets and costumes are simple, beautiful, and culturally sensitive without being distracting. Lighting designer Chris Maravich does incredible work with Neil Austin’s original lighting, which captures superbly the atmosphere of each moment as well as the coloristic effects of the music. Utilizing primarily a curved, declining ramp and some sliding Japanese-style paper doors, the focus of the show remained on the music and the main characters’ interactions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581451869/media/2020/02/AnaMar%C3%ADaMart%C3%ADnez_Graham_Nansteel_MADAMABUTTERFLY_LyricOperaofChicago_LYR200203_1659_lcjcp1.jpg){{% /md %}}

<figcaption>Ana María Martínez (Cio-Cio San), Deborah Nansteel (Suzuki) and  Graham Macfarlane (Sorrow) in Madama Butterfly, Lyric Opera of Chicago, 2020. Photo: Todd Rosenberg.</figcaption>

</figure>

In light of this beautifully minimalistic staging, the acting by the two leads left one wanting. Vocally, tenor [Brian Jagde](/scene/people/brian-jagde/) (Pinkerton) and soprano [Ana María Martínez](/scene/people/ana-maria-martinez/) (Cio-Cio-San) were in strong form, but something felt missing or stilted watching them on stage. Much of the time they faced directly out into the audience or down toward the conductor, which made it difficult for convincing, engaging exchanges. That said, Jagde sang a beautiful Pinkerton. His Act III aria “Addio, fiorito asil” was especially moving, as was his trio in the same act with Sharpless and Suzuki. Here one sensed the regret of a vile coward. The customary boos – followed by the ovation – were much deserved.

> The sheer beauty of this music is not to be missed, especially during the dreary Chicago winters.

Martínez is a local favorite and the LOC audience made it clear they loved having her back in town, and especially for what has become a signature role for her. Having sung Cio-Cio-San at the Met, in Paris, and other operatic capitals, Martínez brings a wealth of experience, time, and thoughtfulness to this role. This shows in the understated expressivity of her motions, glances, and vocalism. In an enlightening essay included in the program book, Martínez makes a strong case for Cio-Cio-San as an empowering, independent woman – never a victim, despite her socio-cultural circumstances. Martínez’s performance of “Un bel dì” drove this point home.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581451910/media/2020/02/AnaMar%C3%ADaMart%C3%ADnez_MADAMABUTTERFLY_LyricOperaofChicago_LYR200203_1953_itsgre.jpg){{% /md %}}

<figcaption>Ana María Martínez (Cio-Cio San) in Madama Butterfly, Lyric Opera of Chicago, 2020. Photo: Todd Rosenberg.</figcaption>

</figure>

Mezzo-soprano [Deborah Nansteel](/scene/people/deborah-nansteel/) played Suzuki, Butterfly’s stalwart friend and servant. In many ways Suzuki is the heart of this opera. She stays with Cio-Cio-San through all the turmoil of her ill-fated relationship, the resultant child, the renunciation of her family and community – she is Cio-Cio-San’s bedrock. Nansteel gave us a movingly dignified Suzuki. With a silken mezzo, she more than held her own against the rest of the cast.

Baritone and second-year Ryan Opera Center member Ricardo José Rivera deserves special mention for stepping in as Sharpless on very short notice. Perhaps a bit nervous at first, Rivera settled into his role wonderfully, delivering morsels of judiciousness to Pinkerton with grace and authority.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581451931/media/2020/02/BrianJagde_AnaMar%C3%ADaMart%C3%ADnez_GrahamMacfarlane_MADAMABUTTERFLY_LyricOperaofChicago_LYR200203_2097_swlegd.jpg){{% /md %}}

<figcaption>Brian Jagde (Pinkerton), Ana María Martínez (Cio-Cio San) and Graham Macfarlane (Sorrow) in Madama Butterfly, Lyric Opera of Chicago, 2020. Photo: Todd Rosenberg.</figcaption>

</figure>

Guest conductor Henrik Nánási leads this run of _Madama Butterfly_. _Butterfly_ was composed well past the mid-point of Puccini’s career. In this score, as in his subsequent operas _La fanciulla del West_ and _Turandot_, Puccini paints with an incredibly rich palette of orchestral colors. The influences of Wagner and Debussy are overt in a score like _Butterfly_. Although Nánási’s rather brisk tempi kept the drama moving along, certain moments of orchestral magic were glossed over. Much of the Wagnerian sumptuousness of the Act I love duet between Cio-Cio-San and Pinkterton was lost and hurried.

[_Madama Butterfly_](https://www.lyricopera.org/productions/2019-20/madama-butterfly/) runs at LOC through March 8. The sheer beauty of this music is not to be missed, especially during the dreary Chicago winters.