+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2019-09-30T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Next up is [_Luisa Miller_](https://www.lyricopera.org/productions/2019-20/luisa-miller/), opening October 12th, with Music Director Designate Enrique Mazzola conducting."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569889527/media/2019/10/sqLawrence_Brownlee_Alessandro_Corbelli_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_484_d5e205.jpg"
primary_image_credit = "Lawrence Brownlee (Count Almaviva) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg."
related_articles = ["articles/psychology-audition.md", "articles/blo-barber-brings-delightful-laughter-amid-overdesign.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/adam-plachetka.md", "scene/people/marianne-crebassa.md", "scene/people/lawrence-brownlee.md"]
short_description = "While his vocal brilliance was not at all a surprise, Lawrence Brownlee's spirited stage antics were a consistent delight throughout the evening. Known for virtuosically ornamenting the already-florid lines of his bel canto repertoire, Brownlee seemed to be playing it safe on Saturday night, despite sounding in fantastic voice."
slug = "brownlee-headlines-season-opener-in-chicago"
title = "Brownlee headlines season opener in Chicago"
youtube_url = ""

+++
On Saturday at [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/), the red carpet was bustling as the public thronged into the lobby ahead of the season opener: Rossini's [_Barber of Seville_](https://www.lyricopera.org/productions/2019-20/barber-of-seville/). While I'll always be partial to a cheeky Tuesday matinee, it's a genuine hoot to gawp at the coiffed, well-heeled, and often bejewelled opening night patrons. The annual promise of the ultra-exclusive Opera Ball following the performance ensures a fashionable assemblage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889596/media/2019/10/MarianneCrebassa_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_246_p1fi3i.jpg){{% /md %}}

<figcaption>Marianne Crebassa (Rosina) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

This production of _Barber_ - a re-mount from 2014 - features beautiful sets with pale stone and rounded archways designed by Scott Pask, with a revolving set-piece that gives us both a Sevillian courtyard and the airy interior of Doctor Bartolo's patrician abode. Fabulously detailed costumes by Catherine Zuber are sure to enchant; Almaviva's leather trench! The intricate embroidery on Rosina's Act I gown! Howard Harrison's genuinely gorgeous lighting design marks the passage of time clearly and colorfully. 

> Even most native Italian singers don't have such a finessed command of the language and richly nuanced approach to recitative, let alone his bodacious sense of comic timing.

Tara Faircloth directs the revival, originally helmed by Rob Ashford. While all the faffing about with potted plants and jazz-square heavy choreo in the Act I finale grew tiresome, there were many comic bright spots, (and lots of big-bellied laughs!), thanks to a plucky cast of principals unafraid of physical comedy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889612/media/2019/10/Marianne_Crebassa_Lawrence_Brownlee_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_955_ibu7yg.jpg){{% /md %}}

<figcaption>Marianne Crebassa (Rosina) and Lawrence Brownlee (Count Almaviva) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

While his vocal brilliance was not at all a surprise, [Lawrence Brownlee](/scene/people/lawrence-brownlee/)'s spirited stage antics were a consistent delight throughout the evening. Known for virtuosically ornamenting the already-florid lines of his bel canto repertoire, Brownlee seemed to be playing it safe on Saturday night, despite sounding in fantastic voice. Probable opening-night nerves aside, there are few—if any—tenors today who could toss off such a rendition of "Ecco ridente in cielo" as Chicago audiences were treated to at opening night.

Broad-shouldered Czech bass-baritone [Adam Plachetka](/scene/people/adam-plachetka/) is our jocular town barber, Figaro. While his voice doesn’t move too nimbly through some of Rossini’s little turns, Plachetka's Figaro has an undeniably attractive roguish charm. His easy comic way on stage is especially winsome in his interactions with Brownlee—they have a great tag-team chemistry, (and prove remarkably good at throwing and catching various items to each other throughout the show.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889624/media/2019/10/Lawrence_Brownlee_Marianne_Crebassa_Alessandro_Corbelli_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_658_b3kkiy.jpg){{% /md %}}

<figcaption>Lawrence Brownlee (Count Almaviva), Marianne Crebassa (Rosina) and Alessandro Corbelli (Bartolo) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

In the role of Rosina, [Marianne Crebassa](/scene/people/marianne-crebassa/)'s dark, dark vocal timbre makes for an oddly but appealingly incongruous contrast with her girlish, winsome physicality. "Una voce poco fa" was delectably sung, even atop a precariously swaying staircase. A game comedienne, Crebassa proved a dynamic scene partner, especially in her interactions with her guardian, Dr. Bartolo, played by Alessandro Corbelli.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889637/media/2019/10/Krzysztof_Ba%CC%A8czyk_Lawrence_Brownlee_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_741_aqgwit.jpg){{% /md %}}

<figcaption>Krysztof Bączyk (Basilio) and Lawrence Brownlee (Count Almaviva) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Corbelli, resplendent in a delightful two-pronged wig, is an ideal Bartolo. It's true, Corbelli is the only native Italian in the cast, but even most native Italian singers don't have such a finessed command of the language and richly nuanced approach to recitative, let alone his bodacious sense of comic timing. Rather more curmudgeonly than full-tilt evil, Corbelli's Bartolo deflates rather pitiably when he sees Rosina and Almaviva together, making the choice to include Count Almaviva's protracted and musically-uninteresting final Act II aria, (however beautifully sung by Brownlee), all the more head-scratching.

> Krysztof Bączyk channeled a waggish Professor Snape, twirling about in his robes and using his lanky frame, (he towers over most of the cast), to great comic effect.

An unintended consequence of Corbelli's characterful Italian is that it highlights parallel deficiencies elsewhere in the cast. Current Ryan Opera Center soprano Mathilda Edge's uncommonly pretty voice couldn't offset an underdeveloped grasp of the opera's language.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889649/media/2019/10/Adam_Plachetka_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_118_d6k79i.jpg){{% /md %}}

<figcaption>Adam Plachetka (Figaro) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Making his Lyric debut as the slimy Don Basilio, Doctor Bartolo's sidekick, rich-voiced Krysztof Bączyk channeled a waggish Professor Snape, twirling about in his robes and using his lanky frame, (he towers over most of the cast), to great comic effect.

Two more current Ryan Center members are featured in the cast—Eric Ferring, whose exceptionally beautiful tenor impresses even in very fleeting roles like "A Sergeant," and baritone Christopher Kenney, who kicks off the opera’s action as Fiorello. I love Kenney's bright, big voice and it's a pleasure to hear a bit more of him here than we got to last season.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889664/media/2019/10/Adam_Plachetka_Lawrence_Brownlee_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_224_fzrgsf.jpg){{% /md %}}

<figcaption>Adam Plachetka (Figaro) and Lawrence Brownlee (Count Almaviva) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

After a gratifying preview a few weeks back at [Millennium Park](/stars-of-the-lyric/), I was expecting to hear the Lyric Orchestra in even finer form at the opera house. Instead, Sir Andrew Davis—who usually gets reliably fleet results from the pit—tempi seemed sluggish, especially through the first act. One occasionally had the sense that singers had locked in quicker tempi and were making adjustments on the fly. That said, there were still moments of staggeringly fast patter, especially Corbelli's lightning-quick "A un dottor," which you can get a taste for in this clip from Glyndebourne's 2016 production, featuring Corbelli with a rather less-whimsical wig and [Danielle de Niese as Rosina](https://www.youtube.com/watch?v=KnZ8-twwS8c).

The stalwart men of the Lyric Chorus were in fine form throughout the night, acing their cameos as rowdy musicians and soldiers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569889675/media/2019/10/Adam_Plachetka_Alessandro_Corbelli_Krzysztof_Ba%CC%A8czyk_THE_BARBER_OF_SEVILLE_Lyric_Opera_of_Chicago_LYR190925_309_kmaosd.jpg){{% /md %}}

<figcaption>Adam Plachetka (Figaro) Alessandro Corbelli (Bartolo) and Krysztof Bączyk (Basilio) in The Barber of Seville, Lyric Opera of Chicago, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

Altogether, [_Barber_](https://www.lyricopera.org/productions/2019-20/barber-of-seville/) is a perfectly fine kick-off to what will be, on the whole, a diverse and exciting season at the Lyric Opera of Chicago.