+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-11T21:29:00-05:00"
lastmod = "2015-11-12T14:10:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447355213658/2015-11-12%20-%20Attention%20Span.jpg.jpg"
publishDate = "2015-11-12T14:10:00-05:00"
related_articles = ["articles/shhdont-tell-them-its-opera.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md","scene/companies/the-bicycle-opera-project.md"]
short_description = "The other day, I was witness to the stunning brevity of a first-grader&#039;s attention span. I spent a couple of days playing opera for kids, and I remembered how easy it was to lose an audience of young listeners; any lulls in the action, in the drama, any slow-ish music that goes on for just a bit too long, these are opportunities for kids to get bored during the show, and instead spot something fascinating on the opposite wall, or on the bottom of their shoes."
slug = "live-theatre-respecting-short-attention-spans"
title = "Live theatre &amp; respecting short attention spans"
+++

The other day, I was witness to the stunning brevity of a first-grader's attention span.


I spent a couple of days playing opera for kids, and I remembered how easy it was to lose an audience of young listeners; any lulls in the action, in the drama, any slow-ish music that goes on for *just a bit* too long, these are opportunities for kids to get bored during the show, and instead spot something fascinating on the opposite wall, or on the bottom of their shoes.

Now, kids have always had itty bitty attention spans, and opera is something that even adults can get get bored watching. Still, I've played shows for kids where they were totally rapt and engaged, and I've heard feedback from surprised teachers who saw their class at their most attentive (during an opera, of all things!). From my experience, it's entirely reasonable to put up opera for kids, and expect them to enjoy it. 

Just like grown-ups, kids want to see a good show about something they understand. There are three big criteria that pop up when it comes to opera for kids: it has to be in a language they understand, it has to be accessible and entertaining, and it has to be short. The catch is that setting lines to music makes them immediately slower than they'd be if they were spoken; opera is by definition a slowing down of reality. It's no wonder that opera, ballet, museums, etc., are hard sells for excitable kids who can use an iPad.

It struck me, as I thought of our collectively poor attention spans, that audiences for art forms like opera are divided basically into two groups: people who are on their phone, and kids. Since everyone agrees that our [attention spans are getting shorter](http://www.telegraph.co.uk/news/science/science-news/11607315/Humans-have-shorter-attention-span-than-goldfish-thanks-to-smartphones.html), including (especially?) that of [young people](http://www.huffingtonpost.com/diana-graber/kids-tech-and-those-shrinking-attention-spans_b_4870655.html), it makes sense to come back to that old question about adapting art to contemporary audiences. At Huff Post, [Diana Graber writes](http://www.huffingtonpost.com/diana-graber/kids-tech-and-those-shrinking-attention-spans_b_4870655.html) that kids' increased exposure to technology may not be something to bemoan, simply a reality that warrants adaptation in schools. I think that applies to the arts, too.

You could look at the situation and decide that opera's luxurious pace will fall more and more behind the norm, and it'll be written off as an archaic form of entertainment. On the other hand, you could see opera, like books and museums and the ballet, as one of many ways to balance out the short attention span that comes with technology. Schools and other institutions already know this; that's why I got to go to places like the ROM and The Science Centre when I was in elementary school. 

It's sort of like that adage about giving a man a fish to eat now, and teaching him to fish for later. When schools bring opera singers or animal experts or "mad scientists" into their classrooms, they do it because they're trying to expose the students to *more*. Quantity of artistic experience, just like being gifted fish after fish, can only go so far. I think the next step, with kids anyway, is about meeting in the middle with the arts experience itself.

Opera composers already know this, which is why new works don't really sound like Verdi, and operas written specifically for kids take into account those three criteria I mentioned above. The "opera short" is becoming its own genre, thanks to companies like [Tapestry Opera](/scene/companies/tapestry-opera/) and their *Booster Shots*, or [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) and their touring collection, *shadow box*. I think there's a specific kind of inspiration that touches the composer and librettist when they're creating a dense scene, rather than a full-length work. 

It's not even about introducing short bursts of opera to kids so that they'll want to buy season tickets when they're adults. It's about making it easy to hear stories told with music, so that the larger concept (singing when you could be speaking) isn't unfamiliar. When we put value and effort into creating great art for all ages, *and* we respect audiences with short attention spans, I think we can break down the perceptions of inaccessibility and long-winded singing. While we're teaching young people to sit through live performances, the young people can answer a lot of our questions about opera's ability to adapt.
