+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-21T12:01:00-04:00"
lastmod = "2017-09-23T11:48:00-04:00"
preamble = "Late this month, Haymarket Opera Company opens its run of [*Ariane et Bachus*](http://www.haymarketopera.org/arianeetbachus), a rare take on a tale that opera lovers know well. First performed in Paris, 1696, under the reign of Louis XIV, the opera by Marin Marais, famed composer and virtuoso gamba player  tells the story of Ariadne and Bacchus, with enough surprising plot twists in the libretto by Saint-Jean to keep Greek mythology experts on their toes.\n\n[*Ariane et Bachus*](http://www.haymarketopera.org/arianeetbachus) runs at the Studebaker Theater in Chicago, **September 30, October 1 & 3, 2017**. We spoke with music director Craig Trompeter and stage director/choreographer Sarah Edgar about Haymarket Opera's first foray into French *tragédie en musique*, the strong focus on dance and design, and their favourite parts of Marais' opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506115072812/2017-09-22---pc-mkusumosurarso-coverhaymarket-2.jpg.jpg"
primary_image_credit = "Image: Martin Kusumosurarso Photography Inc."
publishDate = "2017-09-23T11:48:00-04:00"
related_articles = ["articles/ian-page-mozart-imagination.md", "articles/ariodante-or-the-hebridean-handel.md", "articles/overdue-for-the-stage-haymarket-opera-companys-ariane-et-bachus.md", "articles/three-cities-lots-of-options-coming-up-in-march.md"]
related_companies = ["scene/companies/haymarket-opera-company.md"]
related_people = ["scene/people/nathalie-colas.md"]
short_description = "&quot;I have to admit that I am partial to demons, having portrayed a dancing fury a few times myself. After carefully embodying good taste in the noble characters, the evil characters get to break all the rules. Plus, in hell you get to play with snakes, wands, and torches.&quot;"
slug = "little-known-gems-ariane-et-bachus"
title = "&quot;Little-known gems&quot;: Ariane et Bachus"

+++
## What do you find is unique about Marais' setting of the Ariadne myth? 

**Craig**: This presentation of the Ariadne/Bacchus myth includes several colorful plot twists which serve to draw out the original myth story: Juno appears to warn King Aenarus not to welcome and honor Bacchus because Bacchus is the bastard son of Jupiter and Semele; Juno collaborates with Prince Adraste (the would-be lover of Ariadne) to turn Ariadne against Bacchus. At first Juno disguises herself as Dircée, the jilted lover of Adraste, who then makes a false claim to have received advances from Bacchus with the hope of turning Ariadne against him . Cupid thwarts the plan by telling Ariadne that it is all a deception by Juno. Plan B involves Adraste appealing to his sorcerer sidekick Géralde to use magic to fight against Bacchus. The demons refuse to combat the god, saying that he has no fear of the underworld. All in all, there is much intrigue!

**Sarah**: I love that in the Marais opera, Ariadne is given an impressive emotional range.  Of course she laments her abandonment by Theseus, but she doesn't remain stuck in her beautiful lament. She is at turns furious at Theseus and the woman who ran away with him, haughty to Adrastus (another potential lover), rejecting of Amour's advice that she give her heart to Bacchus, hesitant at Bacchus' initial proclamations of love, and driven insane by the fury Alecto before finally giving her heart to Bacchus. Our Ariane, Kristin Knutson, is a brilliant actress, who can really embody these emotional shifts.

## What role do dance and costumes play in this production? How would their involvement compare to a 17th-century production of Ariane et Bachus?

**Craig**: Dance has been an essential element of French theatre from the early 17th century until the present day. Indeed, opera in France was more or less invented by Jean-Baptiste Lully, a dancer-composer. Dance is absolutely integral to our performances. *Ariane et Bachus* prominently features our new Haymarket Opera Company Ballet, trained by Sarah Edgar. There are numerous divertissements in the work - moments that display the power of dance to tell a story. In addition to numerous formal choreographies, Sarah has artfully employed the dancers in most of the staging to add color and personality to each moment. 

The costumes are as authentically 17th-century as Meriem Bahri can make them. She is a true scholar of early fashion and has incredible flair for tying the myriad of costumes into a cohesive whole which always pleases the eye and furthers the drama. 

**Sarah**: A French baroque opera simply must include dance! Louis XIV, that great patron of the opera, was himself a dancer, and it would be inconceivable for a 17th-century Parisian audience to have an opera without numerous ballets. At Haymarket Opera Company, we strive to create productions that are as historically informed as possible. The dances in *Ariane et Bachus* are, I believe, as prominent as they would have been in the original production. The dancers function much like the chorus, adding details or advancing the plot. Sometimes they are happily celebrating the arrival of Bacchus and sometimes they are furious demons.

The costumes by Meriem Bahri are breathtakingly beautiful and breathtakingly historical. However, the costumes also function as a way for the 21st-century performers to fully inhabit the 17th-century world that Marais created. The corset demands an upright and noble carriage of the body, and it also exposes the upper chest as an important site for expressive movement. The carriage of the arms and the acting gestures of the period truly make sense when one is wearing a 17th-century costume.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506115102095/2017-09-22---Ariane.jpg.jpg)
<figcaption>Costume sketch for Ariane by Meriem Bahri.</figcaption>
</figure>

## How does *Ariane et Bachus* fit in with Haymarket Opera's artistic mission and aesthetic?

**Craig**: This is the first time HOC has produced a French *tragédie en musique*. It has been an incredible and rewarding challenge - our "Mount Everest" with so many people on stage and in the pit, new stage sets, and a new corps de ballet. Works of this size and scope also require a virtuoso team of fundraisers and a dedicated base of financial support to succeed. I have said many times that after *Ariane* almost any opera will seem easier!

**Sarah**: Since Paris was the cultural capital of Europe in the 17th and 18th centuries, the operas performed there are of the utmost importance to our understanding and enjoyment of baroque opera. Not every opera company can try to bring to life such a big production, but HOC is really an amazing group of dedicated artists and scholars. *Ariane et Bachus* has not been performed since the 17th century (as far as I know), so this fits in perfectly with HOC's mission to bring little-known gems of the 17th and 18th centuries to Chicago!

## Do you have any favorite moments from the opera?

**Craig**: So many. There are heartbreaking scenes for Ariane, Dircée, and Adraste. The simple beauty of Amour's entrance never fails to make me smile. I delight in the wicked demon scene and the final chorus is quite simply a twinkling gem.

**Sarah**: I have to admit that I am partial to demons, having portrayed a dancing fury a few times myself. After carefully embodying good taste in the noble characters, the evil characters get to break all the rules. Plus, in hell you get to play with snakes, wands, and torches.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506115146137/2017-09-22---Craig-Trompter.jpg.jpg)
</figure>

>Haymarket Opera Company presents [Ariane et Bachus](http://www.haymarketopera.org/arianeetbachus), September 30 to October 3. For details and ticket information, follow our box office links below.