+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-07-06T12:51:00-04:00"
lastmod = "2015-04-23T15:03:00-04:00"
preamble = "The [Against the Grain Theatre](http://againstthegraintheatre.com/) crew has arrived at the beautiful [Banff Centre](http://www.banffcentre.ca/programs/program.aspx?id=1457), getting ready for the anticipated [_#UncleJohn_](https://www.facebook.com/events/1494928980723400/?ref=br_tf). The crew includes lighting designer [Jason Hand](http://www.jasonhandlighting.com/), who is no stranger to AtG. His lighting design was nominated for a Dora Award for Figaro's Wedding. With _Pelléas et Mélisande_ freshly closed, _#UncleJohn_ will be the second _al fresco_ performance in a row for Jason. I asked him about his work; he spoke eloquently about joining forces with Joel Ivany, hiking in Banff, and working with the sunset."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429815388810/Jason-Hand2-1024x750.jpg.jpg"
publishDate = "2014-07-06T12:51:00-04:00"
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md"]
short_description = "Lighting designer Jason Hand is no stranger to AtG. His lighting design was nominated for a Dora Award for Figaro&#039;s Wedding. With _Pelléas et Mélisande_ freshly closed, #UncleJohn will be the second al fresco performance in a row for Jason. I asked him about his work; he spoke eloquently about joining forces with Joel Ivany, hiking in Banff, and working with the sunset."
slug = "lighting-unclejohn-jason-hand"
title = "Lighting #UncleJohn: Jason Hand"
+++

### What's your favourite part about your work as a lighting designer?

The best days are when I get asked to work on an interesting story with a director and set designer who want to make it something unique.  Spending time creating shows alongside driven, creative people makes me work harder.  I love the early design meetings with the director and the other designers.  Those are the meetings when the world of the opera is created. Every director works differently at this stage (the variety is part of the fun) but when there's a good team, there are always engaging discussions.
Another favourite day of mine is the technical work-through of the show.  Usually 12 hours long, it's the day during technical rehearsals when we finally bring all the elements together: staging is adjusted, lighting is reworked (and then reworked again), and the timing of every entrance is tested.  Sometimes it lasts 2 or 3 days on a big show, or sometimes only a few hours on an even bigger opera.  The work-through is high-pressure and all-consuming.  I love it.

### How does lighting design make or break a show?

Actually, I don't believe that lighting has that ability... nor does scenic or sound design.
Let me explain it this way: you can sit down in a beautifully decorated restaurant, with great service and perfectly plated dishes.  In the end, if the food is overcooked, bland and leathery, then the meal is a failure.  No amount of tarting it up can save it and nobody raves about a restaurant whose greatest achievement is the wallpaper.  I've seen brilliant shows with terrible design, and I've still have enjoyed them.  Now I'm not suggesting that design isn't valuable: when it pushes hard against a good story, it takes the experience to another level.  It can give great performers the best possible platform from which to grab the audience.  When all the design disciplines work together, the result can be astounding.  But it only works if it's all in support of good storytelling.  Otherwise, it's just trashy special effects.

### You’ve worked with AtG several times before. Why do you enjoy working with Joel Ivany and his team?

I've designed 4 other shows for Against the Grain: _Pelléas et Mélisande_, _Figaro's Wedding_, _Turn of the Screw_, and _La bohème_.  Each one has been produced in a different space under a totally new set of circumstances.  We had no dimmers or lighting inventory for _La bohème_ or _Figaro's Wedding_, and we had theatrical lighting along with some moving lights for _Turn of the Screw_ and _Pelléas_.  We had a tiny crew for _Figaro_, and then the backing of the COC for _Pelléas_.  There is no standard configuration for an Against the Grain show, and so there are no aesthetic expectations.  The audience at AtG shows have only two regular expectations when they buy their ticket: they know that they're going to get world-class performances and that Joel is going to turn it in to something unique.  That's what I enjoy about the company: Joel thinks up the best way to tell the story, then rebuilds the company each time in order to make it happen.
### Does an outdoor venue like the Cave and Basin present any unique challenge to your job?

Outdoor theatre is always tricky because you can't control the weather or the sunset.  While we are creating the show, the sun will be setting 2 minutes earlier each night.  That may not seem significant, but consider this: the first day of rehearsal a 3-minute aria might happen at 8:45pm, before the sun starts to dip.  A week later, it will still happen at 8:45pm but now it will be dusk, the singer lit nicely by the sunset.  Two days later, we will be relying on mostly on theatre lighting.  It adds up!  Between the start of technical rehearsals and the closing night, there will be change in the sunset time by about 30 minutes.  It has a huge impact on the needs of the lighting rig, and that's without even considering the day-to-day changes in cloud cover.  Those variables means that the show will look different each night, and the design needs to account for all of it.
It gets even trickier.  Not only can we only do full technical rehearsals at night, but we also have to be careful to rehearse the show in real-time as much as possible.  Starting on time is critical, which puts added pressure on the stage management team.  If we stop a run for too long to solve a staging problem, then we risk getting out of sync with the sunset.  There's no negotiating with the earth's rotation!

Beyond the weather and the sunlight, there are additional technical obstacles when designing outside.  It's obvious that we aren't doing this in a conventional theatre.  For me that means that there is no lighting inventory, no dimmers, no lighting desk, no pre-installed infrastructure of any kind.  If I need something, it has to be found or rented, then brought in.  Additionally, it has to be weather-proofed.  Electricity and water have never really gotten along well.  At first, this extra technical baggage might feel very limiting.  But when there is no traditional stage to consider, and no lighting positions, then you have to think about the design differently.  What can I provide to the audience so that they better understand this story?  Do they really need people to be lit by me in order to see them, or is daylight enough?  How does the lighting focus the audience's attention on a an entrance?  Does it even need to?  Everything the audience sees in the space is going to inform their understanding of the opera.  Even the choice of house lights (typically not negotiable in a conventional theatre space) will help shape the atmosphere.  So what do we want the audience to feel when the walk into the venue, and how should that mood change throughout the opera?  How theatrical should the lighting be?  Or maybe it's better if we just accept that this story is happening in front of us, today, in Banff and not in Seville in the 17th century?  Is that context critical?  Patrick Du Wors (set and costume designer), Joel Ivany (director), and I are all going to be pushing on these questions throughout the next few weeks at we create space where we will show off Joel's new adaptation.

### What will you do during your down time in Banff?

I can't wait to do some hiking and some quiet reading in the Park.  However, time off from #UncleJohn is likely going to be filled with work on my upcoming shows. Joel has asked me to light his production of Carmen this fall at the Vancouver Opera so we will have lots of work to do on that one.  It's going to be a busy few weeks, but I couldn't imagine a better location for a design studio.

Stay posted at www.schmopera.com to meet the rest of the _#UncleJohn_ crew, and to catch the latest happenings here in Banff.
