+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-04-07T00:08:43+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554595712/media/2019/04/sqDFpressimageAlfred.png"
primary_image_credit = "Colin Campbell as Alfred in MassOpera's production of Die Fledermaus, 2019. Photo: Nile Scott Studios."
related_articles = []
related_companies = []
related_people = []
short_description = "In this regard, this adaptation takes advantage of every possibility of its updated New York setting for jokes. Rosalinda, for instance, is a star on an obvious Real Housewives knock-off in New York, and thus her husband's arrest and trial is very high-profile. "
slug = "light-and-frothy-fledermaus-brought-new-translation"
title = "Light and frothy Fledermaus brought new translation"
youtube_url = ""

+++
With all of the serious productions of works being bandied around the Boston opera scene lately, I think one thing is more vitally important to recognize: sometimes, opera-goers just want to have a little bit of _fun_. When this is asked for, one can rarely go wrong with Johann Strauss II's _Die Fledermaus_, an operetta about people playing pranks on each other that is as silly as the music is bubbly. Thus, it has chosen the right time to come along in the Boston opera scene, considering what everyone else is doing.

> In this regard, this adaptation takes advantage of every possibility of its updated New York setting for jokes.

But even here, the people of MassOpera (formerly MetroWest Opera) have opted to do something new with this opera. This production of _Fledermaus_ also presents a premiere of a new "translation" of the work’s libretto by Sarah Ina Meyers. I say "translation" in quotes, because "translation" is a bit of a misnomer: this new script that Meyers has given her singer/actors to work is much more of an adaptation of Karl Haffner and Richard Genée's original script than it is a real translation owing to the fact it opts to also update a bunch of references for the modern day while sticking to the basic plot beats of the original.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554596418/media/2019/04/DFgroup.jpg){{% /md %}}

<figcaption>The Ensemble of MassOpera's production of Die Fledermaus, 2019. Photo: Nile Scott Studios.</figcaption>

</figure>

In this regard, this adaptation takes advantage of every possibility of its updated New York setting for jokes. Rosalinda, for instance, is a star on an obvious _Real Housewives_ knock-off in New York, and thus her husband's arrest and trial is very high-profile.

But what really strikes me about this adaptation is not just that the references are updated: the form of the script also underwent some amount of change to cater to modern taste, for some parts of the show are reworked in a way that reminds me of the romantic comedy films of the past several decades.

> Does the whole adaptation work? I'm not so certain.

Perhaps the biggest indication of this is how Rosalinda is treated as a character: here, she starts the show as something of a fame hound who lives on social media, something that colors her interactions with Adele in a slightly different light. Thus, while she and her husband Eisenstein talk in disguise in the party at the center of Act II, Eisenstein complains about this to her face: this leads to a surprisingly sweet moment when they reconcile in Act III and Rosalinda opts to delete her Facebook page on the spot. I appreciate very much that this translation added something of real substance to the original libretto; it would have been all too easy to stop this "adaptation" at throwing in several pop culture references, and the fact that Meyers went above and beyond that speaks volumes about the quality of this adaptation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760769/media/2019/04/DF_Promo_020.jpg){{% /md %}}

<figcaption>Brianna Meese in MassOpera's production of Die Fledermaus, 2019. Photo: Nile Scott Studios.</figcaption>

</figure>

Of course, the base plot beats remain the same: strangely, however, the show does not feel dated in any way. Perhaps the production's conceit in tying this whole show to the larger-than-life world of reality TV works in its favor, because only in the world of something like, say, _Punk'd_ could Falke get away with a prank of this scale in the social media age. In redressing it, though, it also shows just how fresh the central prank at the heart of the show can be. It also keeps all of Johann Strauss' bubbly melodies intact, and the show's new translations of the lyrics also prove funny given they continue what the adaptation of the spoken word segments already do.

> What also helps considerably is the stellar cast of young singers who populated the stage of the Plaza Theater.

Does the whole adaptation work? I'm not so certain. There's a good chunk of time at the end of Act II devoted to allowing chorus members to sing various solos from other works (_Maybe This Time_ and the Catalogue Aria both worked their way into this somehow) that I felt dragged a little bit and thus took away from the energy that had been built up by that point. Perhaps, too, some of the numbers did drag on a little longer than was really advisable. Still, even these slow segments were carried by everything else that was going on, and there were enough laughs to keep the evening fresh.

What also helps considerably is the stellar cast of young singers who populated the stage of the Plaza Theater, a vast majority of whom were committed to the material in a way I have rarely seen with a Strauss operetta. Kelley Hollis brought a neurotic energy to Rosalinda that really fit the character's newer arc in the adaptation, and she balanced this with a voice that effortlessly floated over Strauss' vocal writing with an ease that takes most professionals years to get.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554760749/media/2019/04/DF_Promo_015.jpg){{% /md %}}

<figcaption>Kelley Hollis as Rosalinda in MassOpera's production of Die Fledermaus, 2019. Photo: Nile Scott Studios.</figcaption>

</figure>

Stefan Barner's Eisenstein absolutely looks the part, and his neuroses hilariously matched Rosalinda, particularly in the exchange that they have while disguised at the party. Brianna Meese's Adele was playful and funny, but vocally she was a powerhouse, and she essentially stopped the show with her crystalline laughing song in Act II. Special mention also goes to Ann Fogler's Orlofsky: she plays Orlofsky while playing into the Marlene Dietrich persona she adopts for the party, and the result reads as delightfully eccentric in a way that colored the rest of the party.

> MassOpera have managed to produce a reinvented Strauss opera that is as light on its feet and charming as it is fresh and new.

Also, too, does Colin Campbell's Alfred register as a very fun character: it would be easy to read his actions and play them to the hilt for creepiness, but there's a somewhat playful energy to the way Campbell plays Alfred that is irresistible, especially when he can’t stop singing Verdi off the top of his head the way he does here. Timothy Gorka's Frank is also delightfully dorky, strutting around the stage with a particular kind of awkwardness that was as adorable as it was funny.

The only weak spot I can find is with Mitch Fitzdaniel's Falke, and even then that is only because he was a serviceable Falke surrounded by so many other much more eccentric characters.

The end result is a light, frothy evening that represents mindlessly entertaining opera at its absolute best, and what a joy it is to sit through! Johann Strauss' operettas can often feel rather old-fashioned, but MassOpera have managed to produce a reinvented Strauss opera that is as light on its feet and charming as it is fresh and new. It is a rather tricky combination to pull off, but the creative team at MassOpera have certainly found a way to pull it off, and what a lovely evening it is!