+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-11T10:21:00-06:00"
lastmod = "2017-06-12T08:59:00-06:00"
preamble = "This week at Luminato Festival, you can catch a work-in-progress presentation of [*Charlotte: A Tri-Coloured Play with Music*](https://luminatofestival.com/2017/Events/Charlotte-A-Tri-Coloured-Play-with-Music), an extraordinary piece of theatre by scenograher [Pamela Howard](http://www.pamelahoward.co.uk/charlotte.html), librettist [Alon Nashman](http://www.alonnashman.com/) and composer [Aleš Březina](http://alesbrezina.cz/zivotopis/?lang=en), based on the life and works of Charlotte Salomon. Between 1941-1942 while hiding in the south of France, Salomon produced over 1000 paintings and a graphic *Singspiel* entitled, *Leben? oder Theater?*. Though Salomon was sent to Auschwitz at 26 - and pregnant - her works survived.\n\nOn the centenary of her birth, Luminato presents [*Charlotte*](https://luminatofestival.com/2017/Events/Charlotte-A-Tri-Coloured-Play-with-Music), June 16-18 at The Theatre Centre, 1115 Queen St. W. We spoke with Howard and Březina about their work and the extraordinary story of Charlotte Salomon."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497236969701/2017-06-11---Square---Charlotte-Photo-1.jpg.jpg"
primary_image_credit = "Adanya Dunn as Charlotte in Charlotte: A Tri-Coloured Play with Music."
publishDate = "2017-06-12T08:59:00-06:00"
related_articles = ["articles/rehearsing-trauma-how-working-on-an-opera-helped-me-heal.md", "articles/interviewing-the-greats-virginia-zeani.md", "articles/dont-miss-luminatos-bearing.md", "articles/heggies-holocaust-operas-see-canadian-premiere.md"]
related_people = ["scene/people/adanya-dunn.md"]
short_description = "&quot;Charlotte has a sense of time running out for her, both from learning about the history of suicides in her family, and sensing the destiny that we all know lay ahead. The uniqueness of her work is that it survives, though she did not, in its complete form, and is a testament to the power of art to triumph over adversity.&quot;"
slug = "life-like-theatre-at-luminato-the-story-of-charlotte-salomon"
title = "Life-like theatre at Luminato: the story of Charlotte Salomon"

+++
## How is Charlotte Salomon's work unique among Jewish art from WWII?

**Pamela Howard**: What is unique about her work is that in 2 years at the end of her very short life she painted 1200 touches from memory of her former life in Berlin, and put them together in the form of a "Singspiel" - a spoken song cycle reminiscent of popular music theatre heard and seen in Berlin in the 1920's. She called this "Singspiel" *Life or Theater* and in it is has the Proustian remembered story of her life, and the people in it. 

**Ales Brezina**: To me it's rather a general story, not just strictly a Jewish one. I consider it a moving document of adolescence in a cruel time. It demonstrates what abnormal circumstances make out of normal people. It's a tragedy told by an innocent young woman, not aware of the fact that it's tragedy for most part of the play.

**Howard**: Charlotte has a sense of time running out for her, both from learning about the history of suicides in her family, and sensing the destiny that we all know lay ahead. The uniqueness of her work is that it survives, though she did not, in its complete form, and is a testament to the power of art to triumph over adversity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497199573473/2017-06-11---charlotte1.jpg.jpg)<figcaption>Character sketch for the 2017 production of *Charlotte: A Tri-Coloured Play with Music*, by Pamela Howard.</figcaption>
</figure>

## Are there works of Charlotte's with which you connect or identify more strongly than others?

**Howard**: I connect with Charlotte as an artist, simply because I often also draw in three colours as she did, red, yellow and blue. My own theatre practice is to make the maximum from the minimum, and like Charlotte, I know how to make a myriad of colours from a few. I especially love the pages that have simultaneous scenes, all happening at the same time, sometimes jumbled up, just as it was in her head.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497199398207/2017-06-11---Charlotte_Salomon_-_JHM_4175.jpg.jpg)
<figcaption>Painting from *Leben? oder Theater? Ein Singspiel*, by Charlotte Salomon.</figcaption>
</figure>

## How have you chosen to combine the textual and visual elements of Charlotte's work? 

**Howard**: Alon Nashman has written the libretto, and Ales Brezina has composed the score. I have tried to visualise both text and sound in colour and the three dimensions of the stage space. However, there is only a certain amount that can be predicted or theorised in advance, for actors, or singer are like animals once they get into the space and become "the criers of the myth". 

**Brezina**: Textual, visual and musical elements are inseparable in our setting of Charlotte´s story. Sometimes one element underlines the other(s), sometimes music contradicts the words and pictures, sometimes it comments upon the way that Charlotte herself tells the story (and even uncovers her own real desires). And despite the tragical story it's supposed to offer a lot of fun because we don't tell it from Hitler's point of view, nor from a historical retrospective, with our knowledge about Charlotte's sad end, but rather from the situations as they happened to the growing young girl, one after the other. Her life wasn't just the finale, it had an overture, many years of life filled with happiness, hope and even love.

**Howard**: The art of making a synchronised theatre piece, is to be able to draw all the essential elements together in the stage space to tell a coherent story...which is an ironic, sometimes funny and tragic life told from memory. I have invented the staging of scenes, and used references to Charlotte's work, but not tried to copy them. We have developed as with the music, our own *Tri-Coloured Play*. Above all I have tried to preserve the integrity of Charlotte's story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497236940097/2017-06-11---Charlotte-Photo-2.jpg.jpg)<figcaption>Adanya Dunn as Charlotte.</figcaption>
</figure>

## What do you hope audiences will take away from these first performances at Luminato?

**Brezina**: A wide range of deep emotions reaching from laughs to tears. An increased sensibility towards injustice and an appeal to act if we see injustice happen around us now.

**Howard**: A desire to look further at the story of Charlotte's Life. All her gouaches are available on the web, but having seen *A Tri-Coloured Play with Music* at Luminato, they will be able to better interpret them, and appreciate all the more that her legacy is her art.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497199422466/2017-06-11---sc01.jpg.jpg)
<figcaption>Scenic sketch for the 2017 production of *Charlotte: A Tri-Coloured Play with Music*, by Pamela Howard.</figcaption>
</figure>

***
**CAST**

<ul class="nospace">

<li>Thom ALLISON: Grandfather / Faculty Member / Minister of Propaganda / Herr Schmidt
<li>Ariana CHRIS: Paulinka Bimbam
<li>Adanya DUNN: Charlotte Kann / Woman Protestor
<li>Derek KWAN: Albert Kann / Pope
<li>Kelly McCORMACK: Concierge / Birgit, a Maid / Usher / Barbara
<li>Alon NASHMAN: Amadeus Daberlohn
<li>Xin WANG: Franziska / Grandmother
</ul>

**MUSICIANS**

<ul class="nospace">

<li>Peter TIEFENBACH: Keyboards / Dr. Singsong
<li>Lori FREEDMAN: Clarinets / Tante Hedwig
<li>Erika NIELSEN: Cello / Woman Protester
<li>Ben PROMANE: Trumpets / Uncle Walter
</ul>

**CREATIVE TEAM**

<ul class="nospace">

<li>[Aleš BŘEZINA](http://alesbrezina.cz/zivotopis/?lang=en): Composer
<li>[Alon NASHMAN](http://www.alonnashman.com/): Librettist
<li>[Pamela HOWARD](http://www.pamelahoward.co.uk/charlotte.html): Director / Scenographer
<li>Peter TIEFENBACH: Music Director
<li>Patrick LAVENDER: Lighting Designer
<li>Marie-Josée CHARTIER: Movement Director
<li>Nathalie BONJOUR: Executive Producer
<li>Kaitlin HICKEY: Production Manager
<li>Sydney CAVANAGH: Head of Wardrobe
<li>Care ROBERTSON: Head of Props
<li>Camie KOO: Production Assistant
<li>Andrea BAGGS: Stage Manager
<li>Ellen AHN: Assistant Director
</ul>

>*Charlotte: A Tri-Coloured Play with Music* plays June 16-18 at The Theatre Centre, 1115 Queen St. W. For details and tickets, [click here.](https://luminatofestival.com/2017/Events/Charlotte-A-Tri-Coloured-Play-with-Music)