+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T20:26:00-04:00"
lastmod = "2015-04-10T20:26:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428711874026/IMG_20150409_115917.jpg.jpg"
publishDate = "2015-04-09T15:26:00-04:00"
related_articles = ["articles/in-review-quinn-kelseys-songs-from-the-heart.md","articles/opera-for-lunch-the-roh-young-artists-in-concert.md","articles/meeting-for-lunch-the-coc-ensemble-studio-in-recital.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/gordon-bintner.md","scene/people/andrew-haji.md","scene/people/liz-upchurch.md"]
short_description = "Review of COC Ensemble Studio members Gordon Bintner, Andrew Haji, and Jennifer Szeto, with Head of the Ensemble Studio, Liz Upchuch, in recital at the Richard Bradshaw Amphitheatre, April 9, 2015."
slug = "lieder-for-lunch-the-coc-ensemble-studio-in-recital"
title = "Lieder for Lunch: the COC Ensemble Studio in Recital"
+++

<p>
	Today at noon, a few members of the <a href="http://www.coc.ca/AboutTheCOC/CompanyMembers/EnsembleStudio.aspx" target="_blank" data-mce-href="http://www.coc.ca/AboutTheCOC/CompanyMembers/EnsembleStudio.aspx">Canadian Opera Company Ensemble Studio</a> gave a concert in the Richard Bradshaw Amphitheatre, as part of the <a href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx" target="_blank" data-mce-href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx">Free Concert Series</a> (which you should all get to know). The theme was "Poetic Love," and the programming wasted no time getting to the point. Baritone <a href="http://www.ariamanagement.com/en/nos-artistes/gordon-bintner-w/" target="_blank" data-mce-href="http://www.ariamanagement.com/en/nos-artistes/gordon-bintner-w/">Gordon Bintner</a> and pianist <a href="https://twitter.com/szetojenn" target="_blank" data-mce-href="https://twitter.com/szetojenn">Jennifer Szeto</a> gave us selections of Schubert's <em>Schwanengesang</em>, focusing on the six songs with texts by Heinrich Heine. Following that were tenor <a href="http://www.andrewhaji.com/" target="_blank" data-mce-href="http://www.andrewhaji.com/">Andrew Haji</a> and Head of the Ensemble Studio, <a href="http://schmopera.com/how-to-be-a-coach-with-liz-upchurch/" target="_blank" data-mce-href="/how-to-be-a-coach-with-liz-upchurch/">Liz Upchurch</a>, performing Schumann and Heine's incredible cycle, <em>Dichterliebe</em>. As many music lovers probably do, I have a weak spot for Schumann's story of love and all its forms: new, passionate, unrequited, lost, maybe imaginary. Despite having less of a visceral connection to Schubert's set, I had a feeling that the entire concert would be a winning combination of artists and repertoire, and I was right.
</p>
<p>
	Gordon sang with fantastic energy and attention to detail. He has a hugely expressive face when he sings, and it helped to draw the audience into each song's world. I realized it had been a while since I heard Gordon in an intimate, recital setting like in the Amphitheatre. Impressively, he brought all the commitment and storytelling stage presence of his work on the larger stage to this small set of songs. It was as if Gordon was delivering a more subtle version of his opera-self, but he never stopped using his voice as his primary tool. At the piano, Jennifer Szeto played with sensitivity and lots of thought to the quality of her sound. She fed off of Gordon's endless energy, even in songs like "Der Doppelgänger," where the piano part is nothing but solid chords separated by unnerving amounts of time. I thought it was a really polished performance from both of them.
</p>
<p>
	Liz Upchurch prefaced her and Andrew Haji's <em>Dichterliebe</em> with a short dedication to the late <a href="http://www.nytimes.com/2012/05/19/arts/music/dietrich-fischer-dieskau-german-baritone-dies-at-86.html" target="_blank" data-mce-href="http://www.nytimes.com/2012/05/19/arts/music/dietrich-fischer-dieskau-german-baritone-dies-at-86.html">Dietrich Fischer-Dieskau</a>. I was reminded of Fischer-Dieskau's singing of this set, and all the risks he took to tell the story. If I had any preferences for a specific version of <em>Dichterliebe</em>, they were gone as soon as Haji started to sing. His voice sounded flexible and easy throughout, and most importantly, he sang with an honest sound; I think it was the honesty that made it so easy for me to listen to this set (that I know well) with new ears. Haji managed that rare singer's feat of forgetting about the singing, so we could simply watch these scenes unfold. <em>Dichterliebe</em> always plays in my head like an old film, with the transitions from song to song (or scene to scene) being the most difficult part. He spoke each word as though it were happening to him at that moment, and did a really beautiful job of finding his own dramatic transition between songs. Whatever Haji was thinking about during that gorgeous final piano postlude, it was stunning to watch.
</p>
<p>
	If that weren't enough, Liz Upchurch at the piano was a complete treat to hear. She played so thoughtfully, and with such a huge palate of sound colours, that she too brought out new parts of <em>Dichterliebe</em> and said new things about the story. Speaking of the gorgeous piano postlude, the <em>happiness</em> she brought to that music...right in the heart, Liz.
</p>
<p>
	So, a dreary day in Toronto, but another beautiful concert by these artists. If you're not familiar with the Free Concert Series in the Richard Bradshaw Amphitheatre, get up to speed<a href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx" target="_blank" data-mce-href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx"> right here</a>. You can catch the COC Ensemble Studio next in the RBA on <a href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries/April.aspx" target="_blank" data-mce-href="http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries/April.aspx">April 28th at noon</a>, where they'll present highlights from <em>The Barber of Seville</em>, as a preview for their <a href="http://www.coc.ca/PerformancesAndTickets/1415Season/BarberofSeville/EnsembleStudioPerformance.aspx" target="_blank" data-mce-href="http://www.coc.ca/PerformancesAndTickets/1415Season/BarberofSeville/EnsembleStudioPerformance.aspx">mainstage performance on May 15th</a>.
</p>
