+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-10T22:41:00-04:00"
lastmod = "2015-04-12T19:37:00-04:00"
preamble = "Canadian conductor [Leslie Dala](http://www.domoneyartists.com/Conductors/Dala_Bio/Dala_Bio/dala_bio.html) is currently in Toronto to lead two casts of students at the University of Toronto in their upcoming production of Dominick Argento's [_Postcard from Morocco_](http://uoftopera.ca/?page_id=566). Dala is a busy guy, as Music Director of the [Vancouver Bach Choir](http://www.vancouverbachchoir.com/), Principal Conductor of the [Vancouver Academy of Music](http://vancouveracademyofmusic.com/), and Associate Conductor and Chorus Master of [Vancouver Opera](http://www.vancouveropera.ca/). I hopped on the phone with him this week to ask him about all of the different hats he wears at work."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428719995735/LeslieDala.jpg.jpg"
publishDate = "2015-03-12T10:41:00-04:00"
related_companies = ["scene/companies/university-of-toronto-opera.md","scene/companies/soundstreams.md","scene/companies/vancouver-opera.md"]
related_people = ["scene/people/leslie-dala.md","scene/people/adrianne-pieczonka.md"]
short_description = "Canadian conductor Leslie Dala is currently in Toronto to lead two casts of students at the University of Toronto in their upcoming production of Dominick Argento’s Postcard from Morocco. Dala is a busy guy, as Music Director of the Vancouver Bach Choir, Principal Conductor of the Vancouver Academy of Music, and Associate Conductor and Chorus Master of Vancouver Opera. I hopped on the phone with him this week to ask him about all of the different hats he wears at work."
slug = "leslie-dala-on-postcard-from-morocco-julie-and-his-conducting-bucket-list"
title = "Leslie Dala, on Postcard from Morocco, Julie, and His Conducting Bucket List"
+++

When it comes to conducting a staged work like opera, the distance is probably the most problematic element. "They can't really hear each other," says Dala. "You're just trying to bring together invisible forces." I asked him about working with the two casts of [UofT Opera's _Postcard from Morocco_](http://uoftopera.ca/?page_id=566), and what it's like for him to collaborate with singers in the early stages of their professional careers. 

"I think the main thing is to always just set the bar as high as possible, so that people know what that bar is and that you can accomplish it. I can say, for example, with _Postcard_, it's a very challenging score. It's a very unusual score. I've done a lot of new music, and I love doing it, and there are some pieces that sort of fall into a category or another. I would say that _Postcard_ kind of defies [that]; and I mean musically, it has a certain sensibility, in terms of structure, in terms of the way [Argento] keeps flipping in and out of individual sound worlds to suit the story. It's really quite unlike any other piece that I've ever done. So, the amount of preparation that I'm sure all of these guys did in the fall to get ready for this was huge. So the first day of rehearsals, it was already in quite good shape. And then there are, of course, things to polish. 

"It's absolutely comparable to a professional production. I mean, some of the voices are young, and maybe not as far along as they will be in a few years, and that kind of things. But from the approach, from knowing music, from what they're doing onstage, it's been a fantastic journey in quite a short amount of time." 

Dala has a great understanding of what goes into a young singer's training process. "For what singers have to do, I have so much respect. Because it's not, you know, just singing, it's _living text_. Last week I went to a couple of the concerts at the TSO, and Barbara Hannigan, for example, was like a masterclass on how to inhibit, how to live inside of a text, and be able to deliver it. It's extraordinary, and that's the kind of thing that I think everybody should aspire to with the repertoire. I went to school with [Barbara] and I remember when she started doing all kinds of premières of everybody's music, and there was a journey there as well. So time and experience and hard work and that kind of devotion to one's craft; it just takes time." 

Toronto is also home for more exciting projects for Dala later this year. In November, he'll conduct the North American première of Philippe Boesmans' opera, [_Julie_](http://www.soundstreams.ca/Julie), presented by [Soundstreams](http://www.soundstreams.ca/Julie). "The music, it's really intense, almost claustrophobic score.", says Dala. "It's a very taut piece, in some ways not unlike _Written on Skin_. In one act, continuous, about 75 minutes long, three characters only, based on Strindberg's [_Miss Julie_](http://en.wikipedia.org/wiki/Miss_Julie), which in his day was such a revolutionary play." 

In setting the _Julie_ libretto by Luc Bondy and Marie-Louise Bischofberger, "Boesmans really does inhabit his own sound world," says Dala. "I have so much admiration for people who can stare at a blank page and fill it with something. And the more they do it, in certain cases, the really outstanding ones do manage to find, even in this day and age, where it's such a pluralistic society when it comes to music, a way of sounding like themselves and having their own individual voices." 

Also with [Soundstreams](http://www.soundstreams.ca/Adrianne-Pieczonka), Dala will conduct their season opening concert in September, featuring the fab singers like Adrianne Pieczonka and Krisztina Szabó. "Apparently it was one of the first professional gigs \[Adrienne\] had when she was graduating…was Soundstreams, back in the late 80s. So it's kind of a homecoming for that piece; I know they're just thrilled that she agreed to do this, and I was very happy that they asked me." Adrianne will sing the amazing (amazing!) _Ancient Voices of Children_, by George Crumb, as part of a [juicy-looking programme](http://www.soundstreams.ca/Adrianne-Pieczonka). 

Not one to neglect his symphonic work, Dala will be a guest conductor with the [Thunder Bay Symphony Orchestra](http://tbso.ca/) in 2016\. He'll conduct a "more traditional programme", which includes the overture to Gluck's _Alceste_, Edvard Grieg's Piano Concerto in A Minor (with soloist [Katherine Chi](http://www.katherinechi.com/)), and Schumann's Symphony no. 2\. "I was really pleased, I was actually given the chance to weigh in on the programming. [The Grieg] will be great, I mean that's such a warhorse, but the administration wanted to find a program that wasn't just all warhorses. The Schumann symphonies are really such powerful and beautiful pieces, but they are not over-programmed, I'll put it that way. They're very rarely done. I've conducted the first one, and I've worked on the fourth one. The second one was written in a really fertile time in Schumann's life. I think he was suffering from some form of depression which is what took him later on, this is still in the earlier stages. And then he wrote this piece as a sort of therapy, and it just bubbles forth; it has such incredible energy and dynamism, and one of the most stunningly beautiful slow movements of any symphony by anybody, I think." 

I couldn't help but ask Dala if there were any pieces outstanding on his to-do list. "For highlights, I'd say _Wozzeck_ of Berg, _Pelléas_, _A Midsummer Night's Dream_ of Britten. And then things like the Bartók Concerto for Orchestra, the Verdi _Requiem_, and Beethoven's _Missa Solemnis_. I'm hoping within the next few years, certainly the last two will be realized." Not a bad list, I told him. 

[_Postcard from Morocco_](http://uoftopera.ca/?page_id=566) runs at UofT Opera March 12-15 at the MacMillan Theatre, Edward Johnson Building, 80 Queen's Park. For more info and to purchase tickets, write to info@uoftopera.ca, or call 416-978-3740.
