+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2019-04-07T00:27:07+00:00"
disclaimer = ""
image_gallery = []
postamble = "_Les enfants terribles_ runs at Opera Omaha through April 14. For details and ticket information, [click here](https://www.operaomaha.org/season-tickets/current-season/2018-2019-season/les-enfants-terribles)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1554772073/media/2019/04/sqDSC05604.jpg"
primary_image_credit = "Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen."
related_articles = []
related_companies = ["scene/companies/opera-omaha.md"]
related_people = ["scene/people/theo-hoffman.md", "scene/people/naomi-louisa-o-connell.md", "scene/people/vanessa-becerra.md", "scene/people/adrian-kramer.md"]
short_description = "The dynamics between the siblings made me uncomfortable in a variety of ways. There were sexual undertones spliced in with disturbingly infantile antics. Clearly everyone in this opera needed to go to therapy."
slug = "disturbing-fascinating-les-enfants-terribles-in-omaha"
title = "Disturbing & fascinating: Les enfants terribles in Omaha"
youtube_url = ""

+++
Opera Omaha's production of _Les enfants terribles_ is a strange and mesmerizing exploration of dissociation and escapism. There are no certainties - only abstract visuals, raw emotions, and atmospheric music. Philip Glass' opera, based on the novel by Jean Cocteau, triggers reactions that are powerful but hard to understand. The more I tried to wrap my brain around the piece the more confused I became. The music and the story refuse to be defined. All the audience can do is surrender to the transient emotions without over analyzing - a feat that is easier said than done.

The story centers around siblings Paul and Elisabeth and their private, fantasy world. The plot is a bit confusing, so feel free to read the [full synopsis here](https://operaamerica.org/applications/NAWD/newworks/details.aspx?id=1141) before proceeding.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772208/media/2019/04/DSC05177.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

The set designed by Yuki Izumihara made an intriguing first impression. The stark white stage felt both minimal and grand, providing a sterile backdrop for the performers. Troughs of colorless trash lined the edges of the platform, creating a barricade between the siblings' private world and reality.

The blank backdrop in combination with D.M. Wood's dynamic lighting design created some striking visuals. The production's use of shadow was reminiscent of the children playing shadow puppets in their room, using their imagination to insulate themselves from the outside world. This visual was most effective in the beautifully choreographed scene between Elisabeth and the two female dancers. It was a rare moment of vulnerability for the character, her emotions laid bare in bright light rather than the usual hazy glow. In a production that often felt murky and mysterious, the lighting drew attention to specific plot points and musical moments, guiding the overstimulated audience when necessary.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772223/media/2019/04/DSC05243.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

Costume designer Camille Assaf used color to create dramatic focal points and emphasize the characters' varying emotional states. In the opening choreography, Dargelos is wearing a forest green suit which stands out like a beacon against the neutral whites and grays around him. The audience cannot take their eyes off him, so it is easy to understand Paul's obsession with him. Similarly, Elisabeth's outfits are chosen with her specific agenda in mind. She wears white when she wants to appear innocent. She wears vibrant colors when she wants to manipulate or seduce. Gerard stands out because he is always wearing traditional, structured menswear in a sea of more flowing, eclectic costumes around him.

> The fluid movements matched Glass minimalist themes, and the dances felt fully incorporated into the story, not just plopped into the scenes as can sometimes be the case.

Agathe's clothing also sets her apart from the siblings, often wearing more saturated, dark colors. Her resemblance to Dargelos is highlighted by her menswear inspired outfits, androgynous and bold. Paul's mental state is also depicted through his clothing. After his childhood injury, he appears to swear off pants for life, because he is perpetually wandering their home in boxers and flowing robes from that moment onwards. Designer Assaf exposes Paul's body and hides it at the same time, demonstrating his vulnerability and dramatic coping mechanisms with a few simple garments. Also impressive were the costume changes performed onstage with the assistance of the dancers. There were numerous moments when I suddenly realized that someone's outfit was different and wondered when the heck that happened. The magic of clever choreography.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772238/media/2019/04/DSC05500.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

Conductor David Bloom and the three pianists created an enigmatic and cinematic vibe through Glass minimalist score. While the opera is broken into short scenes, the music felt continuous and cyclical in nature. If you are looking for expansive melodic lines, then this is not the opera for you. The narration is in English while the vocal text is French. This contrast emphasized the opposing forces of the siblings' dreamscape and the solidity of the outside world. Glass' musical palette felt appropriately intimate and French, a constant ebb and flow of building tension and unattainable release. Even the disturbing end scene lacked a definitive climax, cutting to darkness before we see the implied violent act.

The cast is small with only four singers and four dancers (although only three of the dancers, Shauna Davis, Lindsey Matheis, and Charbel Rohayem, were able to perform opening night). The opera is a relatively balanced combination of vocal and instrumental scenes, so the choreography by Gustavo Ramirez Sansano/TITOYAYA played a vital role in bringing the repetitive, cyclical interludes to life. The fluid movements matched Glass minimalist themes, and the dances felt fully incorporated into the story, not just plopped into the scenes as can sometimes be the case.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772251/media/2019/04/DSC05831.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

I will admit that I found some of director James Darah's staging to be distracting, such as the decision to have the dancers chuck trash all over the stage during a narration sequence. But other moments were strangely effective, like the rolling dozens of billiard balls around the singers as the narrator referenced the sound in Elisabeth's dream. In general, the production teetered on the border of "too artsy" for most of the performance, and while I am more accepting of this than others, I felt like it went over the edge even for my tastes a few times. I think there were just too many elements that were confusing for the audience, and something had to give. The plot was hard to follow, and if I hadn't read the synopsis, I would have no idea what was going on. "The Game" was referenced a lot, but it didn't seem like we ever saw the siblings actually play it. The music was beautiful but aimless, and the staging was a bit intellectual. I can easily imagine that the average audience member would find this combination intimidating and overwhelming.

> I couldn't decide whether Elisabeth was a full on sociopath or just your run of the mill narcissist.

All four singers put on an impressive display of nuanced acting and vocal performances. This story is 90% subtext which must be daunting to convey. [Adrian Kramer](/scene/people/adrian-kramer/) played the role of Gerard and the Narrator. Gerard visits the siblings' private world, but he is not part of it. Kramer's voice stuck out in the subtle sound plane of his counterparts, his bolder tone cutting through Glass murky orchestration in a manner that was at times stabilizing and other times jarring. Gerard looked straight-laced and stiff compared to his friends, but he is drawn to them because they are so otherworldly. The plot stated that he was in love with Elisabeth, but it often felt like he was equally enamoured of Paul. Everything about this production felt fluid. Sexuality and gender were changeable and irrelevant. None of the characters were concerned with defining these things, only experiencing each other.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772270/media/2019/04/DSC06342.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

[Naomi Louisa O'Connell](/scene/people/naomi-louisa-oconnell/) epitomized this fluidity in her performance as Dargelos and Agathe. The mezzo soprano's vocal tone was dark enough to pull off both the female and male roles, and she was serving serious, androgynous Miranda from _Sex and the City_ vibes with her red hair and power stance. O’Connell played Dargelos with a cold demeanor that had me hooked into the story immediately. Her portrayal of Agathe was softer but equally captivating. Agathe is the sole voice of reason at the end of the opera, but her attempt to cut through the emotionally destructive bullshit comes too late.

The two sibling characters were much harder to pin down. [Vanessa Becerra](/scene/people/vanessa-becerra/) played the sister, Elisabeth, a role that is multifaceted vocally and dramatically. I couldn't decide whether Elisabeth was a full on sociopath or just your run of the mill narcissist. She doesn't seem to experience any genuine emotions aside from jealousy, and it was unclear what her motivations or ultimate goals were. Becerra switched between Elisabeth's various guises, making her tone clear and simple when the character wanted to appear innocent and bringing out a more sultry, rich tone when Elisabeth was in manipulation mode.

> It was a lot to process, and I felt like I had been ripped out of this fever dream with no warning.

[Theo Hoffman](/scene/people/theo-hoffman/) sang the role of the brother Paul. This character went through the most intense emotional journey in the opera, and Hoffman's performance put all of Paul's opposing mood swings on full display physically and vocally. Paul became more isolated and unstable as the story progressed, lashing out at others. His love for Agathe felt shallow, based entirely on her resemblance to Dargelos, and I found it laughable that he seemed to think that Agathe should reciprocate just because. I can picture him saying something like "How can she love Gerard when I've been nothing but a total asshole to her for months?" Agathe doesn't really love Gerard, but she definitely deserves better than Paul. Um...dude, you are a jerk to her and are too afraid to tell her how you feel so...what do you expect? Frustratingly enough, Agathe does love Paul for some inexplicable reason. Lack of communication strikes again, however, and they both play right into Elisabeth's mind games.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1554772285/media/2019/04/P1050819.jpg){{% /md %}}

<figcaption>Les enfants terribles, Opera Omaha, 2019. Photo: Adam Larsen.</figcaption>

</figure>

The dynamics between the siblings made me uncomfortable in a variety of ways. There were sexual undertones spliced in with disturbingly infantile antics. Clearly everyone in this opera needed to go to therapy. Elisabeth and Paul were ephemeral in a way that was fascinating and creepy. It was clear from the start that they were not meant to exist in the real world, but that did not prepare me for the brutality of the end result.

I could tell the audience was left shaken and confused by the abrupt ending. Were we supposed to clap? After a few moments of stunned silence, a brave soul started the applause. It was a lot to process, and I felt like I had been ripped out of this fever dream with no warning. The transition from unsettling nightmare scene to house lights up reality was a shock to the system. I may not fully understand the rules of "The Game" but even I know it is unforgivable to disturb a player once they have, in the siblings' terminology, "gone away." It's a blatant violation, but perhaps intentionally so. _Les Enfants Terribles_ is meant to be uncomfortable and unappealing on a certain level. How you cope with that fact is entirely up to you. You can embrace it or reject it, but you are still a player in "The Game" whether you like it or not.