+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2022-05-10T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_The White Cat_ streams on Marquee.TV through June 30. For more information on the opera, including excellent program notes, go to [LesDélices.org](https://www.lesdelices.org/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1652102052/media/2022/05/sqWhiteCat_6_gxwnwh.png"
primary_image_credit = "White Cat puppet (foreground), gambist Rebecca Reed (left) and oboist Kathryn Montoya in The White Cat, Les Délices, 2022. Photo: Erica Brenner."
related_articles = ["articles/les-delices-presents-song-of-orpheus-the-music-speaks-for-itself.md", "articles/les-delices-presents-women-of-genius-in-the-ancien-regime.md"]
related_companies = ["scene/companies/les-delices.md"]
related_people = []
short_description = "Julie Andrijeski and Shelby Yamin (violins), Kathryn Montoya and Nagy (oboes and recorders), Rebecca Reed (viola da gamba) and Mark Edwards (harpsichord) all wear cat masks, a simple and delightfully conspiratorial gesture. These cats know how to work it."
slug = "les-delices-streams-opera-pastiche-the-white-cat"
title = "Les Délices streams opera pastiche The White Cat"
youtube_url = ""

+++
[Les Délices](/scene/companies/les-delices/), that Cleveland-based standard bearer of French baroque music, continues to hone its ability to shed the genre's esoteric reputation and make it more accessible. With _The White Cat_, their new opera pastiche, (streaming on Marquee.TV through June 30) the company takes an ambitious step forward. It is looking for children, that audience of tomorrow, in addition to the baroque and not so baroque-minded adults who are steadily succumbing to its impressive programming.

Artistic Director Debra Nagy has created a charming and seamless score with selections drawn from François Couperin and Jean-Baptiste Lully among others and several folk songs of the era. Happily it doesn't come off like a "greatest hits" list of the French baroque, as if there was such a thing. It melds with the wise and refreshingly straightforward libretto by Larry Rosenwald, based on a 17th-century story by Marie-Catherine D'Aulnoy, itself drawing on the fables of Aesop.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652102544/media/2022/05/WhiteCat_madame-daulnoy_koeyp0.jpg){{% /md %}}

<figcaption>Portrait of Countess d'Aulnoy, old engraving, coloured in 19th century. Photo: public domain.</figcaption>  
</figure>

Aided by the directness and brevity of those pithy fables, _Cat_ follows the structure of a typical 17th century French opera in the _tragédie lyrique_ form, with a prologue and five parts, an adherence that purists will appreciate. D'Aulnoy wrote her story as a feminist response to the guile and mendacity of Charles Perrrault's late17th century _Il gatto con gli stivali_, a French retelling of the Italian _Puss in Boots_ fairy tale. Rosenwald's resulting libretto dovetails nicely with Les Délices' mission to recognize lesser known women artists of the baroque period. In the end it proffers the lesson that truth and generosity can triumph over Puss and his lot, even if a little magic must ensue.

While earning a well-deserved reputation for elegantly staged and beautifully performed thematic programming, Les Délices triumphed over the challenges of the pandemic with courage that matched the group's musical _élan_. Acting on its bold initiative to stream programs (when the pandemic made live audiences impossible) with prudent yet sophisticated production values, the group broadened its audience. While doing so it brought extraordinary vitality and a welcoming spirit to this rarified musical form.

> Tassi's images dissolved from one gorgeous setting into another with amazing subtlety.

So it is baffling that the puppets added to the mix don't wholly deliver. In all fairness the actual white cat might be more appealing to viewers seated no closer than mid orchestra. On screen there are moments when Erica Brenner's excellent video direction fleetingly captures an expressive pose. But cats are lithe and silent creatures. This one literally taps across the stage. So disconcerting was this, especially during the delicate prologue, it was reasonable to wonder if castanets had been added to the musical ensemble. (Note to puppet designer Ian Petroni: pad those paws.) And cats exhibit such attitude with their supple backs. But this one had a back as static as the kind of alluring look on its face. As for the King, with a large head on a depleted body, this puppet too benefited from the camera work but only when directly facing the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652102476/media/2022/05/WhiteCat_5_bel2hn.png){{% /md %}}

<figcaption>Tenor Jason McStoots and soprano Elena Mullins in in The White Cat, Les Délices, 2022. Photo: Erica Brenner.</figcaption>  
</figure>

Let me assure you gentle readers, that the production still succeeds and we are grateful for what amusement the puppets manage to bring. Their handlers, including soprano, Elena Mullins who is tasked with singing the cat in addition to moving it about the stage, give them a boost. They evoke a subtle sense of character with and without their own cat masks.

Nagy, as per usual, has assembled a first-rate group of musicians who carry the work with comedic and dramatic flourishes amidst an air of stateliness. Even though the music is steeped in formality there are stylistic challenges when moving from one composer to another that are smoothly met. Julie Andrijeski and Shelby Yamin (violins), Kathryn Montoya and Nagy (oboes and recorders), Rebecca Reed (viola da gamba) and Mark Edwards (harpsichord) all wear cat masks, a simple and delightfully conspiratorial gesture. These cats know how to work it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652102485/media/2022/05/WhiteCat_7_glaatd.png){{% /md %}}

<figcaption>Puppeteer Samara Steele and soprano Elena Mullins with the White Cat puppet in The White Cat, Les Délices, 2022. Photo: Erica Brenner.</figcaption>  
</figure>

Mullins, literally swimming in impressive performance and scholarly credentials, has a disarming purity of voice. She embodies the cat's winsome and mysterious nature not just with her voice but with the aforementioned handling of the cat puppet, a task shared with equal grace by puppeteer, Samara Steele. Their lovely if brief dance would have been enhanced with a dash more light from David Stoughton's otherwise atmospheric and responsive lighting.

Tenor, Jason McStoots, swims in the same exalted pool as Mullins and lends a smooth hand as _Cat_'s stage director. Singing the prince he calibrated his rich and commanding voice to the material capturing the robust nature turning to bewilderment. Both he and Mullins employed just the right amount of ornamentation to sustain baroque flavor while maintaining a swift pace.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652102461/media/2022/05/WhiteCat_4_zppwzk.png){{% /md %}}

<figcaption>Oboists Kathryn Montoya and Debra Nagy in The White Cat, Les Délices, 2022. Photo: Erica Brenner.</figcaption>  
</figure>

All of this talent is set against the backdrop of Camilla Tassi's remarkable projections. Suggesting Fragonard murals come to life, they add a luxurious depth to the staging. Tassi's images dissolved from one gorgeous setting into another with amazing subtlety. They even provide text guidance, in a period-appropriate font no less, as the story progresses.

Transformed from the puppet cat Mullins emerges as the perfect princess and all ends happily with the prince gaining insight through befuddlement. A few seconds of well-deserved curtain call would have been nice, for the musicians sans masks, along with Mullins and McStoots, yes and the puppets too. Thinking it over, the cat puppet was kind of endearing—when sitting still as cats like to do.