+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2021-03-31T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1617070930/media/2021/03/LesDelices-WOG-square_blke3i.png"
primary_image_credit = "Soprano Clara Rottsolk in Women of Genius, Les Délices, 2021. Video still courtesy of Les Délices."
related_articles = ["articles/overlapping-stories-fall-on-the-house-of-usher.md", "articles/amici-e-rivali-two-gentlemen-and-friendly-rivalry-in-verona.md", "articles/bewitched-by-les-delices-captivating-in-cleveland.md"]
related_companies = []
related_people = []
short_description = "The star of this particular show, composer Elisabeth Jacquet de la Guerre, was hardly left in the shadows. Having gained the support of Lous XIV, she was highly visible with frequent performance of her work. More importantly she enjoyed the rare privilege of having her work published."
slug = "les-delices-presents-women-of-genius-in-the-ancien-regime"
title = "Les Délices presents Women of Genius in the Ancien Régime"
youtube_url = ""

+++
Remember the [Ancien Régime](https://en.wikipedia.org/wiki/Ancien_R%C3%A9gime), that period of glittering royal splendor? It ran from the Late Middle Ages (circa 15th century) until 1789 when the French Revolution, to put it politely, abolished the monarchy and did away with the feudal system so enjoyed by the French nobility. It was also a time when the work of women artists was often left in the shadows. Were it not for Évrard Titon du Tillet, and the failure of his life goal to erect a memorial park to the greatest creative artists in France, they might have remained there.

When the park, with its curious mounds of sculpture, proved beyond his reach, he settled on the creation of _Le parnasse françois_, a biographical dictionary including not only the artistic titans of France but also those who by virtue of their gender might otherwise have remained unrecognized or only minimally noted. Fortunately for the general scope of music history and specifically the research of Les Délices director, Debra Nagy, _Le parnasse françois_ illuminates the path towards the creation of _Women of Genius_. The most recent offering from this stunning Cleveland based ensemble turns the limitations of pandemic performance into yet another adventurous and elegantly entertaining streaming concert.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1617070452/media/2021/03/LesDelices-Leparnassefrancois-PazzoBooks_usnhyz.jpg){{% /md %}}

<figcaption>The title page of Évrard Titon du Tillet's Le parnasse françois, with an extravagant mockup of the proposed sculpture garden that was abandoned by the author in favor of the biographical dictionary of France’s leading artists. Photo: Pazzo Books.</figcaption>  
</figure>

The star of this particular show, composer [Élisabeth Jacquet de la Guerre](https://en.wikipedia.org/wiki/%C3%89lisabeth_Jacquet_de_La_Guerre), was hardly left in the shadows. Having gained the support of Lous XIV, she was highly visible, with frequent performance of her work. More importantly she enjoyed the rare privilege of having her work published. But according to Nagy, de la Guerre was not the isolated genius she has been made out to be. Nagy bases her case on a roster of lesser-known women who follow de la Guerre’s mention in _Le parnasse françois_, each of whom exerted considerable cultural influence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1617070559/media/2021/03/LesDelices-JacquetdelaGuerre_xfkisi.jpg){{% /md %}}

<figcaption>Élisabeth Jacquet de la Guerre, composer  and harpsichordist (1665-1729).</figcaption>  
</figure>

Among them is the inventive composer [Mademoiselle Duval](https://en.wikipedia.org/wiki/Mlle_Duval), whose first name is lost to history. Her delightful suite from [_Les Génies ou Les Caractéres de l’Amour_](https://imslp.org/wiki/Les_G%C3%A9nies_ou_Les_Caract%C3%A8res_de_l'amour_(Duval%2C_Mademoiselle)) is by turns courtly and vibrant, offering opportunity for the ensemble to exert their instrumental and interactive prowess. [Julie Pinel](https://en.wikipedia.org/wiki/Julie_Pinel)'s subtly seductive airs receive sensitive vocal and instrumental outings. And the poet [Marie de Louvencourt](https://fr.wikipedia.org/wiki/Marie_de_Louvencourt), who supplied the music for many of the compositions by Louis-Nicolas Clérambault, also receives long overdue recognition with her stellar account of his Prelude from Leandre et Héro which goes on to include text by de Louvencourt. Perhaps this is the baroque equivalent of a Stephen Sondheim song without the lyrics, but Nagy's oboe-playing amidst the ensemble is a particularly spirited and wistful pleasure, that hints at Louvencourt's poetry to come.

The inclusion of two men from the Couperin family dynasty strains Nagy’s premise a bit but their works are nonetheless lovely to hear. François (le Grand) Couperin's _La Favorite_ is played with verve and freshness by harpsichordist Mark Edwards, who explains the uniqueness of the piece in a clear and engaging manner. Louis Couperin's _Veritas de terra_, his setting of Psalm 84, provides an occasion for Nagy’s invitation to imagine the "brilliant and flexible" voice of Marguerite Louise Couperin, who was also a celebrated harpsichordist. Perhaps more to the point we admire the vibrant soprano Clara Rottsolk and her exquisite technique both here and with Pinel's evocative airs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1617071135/media/2021/03/2_hw5iml.png){{% /md %}}

<figcaption>(l-r) Rebecca Reed (viola da gamba), soprano Clara Ruttsolk, Mark Edwards (harpsichord) and Debra Nagy (oboe) in Women of Genius, Les Délices, 2021. Video still courtesy of Les Délices.</figcaption>

</figure>

Befitting her exalted position in the latter stages of the _Ancien Régime_, de la Guerre takes center stage with her Violin Sonata in F and the concluding work, which is actually the program's centerpiece, the cantata _Judith_. The violin sonata, clearly a work of Italianate influence, eschews the dance rhythms of the day for innovative instrumental interaction and expression. Edwards and violinist Julie Andrijeski communicate with palpable enthusiasm while Rebecca Reed on _viola da gamba_ provides refined underpinning. If anything unites de la Guerre's two works, it is their clarity of expression and energy.

_Judith_ is based more on legend than history. As a cantata, it relies on instrumental accompaniment and independent segments that give voice and depth to its heroine and other characters, despite a text that lacks dramatic action. In fact, the work's most physical act - the beheading of the invading Syrian King Holofernes - is carried out by the violin. The music is stark, even furious in its depiction of Holofernes, and turns inward as it depicts Judith's inner conflicts and the urging of her handmaid Abra, to take the action - both personal and violent - that will save Israel. Finally, it celebrates Judith's sacrifice and triumph. It would be difficult to imagine a more lucid reading of the work. Rottsolk doesn’t relinquish attitude for beautiful singing. The soprano's gleaming upper register and assured ornamentation contribute to dramatically defined characters. Her opening remarks were as fervent and suggestive of character as they were instructive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1617071165/media/2021/03/5_v3fzv5.png){{% /md %}}

<figcaption>(l-r) Violinist Julie Andrijeski and soprano Clara Rottsolk in Women of Genius, Les Délices, 2021. Video still courtesy of Les Délices.</figcaption>

</figure>

Those who haven’t already are advised to view the pre-concert talk with Nagy and Dr. Eve Straussman-Pflanzer, curator of Italian and Spanish painting at the National Gallery in Washington D.C., in order to more fully experience the nuances of the cantata. Four paintings dealing with Judith are discussed, including one by Caravaggio and another by Artemsia Gentileschi mirroring the vastly different takes on the Judith legend. They literally illustrate the situations and characters depicted in de la Guerre’s cantata. Note that Straussman-Pflanzer is organizing an exhibition on Gentileschi and women artists in Italy from 1500-1800 for the Detroit Institute of Arts early next year. The pre-concert talk is readily available at [Lesdelices.org](https://www.lesdelices.org/watch-now/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1617071177/media/2021/03/1_yyng3m.png){{% /md %}}

<figcaption>Soprano Clara Ruttsolk and oboist Debra Nagy in Women of Genius, Les Délices, 2021. Video still courtesy of Les Délices.</figcaption>

</figure>

Musically remarkable as _Women of Genius_ is, the production value continues to enthrall. While the lighting hardly needed improvement, the dramatically placed spots on the walls and the backlighting of performers amidst the Georgian Colonial architecture of the Plymouth Church was compelling. Fresh camera angles that at moments suggested a _tableau vivant_ and overhead shots of the harpsichord were welcome additions. The passage from day to night, at which point _Judith_ is performed, harnessed nature for ultimate effect. Nagy’s team, with its combination of scholarship, fascinating music skillfully performed, and mesmeric technical production, is in itself a thing of streaming genius.