+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2021-10-22T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "À-la-carte access to _Song of Orpheus_ and other Les Délices concerts are available through [Marquee TV](https://www.marquee.tv/series/lesdelices) for $24.99. Subscription packages and more information are [available here](https://www.lesdelices.org/subscription-packages/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1634857406/media/2021/10/sqOrpheus_woyyrk.jpg"
primary_image_credit = "Shelby Yaman, violinist, in Les Délices's production of Song of Orpheus, 2021. Photo: Erica Brenner."
related_articles = ["articles/les-delices-presents-women-of-genius-in-the-ancien-regime.md", "articles/ravishing-orphic-moments-with-gluck-aucoin-costanzo.md"]
related_companies = []
related_people = ["scene/people/hannah-de-priest.md"]
short_description = "The music is beautiful and speaks for itself. French Baroque rarities by Rameau, Dandrieu and Courbois dance with subdued, exuberant and often tremulous elegance around the legend of Orpheus and Eurydice. "
slug = "les-delices-presents-song-of-orpheus-the-music-speaks-for-itself"
title = "Les Délices presents Song of Orpheus: The Music Speaks For Itself"
youtube_url = ""

+++
_Song of Orpheus_ is the newest steaming program by the Cleveland-based [Les Délices](https://www.lesdelices.org/). It revels in the enduring myth, one that continues to be visited over the centuries by composers across the musical spectrum. The music is beautiful and speaks for itself. French Baroque rarities by Rameau, Dandrieu and Courbois dance with subdued, exuberant and often tremulous elegance around the legend of Orpheus and Eurydice.

The program opens with a new, yes new, trio sonata "By much love betray'd" by composer Jonathan Woody, its title derived from John Dryden's translation of Virgil's _Georgics_. Seeped in the baroque tradition, it is essentially a tone poem in three-parts, a work clearly evoking the pivotal moments in the life of Orpheus: receiving the lyre from Apollo, his fateful turn to gaze upon Eurydice in the underworld and finally his death by the Maenads. On-screen titles for each part make it easy to follow.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1634857454/media/2021/10/Orpheus_LesDelices_wx1zqc.jpg){{% /md %}}

<figcaption>Les Délices. Viola de gambist Rebecca Reed, harpsichordist Mark Edwards-harpsicord, violinist Shelby Yamin, Artistic Director and baroque oboist Debra Nagy and soprano Hanna De Priest performing Rameau’s Orfée. Photo: Erica Brenner.</figcaption>  
</figure>

It's a lovely and stirring composition that showcases the high level of music making common to the players. Woody's introduction, though eloquent, invites distraction and would have been better utilized as program notes.

[Hannah De Priest](/scene/people/hannah-de-priest/) is utterly beguiling singing Rameau’s "Orphée". The soprano's creamy sound is impressively clear with ornamentation scaled to the intimacy of the piece. Without a moment of fussiness in her approach, there is only lovely singing and emotional insight. In addition to her vocal gifts, De Priest delivers the news with aplomb. Her brief comments remind us of the universality and overriding irony of the legend. She increases our anticipation of the work reminding us that in matters of love timing is everything.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1634857480/media/2021/10/Orpheus_DePriest_gvclbl.jpg){{% /md %}}

<figcaption>Hannah De Priest, soprano and Jonathan Woody, baritone and composer, in Les Délices's production of Song of Orpheus, 2021. Photo: Erica Brenner.</figcaption></figure>

Dandrieu's arresting "La lyre d'Orphée," is a solo for harpsichord portraying the sound of a lyre. Mark Edwards is tasked with playing one instrument to represent another at a moment of despair. He succeeds brilliantly with a deft and sensitive touch that transcends the harpsichord and evokes that luminous sound of the lyre. While at first blush the work may seem arcane, Edwards' take is fresh and humane, as if Orpheus is pleading with us via his lyre.

Jonathan Woody, this time a commanding baritone, sings Courbois' "Orphée" with a smooth and dignified reserve that nonetheless conveys Orpheus' pride, or perhaps his ego, even as Eurydice is lost and he faces death. Composer and singer, this gifted artist is also an effective actor. Essentially a mellifluous and melancholy monologue, it calls upon the musicians to once again create atmosphere, indeed a musical dialogue completing the musical picture that they and Woody so vividly create.

> Their creative energy and growth, especially in these challenging times, remind us that the artistic spirit is alive and well.

Woody, De Priest, and Edwards along with artistic director Debra Nagy on baroque oboe, Shelby Yamin on violin and Rebecca Reed on viola de gamba, form an extraordinary ensemble. Les Délices produces thoughtful and satisfying music that makes the rare not only familiar but welcome. Their creative energy and growth, especially in these challenging times, remind us that the artistic spirit is alive and well.

But like Woody’s introduction to his "By much love betray'd," Nagy's preface to the season and introduction would have better served _Song of Orpheus_ as program notes made available in advance to viewers. A bit of context however, before the program, placing these rarities in the realm of influential forerunners, might have made their place in music history more relatable and recognized their currency in the twenty-first century.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1634857520/media/2021/10/Orpheus_DePriest_Edwards_jmiv0d.jpg){{% /md %}}

<figcaption>Harpsichordist .Mark Edwards and soprano Hannah De Priest, in Les Délices's production of Song of Orpheus, 2021. Photo: Erica Brenner.</figcaption></figure>

With Monteverdi, Gluck and Berlioz giving it a go and the film _Black Orpheus_ set in a favela above Rio de Janeiro, there's much to talk about. Currently the myth resides in the Broadway musical _Hadestown_ set in New Orleans and next month the Matthew Aucoin/Sarah Ruhl opera _Eurydice_ opens at the MET, telling the story from her point of view.

Of course there's Aucoin's ["Orphic Moments"](/ravishing-orphic-moments-with-gluck-aucoin-costanzo/), a contemporary sonata which transforms Orpheus' fateful turn towards Eurydice from an act of uncontrollable passion into one of artistic opportunism and unmitigated ego. The mere mention of Aucoin's sonata gives the myth quite a jolt.