+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2018-04-30T17:46:00-04:00"
lastmod = "2018-04-30T21:41:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124778173/sqIsabelLeonardRosinaTenorTaylorStaytonCountAlmavivainWNOTheBarberofSeville_creditScottSuchman.jpg.jpg"
primary_image_credit = "Isabel Leonard (Rosina) and Taylor Stayton (Almaviva) in The Barber of Seville, WNO, 2018. Photo: Scott Suchman."
publishDate = "2018-04-30T21:41:00-04:00"
related_articles = ["articles/in-review-the-barber-of-seville-at-roh.md"]
related_people = ["scene/people/isabel-leonard.md","scene/people/andrey-zhilikhovsky.md","scene/people/taylor-stayton.md","scene/people/paolo-bordogna.md","scene/people/wei-wu.md"]
short_description = "Leonard&#039;s voice is smooth and dark, but simultaneously buoyant and splendidly agile; she is perfectly suited to Rossini, and she appears to love it. If only the staging used her better!  She subtly pulled off one of the funniest moments of the evening as she began the cabaletta while genteelly practicing her needlepoint as she sings about being a sweet, obedient young lady, but once she arrives at the all important &quot;ma...&quot; sings &quot;ma se mi toccano dov&#039;è il mio debole&quot; through gritted teeth as she aggressively stabs the sampler with her needle, while the audience roars with laughter."
slug = "leonard-reigns-as-rosina-in-wnos-barber"
title = "Leonard reigns as Rosina in WNO&#039;s Barber"
+++

As the lights came up to signal intermission after the first half of [*The Barber of Seville*](http://www.kennedy-center.org/calendar/event/OSOSE) presented by Washingtion National Opera on Saturday evening, I turned to my companion and asked, "what did I just watch?"  

The question was in response to director Peter Kazaras' bumbling, incoherent staging of Rossini's comic masterpiece, whose first act finale was manic, purposeless, and overlong.  A recommendation to opera directors: you do not have to take all the repeats if you don't have enough staging ideas to fill them.

With the Bernstein Centennial being a big story in the music world currently, WNO is focusing much of its attention on a production of *Candide*, which opens next week, and it makes this *Barber* production feel like a bit of an afterthought, which is a shame, since a well-executed *Barber* would make the perfect vehicle to fill a slot in the season on a shoestring budget. 

The performance begins promisingly enough, with its famous overture conducted confidently and steadily, if a bit understatedly, by Emily Senturia, who keeps tempos appropriately snappy throughout the evening. Under Senturia's baton, the orchestra never becomes overbearing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124365297/AndreyZhilikhovskyFigaroTaylorStaytonAlmavivaIsabelLeonardRosinainWNOsBarberofSeville_creditScottSuchman.jpg.jpg)
<figcaption>Andrey Zhilikhovsky (Figaro) Taylor Stayton (Almaviva) and Isabel Leonard (Rosina) in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

The stage is set with a false proscenium made to mimic the style of an old world opera house, complete with three chandeliers which are raised along with the curtain at the opening of the opera, to reveal a quiet Seville street corner rendered as if it were in the pages of an illustrated storybook, and a band of musicians gathering to accompany the lovesick Count Almaviva's serenade. Unfortunately, in the role of Almaviva, [Taylor Stayton](/scene/people/taylor-stayton/) sings with a thin, slightly anemic voice, and seems somewhat timid in his first aria, and even downright frightened of the high C in his cadenza. However, later in the scene, his performance in the arietta "Ebben proviamo", accompanied only by an onstage guitar, is sung simply and compellingly, leading me to wonder if perhaps Stayton is more at home in the recital hall than the opera stage. But at least he is charming in the role, making it easy to root for him to win Rosina's affections.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124396950/AndreyZhilikhovskyFigaroTaylorStaytonAlmavivaIsabelLeonardRosinaforWNOsBarberofSeville_creditScottSuchman.jpg.jpg)
<figcaption>Andrey Zhilikhovsky (Figaro) Taylor Stayton (Almaviva) and Isabel Leonard (Rosina) in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

As the wily, titular Barber Figaro, [Andrey Zhilikhovsky](/scene/people/andrey-zhilikhovsky/) offers a playful and charming presence to make up for his brutish, barking vocals.  After strangely making his first entrance from the back of the house, a directorial move that I associate with high school and community theater productions, his performance of the notoriously difficult "Largo al factotum", is entertaining but, like many baritones who perform this role, sacrifices vocal precision for silly gags. Please don't misunderstand me: if there's a place for silly singing in opera it is absolutely in this aria, but too often it can serve to cover over imprecise technique. Zhilikhovsky did, however, impressively barrel through Rossini's tongue-twisters at breakneck speed without missing a single letter.

It's a relief when [Isabel Leonard](/scene/people/isabel-leonard/) makes her entrance and sings her first showstopping aria, "Una voce poco fa".  Leonard's voice is smooth and dark, but simultaneously buoyant and splendidly agile; she is perfectly suited to Rossini, and she appears to love it. If only the staging used her better!  She subtly pulled off one of the funniest moments of the evening as she began the cabaletta while genteelly practicing her needlepoint as she sings about being a sweet, obedient young lady, but once she arrives at the all important "ma..." sings "ma se mi toccano dov'è il mio debole" through gritted teeth as she aggressively stabs the sampler with her needle, while the audience roars with laughter. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124407706/IsabelLeonardinWNOsTheBarberofSeville_creditScottSuchman.jpg.jpg)
<figcaption>Isabel Leonard (Rosina) in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

Rosina sings about having a hundred tricks up her sleeve, but Kazaras, it seemed, only managed to think of one: to use a chair to block the door to her parlor, and once it is in place, Leonard doesn't seem to know quite what to do with herself, besides continuing to sing exquisitely. Disappointingly, the chair against the door is a "Chekhov's gun" which never goes off. Later in the scene, Bartolo knocks on the door, and Rosina simply moves the chair and opens it to let him in. "Sarò una vipera" indeed.

[Paolo Bordogna](/scene/people/paolo-bordogna/) brought a bounty of buffoonery to the jealous Doctor Bartolo. Clearly a master of slapstick, Bordogna was another victim of Kazaras' weak direction, blustering around the stage often without any real purpose. Most of his gags failed to land, especially in a strange scene where he is dodging fans that Rosina is throwing at him (Where did they come from? Why does she have so many of them? Is that the joke, I guess?) before catching one and throwing it back at her in a purely bizarre bit of staging.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124416315/IsabelLeonardRosinaandBassPaoloBordognaDr.jpg.jpg)
<figcaption>Isabel Leonard (Rosina) in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

As the scheming music teacher Don Basilio, [Wei Wu](/scene/people/wei-wu/) sings with a warm, dark bass voice that fills the house, but appears a bit stiff in the staging.  It seems he isn't particularly comfortable with comedy, but nevertheless he earns one of the biggest ovations of the night in the first half of Act II, not for his singing, but for catching a series of pastries, thrown by his fellow cast members, using only his hat, and then hilariously plopping the sweet-filled hat right back on his head!  This scene is the strongest of the evening, the cast finds a rhythm that the rest of the opera lacks, bouncing jokes off each other, creating hilarious sight gags - like Almaviva and Basilio dressed identically, sizing each other up, and the previously mentioned pastry tossing game which felt like a circus act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124429197/TenorTaylorStaytonAlmavivaandBaritoneAndreyZhilikhovskyFigaroforWNOsTheBarberofSeville_creditScottSuchman.jpg.jpg)
<figcaption>Taylor Stayton (Almaviva) and Andrey Zhilikhovsky (Figaro) in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

I have a soft spot for comprimario singers - it can be a thankless job, singing forgettable roles with few lines, or just filling out the harmony in ensembles, so I thought Alexandria Shiner, who sings Berta, deserves a high-five for interpolating an earth-shattering high C-sharp at the end of her oft cut second act aria, jolting any dozing audience members back to attention.

Although some of castmembers' vocals left something to be desired, several ensemble numbers are the musical highlights of the show, sung crisply by the cast with surprising precision and elegance given what the staging asks of them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525124358018/FinaleinWNOsTheBarberofSeville_creditScottSuchman.jpg.jpg)
<figcaption>The Finale in *The Barber of Seville*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

The opera's finale was almost as absurd and frenetic as the finale of the first act, with the entire company crowding the stage, and, in case you forgot that this whole thing has taken place in Spain, they all break into flamenco. As the music builds to its final cadence an enormous portrait of Rossini is flown down from the rafters. Why? I suppose someone will have to ask Mr. Kazaras.

>[*The Barber of Seville*](http://www.kennedy-center.org/calendar/event/OSOSE) runs at the Kennedy Center through May 19. For details and tickets, [click here.](http://www.kennedy-center.org/calendar/event/OSOSE)
