+++
author = ["authors/laura-attridge.md"]
categories = "Op-ed"
date = "2018-09-29T11:43:00-04:00"
lastmod = "2018-10-02T19:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538237803574/cactus.jpg.jpg"
publishDate = "2018-10-02T19:29:00-04:00"
related_articles = ["articles/how-to-throw-a-funeral-for-a-viola.md","articles/art-is-not-action.md"]
short_description = "We each go through life with our own subjective experience of the world around us: a personal story as unique and beautiful as a fingerprint, but with implicit bias and limitation. Art allows us the opportunity to reach out to one another, to find connections and disparities, to compare notes on different ways of seeing the world. "
slug = "leaning-into-the-discomfort"
title = "Leaning into the discomfort"
+++

It is a question I consider often: why do I make art? What is it that compels me to write and direct? I think Kazuo Ishiguro came the closest to summing up the impulse when he said, in his Nobel acceptance speech in 2017, "in the end, stories are about one person saying to another: This is the way it feels to me. Can you understand what I'm saying? Does it also feel this way to you?" 

We each go through life with our own subjective experience of the world around us: a personal story as unique and beautiful as a fingerprint, but with implicit bias and limitation. Art allows us the opportunity to reach out to one another, to find connections and disparities, to compare notes on different ways of seeing the world. 

As a maker of opera and theatre, my currency is narrative: each new project presents me with a new story, and for each one I must ask myself anew "Who am I at this moment? What is my own story in relation to this one?" I must have faith in the singularity not only of my skill as an artist but also of my experience as a human being in the world today. By doing so, I avoid the dangers of striving for originality for its own sake, instead serving the art by offering my own uniqueness to it, and trusting this to be enough.

The joy, however, of working in opera and theatre is that mine isn't the only story in play. Opera, in particular, is a collaborative art form at its very core: for a piece to be conceived in the first place you need both words and music, ideally through the collaboration of a librettist and composer, each bringing their respective skill and unique humanity to a story. Once written, the piece requires further layers from additional individuals to bring it to the rehearsal room and subsequently to the stage: director, conductor, designer, lighting designer, and so on; not to mention the performers themselves. 

Every individual involved in the process has a world view as unique as my own, and the greatest pleasure of working as a director in opera can be found in bringing together a team to interpret and realise a piece through the prism of our collective individualities. Even then, however, the job is not finished. There is a final collaborator to add: the audience. 

In his book, *Different Every Night*, celebrated director Mike Alfreds describes live theatre as a shared act of imagination between performers and audience; this holds true, I think, for opera as well. In other words, each audience member is an active participant in the completion of an act of performance.

It is helpful to think of an audience not only as a collection of individual minds but also a collective force of imagination and interpretation. Both are a product of context - historical, social, political and so on - just as the creative team are, and both affect the interpretation of what ends up on stage in performance. 

This leads to more questions for me during the creative process: who are my audience? How do I best reach out to them? How do I challenge them, question them? One of the prevalent dialogues in public consciousness at the moment, for example, is a feminist one: social media and online journalism are allowing higher-than-ever awareness of feminist issues, in particular the representation of female experience, through campaigns like #MeToo. Women are able to reach out over the internet and ask "Does it also feel this way to you?", and receive a resounding "yes!" at a higher volume than ever before; to those who answer "no", they can respond "but can you understand what I'm saying?" 

Many other marginalised groups, of course, are able to do the same: there is easier access to the stories and experiences of people different from oneself than ever before. It is highly unlikely for an audience in this country, at this moment in history, not to have some awareness of this phenomenon.

At the same time, we are currently at a moment of great change for opera: its value and relevance are in question; the art form itself is being broken open and critically examined. Many claim opera is in crisis, but I look around me and see a new generation of dynamic artists already bringing new energy and new voices to an "old-fashioned" art form still struggling within the constraints of its own history. I see young artists in all operatic disciplines passionate about the future of opera, and less willing to accept it in its older forms, and I see hope. For me, this future lies primarily in the writing of new work which responds directly to the ever-changing world around us, and invites a more diverse variety of voices and stories to the stage than we have been used to. 

However, this is not to discount those classic works already firmly placed within the operatic repertoire, many of which have survived hundreds of years: the best of these pieces are in the canon for good reason, and this should be acknowledged alongside an understanding of the patriarchal biases within history (giving primacy to male composers, male conductors, and so on) which have shaped the canon itself. These pieces are not going to be dropped from the repertoire anytime soon, so how are they to be approached in the here and now, and in the future?

Over the summer I have directed two pieces widely held to be problematic in their presentation of female experience: Britten's *The Rape of Lucretia* and Mozart's *Don Giovanni*. Both pieces were written by male creative duos (Benjamin Britten and Ronald Duncan; Mozart and Lorenzo Da Ponte), a circumstance immediately limiting the shared subjective experience from which to draw a story. This limitation is evident in both operas, and leads to significant discomfort for a female director approaching either with an intent to realise either piece on stage. 

One's immediate instinct is to solve the problems, add a layer over the top which apologises for, or papers over the difficulties and the discomfort. But this is to do a disservice both to the piece and to the audience; by contrast, to acknowledge the ambiguities and complexities of pieces like these is to accept that their creators were individuals who made an attempt to tackle fundamental human experiences as far as their own subjective narratives would allow. It is to acknowledge that this is what you are doing, too, as you realise the piece on stage.

At the very pivotal moment of *The Rape of Lucretia*, Male and Female Chorus - the narrators of the opera - turn and look away from the physical violence of the assault, and instead call out to Jesus and the Virgin Mary to redeem the sin of the act; they cannot, or will not, look at the rape itself. It would be easy to criticise Britten and Duncan for this omission, interpreting it as a cop-out of sorts; more interesting is to interpret it as a provocative and deliberate decision, a calculated failure that challenges the director with its inadequacy and allows for the emergence of the director's own unique story, and the unique context of the production, in relation to the original piece. 

Male and Female Chorus may look away, but that doesn't prevent the rape from happening, or the impact it has upon the characters on stage and on the audience. Right now, campaigns like #MeToo are asking us not to look away from the realities, however uncomfortable, of female experience; as a young female director in 2018 I don't want to look away: I want to lean into the discomfort I feel, and say to my audience, "This is the way it feels to me. Can you understand what I am saying? Does it also feel this way to you?"
