+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-07-12T15:07:00-04:00"
lastmod = "2018-07-12T15:07:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422311199/sqDSC_6359.jpg.jpg"
primary_image_credit = "Flight, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera."
publishDate = "2018-07-12T15:07:00-04:00"
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/elise-quagliata.md","scene/people/audrey-luna.md","scene/people/john-holiday.md"]
short_description = "What struck me most about this work by Jonathan Dove and April de Angelis is the intricate, layered nature of the music and text. I could see numerous performances of this opera and discover something new about it everything single time. Great comedy should make us think, and Flight provides plenty of food for thought."
slug = "layered-comedy-flight"
title = "Layered comedy: Flight"
+++

"Soon our journeys will start!" We are all captivated by the idea of reinventing ourselves. All we need is a fresh start or a chance to escape our normal routine. Travel is seen as a gateway to adventure and unknown opportunities. [Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/)'s production of [*Flight*](http://desmoinesmetroopera.org/productions/flight/) captured the magic of travel and the complex emotions that go with it.

The set design by R. Keith Brumley was sleek and reminiscent of both futuristic and retro airport architecture. The space provided a neutral backdrop that was colored by the emotions and actions of the characters onstage. There were three distinct realms within the airport: the Controller’s high tower, isolated and immaculate, the main hangar where the messier human interactions took place, and the unseen lower levels from which the dreaded Immigration Officer would emerge. Travel can be both thrilling and stressful, but the interpretation is entirely dependent on the individual. The airport becomes symbolic of possibilities, both positive and negative.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422182571/DSC_6721.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The orchestra, led by David Neely, provided the musical textures of each character as well as the vibrant feelings associated with the sky. In the first act there were moments when the orchestra overpowered the singers, but this issue seemed to get corrected by the second act. 

Although composer Jonathan Dove and librettist April de Angelis created this opera twenty years ago, the subject matter is still thoroughly relevant. The plight of refugees has become a worldwide discussion, and the interactions between the Refugee and the other characters in the opera feel all too familiar. In the first act, his requests for help are met with discomfort and indifference. The travelers do not want to be inconvenienced. We have all heard similar phrases from people who don’t want to be confronted by difficult issues. "It's not my problem." "There's nothing I can do." "Rules are rules." They are too fixated on their own personal concerns to empathize with a stranger, and we have all done that at some point in our life. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422196114/DSC_6415.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

While there are some heavier themes within *Flight*, the majority of the opera is energetic and brimming of humor. Relationship issues dominate the minds of the travelers, and as they are trapped in the airport together overnight, antics ensue. Ironically, everyone is seeking a new beginning, but at the end of the opera, no one has truly altered their course.

Dove creates specific musical colors and styles for each character, and his choice of voice types runs along a wide spectrum. The Controller, sung by [Audrey Luna](/talking-with-singers-audrey-luna/), rules the stratosphere. Luna, who is renowned for her high notes and interpretations of challenging modern opera roles, performs this demanding music with an enviable ease. I was impressed by how impeccable her diction was at the top of her range. Luna portrayed the Controller with superiority and snark. This character thinks very little of her fellow human beings. They disrupt her sense of order and distract her from the clean sky. She does have a possessive, soft spot for the Refugee, but she can be vindictive towards him as well. Their relationship was intriguing and left me with a lot of unanswered questions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422206402/DSC_6242.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The Refugee, portrayed by countertenor [John Holiday](/talking-with-singers-john-holiday/), represented the middle of the vocal spectrum. Holiday evoked such a lovely variety of emotions throughout the opera. At times he was like a ray of sunshine on the stage, an eternal optimist despite his circumstances. The little moments were sometimes the most heartbreaking. In the second act, at one point the female travelers are sharing a drink with him, and he is so excited to call them his friends. In that moment, you could see how lonely this man is. Dove's decision to write the Refugee as a countertenor highlights the character's isolation. His voice is otherworldly and reminiscent of magical, fairy characters in other operas. The Refugee is trapped in the airport. He cannot go forward or go back like the other travelers. He is in limbo, hiding and waiting. Holiday's emotional and vocal performance reached their height in his final aria in which the Refugee shares the tragic story of how he and his brother escaped their country. It was harrowing and haunting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422215848/DSC_6370.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The low end of the vocal spectrum was inhabited by bass Zachary James, the stoic Immigration Officer. While this character is only onstage for a short portion of the opera, just a mention of his title created a menacing atmosphere. James is an imposing presence both physically and vocally, and he contrasts the other characters with his more controlled melodic lines. In the end, even the stern authority figure shows some compassion and humanity, letting the Refugee stay in the airport indefinitely.

The remaining characters landed in various levels of the spectrum and supplied the more comedic moments of the plot. We were first introduced to Bill and Tina, a couple trying desperately to rekindle their romantic fire. The pair, played by Andrew Bidlack and Zulimar Lopez-Hernandez, felt like they walked straight out of a quirky rom com, decked out in tropical tourist gear and brandishing a copy of their self-help relationship book. Bill had one of the more interesting character arcs in the opera (albeit an adulterous one), but it was all undone by a blow to the head (from the relationship book of all things) which triggered the cliched plot twist of sudden amnesia. I was disappointed by this storytelling choice. I understand that *Flight* is a comedy, but the quick fix happy ending felt like a bit of a cop out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422226627/DSC_6269.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

In contrast, the Steward and Stewardess were a couple enthralled in the excitement and attraction of a new relationship. These two airport employees, portrayed by Theo Hoffman and Sofia Selowsky, were constantly in heat, sneaking behind any nearby object to have their way with each other. Both Hoffman and Selowsky balanced the fake professional cheer and underlying sexual urges hilariously. The Steward it seems is just obsessed with sex in general rather than a specific person, and when Bill accidentally propositions the other man, the Steward doesn't hesitate to drag him up to the control tower for an illicit rendezvous. 

The art of the comedic aside was mastered by Deanne Meek as the Older Woman. She is waiting for her fiance who is decades younger than her, and Meek plays the character with both cynicism and vulnerability. She is also a divorcee, so she had plenty of snarky comments to make about Bill and Tina's relationship advice. Despite the sarcasm, the Older Woman still believes in love even if it hasn't worked out for her before.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422239624/DSC_6337.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The final couple of the ensemble is a diplomat and his pregnant wife on their way to Minsk. The Minskwoman, sung by [Elise Quagliata](/scene/people/elise-quagliata/), has some of the most beautiful and conflicted music of the opera. She cannot bring herself to get on the plane to start her new life and tells her husband to leave without her. Her second act aria was one of the musical highlights of the opera, and Quagliata brought a depth and richness to the vocal lines even as she extracted a plethora of baby garments from her bag. This woman wants to return to the freedom and selfishness of her past, but she is on the cusp of motherhood which threatens her sense of identity. In the final act, her husband, played by Norman Garrett, comes back for her in a stiff albeit genuine proclamation of love, and to top it all off, she gives birth to her baby in the airport hangar! (Which left me with a few questions. Was the baby premature? If so, no one seemed too concerned about it. If not, should a woman that heavily pregnant have been flying on a plane in the first place?) It is the cleanest, easiest birth in history, and the Minskwoman makes a miraculously swift recovery. She is running around the stage in her stilettos almost immediately, and at the end of the opera, the whole family hops straight onto a plane for a foreign country. (Again, no one was concerned about after birth care for mom and baby?)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531422289866/DSC_6810.jpg.jpg)
<figcaption>*Flight*, Des Moines Metro Opera, 2018. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

In the nature of any good comedy, *Flight* relies on a true ensemble cast. Director Kristine McIntyre enhances the fluctuating emotions and interactions of the characters with strategic visuals. The excitement of a plane taking off is made grand as the travelers expand across the stage. More intimate moments like the women bonding over booze are brought downstage and close to the audience. Sexual encounters are mostly hidden with quick teases of flailing limbs and discarded clothing. 

What struck me most about this work by Jonathan Dove and April de Angelis is the intricate, layered nature of the music and text. I could see numerous performances of this opera and discover something new about it everything single time. Great comedy should make us think, and *Flight* provides plenty of food for thought.
