+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2023-10-18T00:00:00+00:00"
lastmod = "2023-10-18T00:00:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1697636486/Latonia_image.jpg"
primary_image_credit = "American soprano Latonia Moore, set to perform in San Diego Opera's Grammy Greats Unite concert, alongside mezzo-soprano J'Nai Bridges."
preamble = ""
publishDate = "2023-10-18T00:00:00+00:00"
related_articles = ["articles/talking-with-singers-elizabeth-caballero.md","articles/talking-with-singers-elizabeth-deshong.md","articles/talking-with-singers-peter-mcgillivray.md","articles/andrew-staples-messiah-and-multitasking.md","articles/talking-with-singers-leah-crocetto.md","articles/spotlight-on-michael-nyby.md","articles/spotlight-on-aidan-ferguson.md","articles/talking-with-singers-christine-goerke.md","articles/spotlight-on-rolando-sanz.md","articles/arianna-zukerman-youve-got-to-live-your-truth.md","articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/spotlight-on-lara-ciekiewicz.md","articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-christian-van-horn.md","articles/talking-with-singers-jamie-barton.md","articles/talking-with-singers-corinne-winters.md","articles/talking-with-singers-melody-moore.md","articles/what-weve-learned-by-talking-with-108-opera-singers.md","articles/talking-with-singers-keri-alkema.md","articles/talking-with-singers-marina-rebeka.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/jnai-bridges.md"]
short_description = "'When [you ask me why] I sing, I get a wonderful release, a release of stress, an emotional release. I also I like the giving to people and I like making them feel goosebumps. I like making them feel emotional, want to cry or want to throw something. I like eliciting an emotional response from them.'"
slug = "latonia-moore-its-our-job-to-keep-pushing-things-forward"
title = "Latonia Moore: 'It's our job to keep pushing things forward.'"
+++
American soprano [Latonia Moore](/scene/people/latonia-moore/) will be performing for one night on October 25 at the Balboa Theater, billed by San Diego Opera as [_Grammy Greats Unite_](https://www.sdopera.org/shows/latonia-moore-and-jnai-bridges-in-concert/). Moore will be performing with American mezzo-soprano [J'Nai Bridges](/scene/people/jnai-bridges/).

Moore and Bridges sang _Madame Butterfly_ at the [San Diego Opera](/scene/companies/san-diego-opera/) in 2016. They became good friends during that run but rarely get to perform together. "She's a beautiful singer, beautiful woman and a great colleague," says Moore. Years before in 2013, Moore made her San Diego Opera debut in _Aida_. "Because we have this close relationship, we kind of know how to bring certain things out of each other," says Moore. 

She says she has chosen a more ambitious repertoire for duets than she might have if she wasn't so comfortable with Bridges. They will be singing the duet from _Madame Butterfly_ and also from _Lakmé_. "In the _Lakmé_ duet, I really need to lean on her voice, especially in the middle voice to support my top in a duet like that. If you're with a mezzo that you don't know very well it's just two singers separately singing and you don't feel this togetherness that you feel when you have a good sort of energy with the person."

"I trust her not just as a friend, but as a supportive vocalist," she says. There will also be a surprise for the audience. "J'Nai is going to sing an aria that I'm known for and I'm singing an aria that she's known for. It's hard to figure out what those two arias are but that's the deal, that's our little surprise for the concert." Moore will also be singing "L'altra notte" from _Mefistofele_ as well as a little Mozart, something she says that audiences don't expect from her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1697636487/Latonia_Moore_and_J_Nai_Bridges.jpg){{% /md %}}

<figcaption>For this season's five diverse productions, the San Diego Opera chose an illustrator to create the season artwork in one dynamic illustrative style. This cohesive approach draws interest and attention to San Diego Opera's brand and the season's memorable performances. Each production's illustration will be created utilizing this dramatic visual approach featuring character portraits with strong 'light and shadow,' vivid colors and iconic symbolism. Jordi Ferrándiz is a Spanish designer and illustrator born in Barcelona, who studied graphic design at the Llotja School of Applied Arts (1992-1997). He has collaborated for clients such as The New Yorker, City and State NY, University of Rhode Island, ACG Media at ACG Global, Penguin Random House, Bic, Wealth Management Magazine, Texas Highways Magazine, Deseret Mag, and Universität de València. He is known for his dynamic composition, bright and powerful colors, and elegance of forms in his illustrative portraits, posters, books and packaging.</figcaption>  
</figure>

Moore is very passionate discussing how opera needs to evolve to attract new audiences.

It's not just about contemporary or modern opera, she says, but relatable themes. "It's important to tell stories that people care about right now. When a person goes to see _La bohème_, it's a gorgeous story, it's believable, it's adorable, it's hilarious, it's sad, it's touching, but it's not relatable to now. Even if you update it, these are not things that relate to now. But if you do an opera like Terence Blanchard's _Champion_, that absolutely relates to now, to people still having to deal with being discriminated against because of their sexuality, and dementia, and having to hide who you are. This is a very now topic."

"In the case of _Dead Man Walking_, although it was written 23 years ago, it's about a problem that we still unbelievably have: the death penalty. And not only that, but every man on earth still deals with having to forgive someone, having to move on, maybe having to redeem themselves. These are qualities in an opera that the layman can relate to."

"It's hard for the layman to relate to _Boris Godunov_. It is a fantastic opera for the opera buff. We want to keep the opera buffs happy because it's the best, the reason we're still here but we also need to attract a new audience," she says. "Opera needs to move forward or it will die."

She adds that the opera world is at the moment making a good space for contemporary opera, which is
at the forefront, and attracting new audiences. "You need the canon and you need new contemporary operas. You need both," says Moore. "And for me as a performer, as much as I've always preferred singing verismo and Italian opera, I'm glad to be a part of the American movement of opera right now and the Black American movement of opera."

Moore says that before the pandemic, she wasn't encouraged to sing Black operas, maybe because people worried about her ending up pigeon-holed. She points out though that she started out as a jazz singer.

"The fact that the two Grammys that I had are for jazz operas is not lost on me. It's a full circle moment for me," she says.

"It told me that even though I love _Tosca_ and I love singing _Butterfly_ more than any other opera, I sincerely believe that the reason that I am here, and I ended up being an opera singer, was to do _Porgy_ and _Fire Shut Up in my Bones_, especially _Fire_. I almost felt like that's the reason I was born to do something like that and to tell that kind of story."

"And the amount of people that I touched with that story makes me feel very, very proud," she adds.
The story of _Fire Shut Up in my Bones_ was hard for Moore because it was so close to her own life. "Down to the names that are the same as the people of my family, and down to five children and my mom having to take care of them and my dad philandering and going out with other women. It was very, very real for me," she says.

"When the opportunity to do this opera came around, I jumped at it. Regardless of whether or not it
was jazz opera, and although I knew it would kind of throw my technique off a little bit, that didn't matter to me. Telling the story was much more important than whether or not I had a beautiful _bel canto_ line. It went beyond."

"I did _Fire_ to heal people, to please them, to tell them a gut-wrenching story that came directly, not just from Billie Blow, my character, but from me, Latonia."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1697636486/Latonia_Moore_-_October_2023.jpg){{% /md %}}

<figcaption>American soprano Latonia Moore. Photo: Coco Jourdana.</figcaption>  
</figure>

"When [you ask me why] I sing, I get a wonderful release, a release of stress, an emotional release. I also I like the giving to people and I like making them feel goosebumps. I like making them feel emotional, want to cry or want to throw something. I like eliciting an emotional response from them. It's a great release and I like to please people. I like the pleasure."

Moore says she would love to see more opera that is a reflection of what America actually is.
"America is a rainbow of people. That's who we are. That's what the country was actually built on. When I look at _Dead Man Walking_, we have such a mixed race cast. I love seeing it because it's reflective of what our country actually is."

It's not necessarily about having more Black operas, she says. Too much Black opera and Black stories can make people who are not Black feel isolated. "They're kind of left out and even if they don't feel left out, they almost overdo it trying to understand, just to seem cool or not offend anyone," she says. "This is what I'm taking issue with as far as Black operas."

Black operas often end up telling tragic stories and not the stories and comedies that are also part of the Black community. An exception is _The Factotum_ by [Will Liverman](/spotlight-on-will-liverman/), who was the star of _Fire Shut up in My Bones_ at the Met and sang the role of Charles Blow. His opera premiered last season at Chicago Lyric.

Moore says the opera is not tragic but funny, lighthearted, and tells a real story. She says it's a "nice refreshing take on Black lives in America." 

"If we're going to do more modern opera, let's do more eclectic stories, maybe take more things from movie screenplays and stuff like that and put different kinds of people in it." Moore is also passionate on the subject of whether Aida should be sung by a Black singer. "I get so upset when people are up in arms and say Aida is supposed to be Black, that you should have a Black Otello or a Japanese Madame Butterfly. I disagree vehemently because it completely discredits why I decided to do this."

"When opera started back in the 1600s, the whole premise was that it was for the poor people, for the
peasants, and that people could get up and sing things that weren't necessarily them. Men were singing the roles of women. People liked the idea that an opera took place in Sri Lanka or another exotic place because they finally had that artistic outlet to be exotic. It was a place where we could be something else, where we could transform and be chameleons. It's why I decided to be an opera singer."

Moore recounts a discussion about Will Liverman, starring in _X: The Life and Times of Malcom X_ this
season at the Met. She says people were upset that Liverman, who is five foot six, is playing Malcom X
who was about six feet four.

"But do I look like a 15-year-old Geisha? They're talking about a genre in which we suffered so much
discrimination and now there's a Black man playing Malcolm X and because he's not ten inches taller they're up in arms about it. That would mean I cannot be Butterfly, I cannot be Desdemona, I cannot be
Tatiana and I can't be Jenufa. Can I only be Aida?"

"Everybody is so gung-ho to jump on this woke bandwagon - that it has to be this way and it has to be
that way and it has to look like this. They're destroying opera with this attitude. Opera can look like anything. And it should look like anything and everything," Moore says.

"I think we can push the envelope a little bit. We can explore different stories that that don't have to be just stories reflective of where we are today and they don't have to be grand stories like Turandot either."

"We can tell the whole in-between as well and we can do it with a person that looks like anything.
There's no reason why a big, thick obese woman like me can't be a sexual object. And there's no reason why a five foot five baritone [like Will Liverman] can't be Malcolm X."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1697636505/J_Nai_Bridges_-_October_2023.jpg){{% /md %}}

<figcaption>American mezzo-soprano J'Nai Bridges. Photo: Freddie Collier Photography.</figcaption>  
</figure>

Moore finds discussions about painting Aida Black equally upsetting. "The truth is Aida has nothing to do with being Black. It's a story of war. Those people are African but no one mentions what color anyone is ever in this opera."

It's different in _Otello_ because what happens to him is because he's Black. "I've done _Otello_ before with Stuart Skelton who is an Australian white tenor. Stuart Skelton was dressed all in black and his eyes were sunken in. He looked like a corpse almost and I looked like an absolute angel dressed in all white, with a silver highlight all over my body. I was this deity. He was this dark black cloud and I was the silver light. It was a beautiful telling of a story. We told the story in Norway of all places, and the Norwegian people loved it. They loved how black this Otello was without his skin being black."

"If we could get back to suspension of disbelief, keeping things exotic, changing it up, and keeping it different and interesting, then we'll keep thriving. It's our job to keep pushing things forward. in order to do that, we can't go back to this antiquated way of thinking and we cannot move to opera segregation. Jesus, that's going to kill it," she says.

"It's a train that's constantly moving, whether you're dead or not. So do your part while you're here. That's how I feel about it."