+++
author = ["authors/daniel-weisman.md"]
categories = "Review"
date = "2017-09-29T18:43:00-04:00"
lastmod = "2017-10-02T15:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952744507/2017-10-02---JB4A9001.jpg.jpg"
primary_image_credit = "Jennifer Larmore in The Seven Deadly Sins, Atlanta Opera, 2017. Photo: Jeff Roffman Photography."
publishDate = "2017-10-02T09:59:00-04:00"
related_companies = ["scene/companies/the-atlanta-opera.md"]
related_people = ["scene/people/jennifer-larmore.md","scene/people/christopher-dunham.md","scene/people/bryn-holdsworth.md"]
short_description = "The laziness that the characters feel in having to get ready when the star diva hasn&#039;t arrived (sloth), the pride that Mr. Dunham&#039;s self-named character feels towards Ms. Holdsworth, Ms. Larmore&#039;s cameo can be seen as anger and covetousness towards Holdsworth&#039;s envy, Mr. Munson&#039;s alcoholism is addressed as gluttony, Ms. Holdsworth&#039;s lust towards Mr. Dunham, Mr. Munson, and Mr. Stolz, all is masterfully and subtly woven into the script by director Brian Clowdus, helping tie in his cabaret to the front-billed one-act."
slug = "larmore-leads-sinful-success"
title = "Larmore leads &quot;Sinful&quot; success"
+++

Since taking over as General and Artistic Director in 2013, [Tomer Zvulun](/tomer-zvulun-the-atlanta-operas-intriguing-201718/) has been praised for revitalizing the image of [The Atlanta Opera](/scene/companies/the-atlanta-opera/) by bringing in new talent, extending the span of their season, helping start the Atlanta Opera Studio Program (now in its second year), and Atlanta Opera's Discoveries Series, a series dedicated to providing audiences with new or lesser known works presented in different venues than one would normally expect when going to see an opera. Past Discoveries performances have included Jake Heggie's *Three Decembers* and Mozart's [*The Secret Garden*](/la-finta-giardiniera-coming-to-a-garden-near-you/), which was presented last spring in conjunction with [On Site Opera](/scene/companies/on-site-opera/). This year has been no exception in expanding Zvulun's vision of The Atlanta Opera's success, presenting six full productions (two of which are presented as a part of the Discovery Series) and a studio tour meant to feature local Atlanta talent as well as the young artists in their Studio Program.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952545297/2017-10-02---JB4A6139.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

One of their Discoveries Series presentations is their current run of Kurt Weill and Bertolt Brecht's [*The Seven Deadly Sins*](https://www.atlantaopera.org/performance/seven-deadly-sins), presented in an English translation by famed British poet W.H. Auden and American poet Chester Kallman. Weill, a German-born Jew, understandably fled his country to France where he was commissioned in 1933 to work on what would later become a "sung ballet" called *Die sieben Todsünden* or *The Seven Deadly Sins*. The piece follows the character Anna, as split in personality by Anna I, the singer, smart and cynical, and Anna II, the dancer, beautiful and empathic. Anna leaves her family in Louisiana in search of the big cities in which a girl can find enough fortune to send to her family and allow them to build a grand home overlooking the Mississippi. A male quartet narrates as Anna's family, watching their sister and daughter navigating through the big cities, experience every one of the seven sins - all leading towards numerous life lessons and the audience's fitting realization: Kurt Weill was woke.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952470029/2017-10-02---JB4A6537.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

The work only runs about thirty minutes - not nearly long enough to warrant a full night at the opera, which is why I was confused as to how The Atlanta Opera was swinging a production with a run-time of ninety minutes plus an intermission. I was happy to learn, upon arrival, that they had programmed their first act as a Kurt Weill cabaret, supplementing the shorter show with an act's worth of Weill musical theatre and opera, sung by the gentlemen singing the family quartet who would be featured in *The Seven Deadly Sins* and the soprano Atlanta Opera Studio Artist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952498095/2017-10-02---JB4A9509.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

The cabaret and *The Seven Deadly Sins* were both presented inside Le Maison Rouge at Paris on Ponce, a distinctive gem between Midtown and North Druid Hills inside the perimeter of Atlanta, with a long catwalk contained in an almost thirties styled burlesque stage. The cabaret portion of the evening started casually, with the conductor, Rolando Salazar, at the onstage piano, a paper call board and sign in sheet taped to a support beam, and a bevy of characters in various states of dress, seemingly preparing for the night's production and emphasizing on the evening's theme of lust. At the start, the cast's dialogue seems choppy and forced, they goad each other on about signing in on the call board until Salazar asks if they need to run anything before the performance started. What would a Weill cabaret be without Weill's famous "Mack the Knife", as sung by baritone [Christopher Dunham](/scene/people/christopher-dunham/), one of the Atlanta Opera Studio Artists. The action continues, allowing us to experience soprano [Bryn Holdsworth](/scene/people/bryn-holdsworth/), a second year studio member, as she navigates the concept of love with what seems like the entire men's cast, while also introducing works from Weill's *Street Scene*, *One Touch of Venus*, *Lost in the Stars*, *Threepenny Opera*, and more, before giving Ms. Holdsworth hope that diva, [Jennifer Larmore](/scene/people/jennifer-larmore/), won't make it to stage, allowing her to go on as Anna I.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952450689/2017-10-02---JB4A8661.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

While the script of the cabaret portion of the evening left a bit to be desired at first, it was easy to forget their rough start as the singing began. The cabaret served as a great introduction to some of the members of the Atlanta Opera Studio Program. Mr. Dunham's velvety smooth lyric baritone enriched the humor and slyness needed for Mack the Knife and the easy top that Justin Stolz's tenor brought to every operatic tenor's favorite, "Lonely House", was enough to draw all eyes to him. Ms. Holdsworth, who was is reprising her role as the Atlanta Opera Studio soprano from their inaugural season last year, perfectly balanced her well-tuned soprano with the musical theatre style needed to make Pirate Jenny one of the standout pieces of the evening. The cast was rounded out with tenor Nathan Munson, last seen as Emperor Altoum in The Atlanta Opera's production of *Turandot*, Calvin Griffin, whose lush bass stood out in the titular song from *Lost in the Stars*, dancers Priscilla Curtis, Brian Jordan, and Imani Joseph, whose presence helped round out the crowd and make the group pieces more successful, holding their own on a catwalk full of singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952553277/2017-10-02---JB4A9280.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

The diva of the production, Jennifer Larmore, makes a cameo appearance in the first-act cabaret, teasing us before the lights lift into intermission.

What's really impressive about the first act, which Weill never envisioned when he wrote *The Seven Deadly Sins*, is that we experience the sins through the cast's broken wall. The laziness that the characters feel in having to get ready when the star diva hasn't arrived (sloth), the pride that Mr. Dunham's self-named character feels towards Ms. Holdsworth, Ms. Larmore's cameo can be seen as anger and covetousness towards Holdsworth's envy, Mr. Munson's alcoholism is addressed as gluttony, Ms. Holdsworth's lust towards Mr. Dunham, Mr. Munson, and Mr. Stolz, all is masterfully and subtly woven into the script by director Brian Clowdus, helping tie in his cabaret to the front-billed one-act.

Clowdus's production of *The Seven Deadly Sins* was no different than his cabaret, the same simple set, minimal props, three moving mirrors and doorways, and expert costuming that allowed Anna I (Jennifer Larmore) and Anna II (Meg Gillentine) to appear synonymous. Ms. Larmore's expert mezzo-soprano was tinted with color and excitement, telling the story of her and her mischievous "sister" while Ms. Gillentine, who also choreographed the production, showed a more youthful and empathic side to Anna. The mirrors, moved forward by the same cast of dancers from the first act, this time accompanied by Ms. Holdsworth, allowed the Annas to merge into one, argue with each other, and even become separated.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506952617615/2017-10-02---JB4A8322.jpg.jpg)
<figcaption>*The Seven Deadly Sins*, Atlanta Opera, 2017. Photo: Jeff Roffman Photography.</figcaption>
</figure>

The piece showcased Ms. Larmore's unique voice and tremendous acting ability. At the same time, Ms. Gillentine isn’t one to be overshadowed, holding her own alongside Ms. Larmore and pushing me to the edge of my seat as I watched her cling to the rafters to escape the prying hands of the family and dancers as Ms. Larmore watched. The simple set, packed into the amazing atmosphere that Le Maison Rouge provided, helped create the perfect illusion of the America that Anna lived in, working in show business, as well as many other less glamorous occupations. My biggest criticism would be that the long, thin catwalk of a set left me nervous that the mobile mirrors, piloted by the family and the dancing ensemble, might catch the edge and topple into the reserved seating.

While most of the cast stays the same, the role of Anna I is cast with Ms. Larmore and Ms. Gina Perregrino, of the Atlanta Opera Studio program.

Overall, fitted with an amazing cast, a striking set, and an amazing three-piece orchestra (beautifully led by Maestro Salazar), *The Seven Deadly Sins* is a must see for any art lover in Atlanta.

>[The Seven Deadly Sins](https://www.atlantaopera.org/performance/seven-deadly-sins) runs through October 6. For details and ticket information, follow our box office links below.
