+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2017-10-23T13:27:00-04:00"
lastmod = "2017-10-24T23:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508779445548/2017-10-23---square---hgo---la-traviata---2017---photographer-lynn-lane-187-3000x2000.jpg.jpg"
publishDate = "2017-10-24T20:42:00-04:00"
related_articles = ["articles/a-shining-violetta-in-washington.md","articles/strong-ensemble-lifts-edmonton-opera-production-of-la-traviata.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/albina-shagimuratova.md","scene/people/dimitri-pittas.md","scene/people/richard-trey-smagur.md"]
short_description = "I would say that this production is a very reasonable first opera to go to, all things considered, and that this is a production which will have delights to offer any but the most snobbish operagoer. For the seasoned conoisseur, it will offer orchestral variety, fluent dramatic text-setting, and proof that Italian composers can simultaneously manage subtlety ands passion."
slug = "la-traviata-shows-houston-how-to-arise"
title = "La traviata shows Houston how to arise"
+++

(A disclaimer for those expecting references to the momentous sporting events of Saturday last: the only bases in this review are double basses.)

After an adventure which consisted of finding a new parking garage for the [Houston Grand Opera](/scene/companies/houston-grand-opera/)'s production of Giuseppe Verdi's *La traviata*, relocated to the purpose-built Resilience Theater in the George R. Brown Convention Center from the Wortham Center (which has sustained massive flood damage in the recent hurricane season), I was not entirely sure what to expect upon entering said venue for the first time. This being said, the theatre I encountered was entirely serviceable for the purpose, and it had the bonus of forcing the audience to consider anew the actual theatrical process. The prodigious challenges faced in rendering this stage suitable for a theatrical performance were rendered manageable by its intrepid designers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780596550/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-14-3000x2000.jpg.jpg)
<figcaption>Dimitri Pittas (Alfredo), Richard Trey Smagur (Gastone de Letorières), Albina Shagimuratova (Violetta) and the HGO Chorus in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

The room was very big and very dark, with plenty of room for stage apparatus and for entrances. The orchestra was placed behind the elevated stage, rather than in front of it. This rendered the orchestra considerably difficult to hear and muffled at times and necessitated an auxiliary conductor to conduct the singers onstage, for some reason not clearly identified in the program. He deserves the highest accolades. As a church organist, I can attest that the challenges of coordinating sound in different segments of a building are entirely real and necessitate the utmost concentration. Despite these challenges, the tempos were quite agreeably brisk and did not drag for an instant, thanks to the leadership of Maestro Eun Sun Kim. This being said, this looked on first appearance to be a more naturally suitable stage for an orchestra concert rather than an operatic performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780621353/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-34-3000x2000.jpg.jpg)
<figcaption>The HGO Chorus in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

The production was a minimalist affair, with a paucity of furniture, but the layout of the stage ensured that such moveables were items around which the chorus could inevitably and easily congregate. However, the lighting was extremely dark on stage throughout, giving the whole theatre the aura of a silent film. This made acting skills extremely necessary, and the perceived lack thereof rather glaring. I appreciated the subdued tone that the lighting gave in harmony with Verdi's arguably less passionate "Parisian" tint, though one could argue that this carried the resemblance a bit far. It rendered quite humorous Violetta's Act III line "A little more light, please," at any rate.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780640406/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-133-3000x2000.jpg.jpg)
<figcaption>The HGO Chorus and dancers in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

The theatrical setup was inevitably difficult to deal with for everyone, and it rendered even the normally impeccable Houston Grand Opera Chorus at isolated intervals incomprehensible to me, though I tried my very hardest to make them out. I earnestly hope that this experience has been informative to them in terms of rendering consonants assertive in unfamiliar spaces. Their acting skills were entirely authentic, however, and definitely highlighted the perception of Violetta's salon as a not entirely Victorian affair. Myriad oversized skeletal bulls made their appearance in the Spanish numbers, quite adding to that scene's eccentricity, though the matadors were rather more robust of voice than were the gypsy ladies. Several dancers also added to this scene's charm; their skill makes me lament that they are not put to use in something like Meyerbeer's Huguenots. The sheer delight which the chorus conveyed during their bizarre Carnival number, as they paraded between rows of the audience with the previously mentioned bovine skeletons, was utterly idiosyncratic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780651987/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-83-3000x2000.jpg.jpg)
<figcaption>Albina Shagimuratova (Violetta) and George Petean (Giorgio Germont) in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Romanian baritone George Petean was a superb Germont. In his best moments, he had a sincerity in his resonance reminiscent of Yevgeny Nesterenko, both with Violetta and with his son. Indeed, his costume, complete with black top hat and greenish coat, rather reminded me of the famous genial yet rustic portrait of Verdi himself.

Tenor [Dimitri Pittas](/scene/people/dimitri-pittas/) was agreeably earnest throughout, conveying all the passions of rebellious and impetuous youth. "Libiamo" was an especially promising start to a well-developed character. Throughout his scenes with Violetta ([Albina Shagimuratova](/scene/people/albina-shagimuratova/)), he was routinely the dominant figure, which, I sense, was the director's point in highlighting Violetta's role in the consumerist society she inhabits.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780663354/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-207-3000x2000.jpg.jpg)
<figcaption>Dimitri Pittas (Alfredo) and Albina Shagimuratova (Violetta) in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

To write that Shagimuratova's leggiero singing in "Sempre libera" was effortless and without fault is to state the obvious. To praise her limpid tone in the one verse of "Addio del passato" that actually got an airing does likewise. To describe her acting as Violetta, such as in the masterful *scena* "È strano," with apologies to Sir William Gilbert, I paraphrase *The Gondoliers*: "a chrysalis. She can't be said to live — she exists." Her performance felt rather sterile, even stylized; it exemplifies why I regard the cult of "aria worship" with caution and discretion.
 
In all fairness, this is likely a commentary on the static nature of Violetta as presented in this production: her pathos was inevitably conveyed more by the impassioned characters around her than herself. This would fall right in line with this production's emphasis on fatalism and Violetta's passive awareness of her destiny. As an example, as Violetta began to write to Alfredo in Act II, I felt that a lot of pent-up emotion that the orchestra implied was never adequately released, because Violetta displayed none, as if the outcome were inevitable. She only seemed to paradoxically come alive in her very last utterance before her demise, with obligatory seraphic violins to assist her, again reminiscent of the inherent melodrama of silent film.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780726205/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-19-3000x2000.jpg.jpg)
<figcaption>Dimitri Pittas (Alfredo) and the HGO Chorus in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>
 
As the Viscount Gastone, [Richard Trey Smagur](/scene/people/richard-trey-smagur/) led the way in terms of sheer conviviality and bonhomie, being quite literally the life of the party in voice and stage demeanor. In the role of Flora Bervoix, Zoie Reams had a sonorous lower register suggesting a predisposition towards serious repertoire; in this case, she and the Marquis D'Obigny (Ben Edquist) shared a very agreeably chatty and gossipy demeanour in Act II which entirely highlighted their acting prowess. As Annina, Yelena Dyachek showed tempered warmth towards her employer in all of her scenes, as did her voice seem to do also. Her reluctance to be embraced by the forbidding Dr. Grenvil (Anthony Robin Schneider) was an inspired touch; perhaps the physician felt himself unduly entitled? Various other roles were very ably filled by choristers: Jon Janacek as a very inquisitive Giuseppe, Cristino Perez as an officious, yet efficient, messenger, and Austin Hoeltzel as a servant who takes pride in the simple duty of announcing that dinner is served: may all hospitality workers follow his congenial example.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780676034/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-174-3000x2000.jpg.jpg)
<figcaption>Yelena Dyachek (Annina), Albina Shagimuratova (Violetta), and Anthony Robin Schneider (Dr. Grenvil) in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

Perhaps my favorite actor was Thomas Glass in the role of the Baron Douphol, an antagonist I have always been fascinated by since his motivations towards Alfredo have always seemed to me nebulous. Whatever the Baron's motivation, Glass clearly imbued it with inspired conviction. 
Paradoxically, the new Resilience Theater helped the orchestra by forcing it to achieve greater and fresher coloristic timbral variety than I have previously experienced when they perform works from the bel canto period. (They have set the bar quite high for *Norma*, therefore.) Nowhere was this better shown than in the prelude, where the solitary, exquisite muted violins gradually gave way to a fleshed-out, multi-colored string texture, leading to the main section of the movement, where violins, violas, and cellos were given plenty of room by warm winds and pizzicato basses to spin one of Verdi's characteristic languorous tunes out of the purest silk.

The offstage wind consort, led by Geoffrey Loff, was crisp, precise, and sufficiently gaudy to appropriately convey Parisian frivolity, and the fresh snare drum stylings of Karen Slotter were especially welcome in this context. My main objections were at conclusions of numbers, which were monochromatic, without perceivable shape, but this is par for the course.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508780903325/2017-10-23---hgo---la-traviata---2017---photographer-lynn-lane-35-3000x2000.jpg.jpg)
<figcaption>Albina Shagimuratova (Violetta) in *La traviata*, HGO, 2017. Photo: Lynn Lane.</figcaption>
</figure>

I would say that this production is a very reasonable first opera to go to, all things considered, and that this is a production which will have delights to offer any but the most snobbish operagoer. For the seasoned connoisseur, it will offer orchestral variety, fluent dramatic text-setting, and proof that Italian composers can simultaneously manage subtlety and passion. Here's hoping HGO surprises everyone with a *Luisa Miller*, *Les Huguenots*, *La Périchole*, or just a good concert of overtures sometime soon; they show they can do well with any such options as they lead Houston through recovery and into civic preeminence. *Per aspera ad astra!*
